package com.xforceplus.ultraman.oqsengine.plus.master.mysql.devops;

import com.xforceplus.ultraman.oqsengine.plus.common.executor.Executor;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor.AbstractMasterTaskExecutor;
import com.xforceplus.ultraman.oqsengine.plus.meta.pojo.dto.table.SystemColumn;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.*;

/**
 * Created by justin.xu on 12/2023.
 *
 * @since 1.8
 */
public class BatchDeleteExecutor extends AbstractMasterTaskExecutor<Collection<Long>, Boolean[]>  {

    private long startTime;

    private long endTime;

    private String table;

    public BatchDeleteExecutor(Connection connection, long timeout, String table, long startTime, long endTime) {
        super(connection, timeout);
        this.table = table;
        this.startTime = startTime;
        this.endTime = endTime;
        this.table = table;
    }

    public static Executor<Collection<Long>, Boolean[]> build(
            Connection connection, long timeout, String table, long startTime, long endTime) {
        return new BatchDeleteExecutor(connection, timeout, table, startTime, endTime);
    }

    @Override
    public Boolean[] execute(Collection<Long> ids) throws SQLException {

        try (Statement st = getConnection().createStatement()) {
            checkTimeout(st);
            for (Long id : ids) {
                String sql = buildSql(id);
                st.addBatch(sql);
            }

            return executedUpdate(st, ids.size() > 1);
        }
    }

    protected String buildSql(Long id) {

        StringBuilder base = new StringBuilder();

        base.append("DELETE FROM ").append(table);
        base.append(" ").append("where id").append("=")
                .append(id).append(" and ").append(SystemColumn.SYS_OPERATE_TIME)
                .append(" >= ").append(startTime).append( " and ").append(SystemColumn.SYS_OPERATE_TIME)
                .append(" <= ").append(endTime);

        return base.toString();
    }
}
