package com.xforceplus.ultraman.oqsengine.plus.master.mysql.devops;

import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.plus.common.StringUtils;
import com.xforceplus.ultraman.oqsengine.plus.common.executor.Executor;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor.AbstractMasterTaskExecutor;
import com.xforceplus.ultraman.oqsengine.plus.meta.pojo.dto.table.SystemColumn;


import javax.sql.DataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

/**
 * Created by justin.xu on 03/2023.
 *
 * @since 1.8
 */
public class RebuildExecutor extends AbstractMasterTaskExecutor<List<Long>, Boolean[]> {

    private IEntityClass entityClass;

    public RebuildExecutor(IEntityClass entityClass,  Connection connection, long timeout) throws SQLException {
        super(connection, timeout);
        this.entityClass = entityClass;
    }

    public static Executor<List<Long>, Boolean[]> build(IEntityClass entityClass, Connection connection, long timeout) throws SQLException {
        return new RebuildExecutor(entityClass, connection, timeout);
    }

    @Override
    public Boolean[] execute(List<Long> ids) throws SQLException {
        long sysTime = System.currentTimeMillis();
        try (Statement st = getConnection().createStatement()) {
            for (Long id : ids) {
                IEntityClass self = entityClass;
                while (null != self) {
                    addBatch(self, sysTime, id, st);

                    self = self.extendEntityClass();
                }
            }

            return executedUpdate(st, true);
        }
    }


    private void addBatch(IEntityClass entityClass, long sysTime, long id, Statement st) throws SQLException {
        if (null != entityClass) {
            String table = entityClass.masterWriteTable(false);
            st.addBatch(buildSql(table, sysTime, id));

            String profileTable = null;
            if (!StringUtils.isEmpty(entityClass.realProfile())) {
                profileTable = entityClass.masterWriteTable(true);
                st.addBatch(buildSql(profileTable, sysTime, id));
            }
        }
    }

    private String buildSql(String table, long sysTime, long id) {
        String base = String.format("UPDATE %s SET ", table) +
                SystemColumn.SYS_VERSION + "=" + SystemColumn.SYS_VERSION + "+1" +
                ", " + SystemColumn.SYS_OPERATE_TIME + "=" + "%d" +
                " where id=%d";

        return String.format(base, sysTime, id);
    }
}
