package com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor;

import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.plus.common.StringUtils;
import com.xforceplus.ultraman.oqsengine.plus.common.executor.Executor;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.*;
import com.xforceplus.ultraman.oqsengine.plus.meta.pojo.dto.table.SystemColumn;
import com.xforceplus.ultraman.sdk.core.utils.MasterStorageHelper;
import com.xforceplus.ultraman.sdk.infra.codec.MySQLCodecCustom;
import com.xforceplus.ultraman.sdk.infra.exceptions.InvalidInputsException;
import lombok.extern.slf4j.Slf4j;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.codecs.Codec;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.*;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

/**
 * TODO
 * need to deal with following case
 * - profile
 * - father
 * - son
 */
@Slf4j
public class ConditionalDeleteExecutor extends AbstractMasterTaskExecutor<List<ConditionalStoragePackage>, Integer> {

    //update oqs_new20_any0523001 set _sys_dynamic = JSON_MERGE_PATCH(_sys_dynamic,'{"#a": {"grouped": 1}}') where id = 1669166938506395648
    private final static String UPDATE_USER = "JSON_MERGE_PATCH(%s, '{\"#a\":{\"deluid\": %s, \"deluname\":\"%s\"}}')";
    
    private final static String LIMIT_COUNT = "SELECT COUNT(*) from %s where %s";

    boolean recordUser;

    private String delUser;
    private Long delUserId;
    
    private boolean isCheckConditionalLimit = false;

    private Codec<Character> mySQLCodec = new MySQLCodecCustom(MySQLCodecCustom.Mode.STANDARD);

    public ConditionalDeleteExecutor(Connection connection, long time, boolean isCheckConditionalLimit ,boolean recordUser, String currentUser, Long currentUserId) {
        super(connection, time);
        this.recordUser = recordUser;
        this.delUser = currentUser;
        this.delUserId = currentUserId;
        this.isCheckConditionalLimit = isCheckConditionalLimit;
    }

    public static Executor<List<ConditionalStoragePackage>, Integer> build(
            Connection connection, long timeout, boolean isCheckConditionalLimit, boolean recordUser, String currentUser, Long currentUserId) {
        return new ConditionalDeleteExecutor(connection, timeout, recordUser, isCheckConditionalLimit, currentUser, currentUserId);
    }

    private String recordUser(ConditionalStoragePackage storagePackage) throws SQLException {
        if (recordUser) {
            String updateSQL = buildUpdateSql(storagePackage);
            return updateSQL;
        }
        return null;
    }

    @Override
    public Integer execute(List<ConditionalStoragePackage> storagePackage) throws SQLException {
        if(storagePackage.isEmpty()) {
            return 0;
        }

        List<Integer> focusRetIndex = new ArrayList<>();
        AtomicInteger index = new AtomicInteger(0);
        try (Statement st = getConnection().createStatement()) {
        
        if(storagePackage.size() > 1) {
            storagePackage.forEach(x -> {
                try {
                    if (isCheckConditionalLimit && x.getLimit() > 0) {
                        //should check limit
                        String limitSql = String.format(LIMIT_COUNT, x.getMainTableName()
                                , x.getConditionSql());
                        ResultSet resultSet = st.executeQuery(limitSql);
                        if (resultSet.next()) {
                            int limit = resultSet.getInt(1);
                            if (limit > x.getLimit()) {
                                throw new InvalidInputsException(InvalidInputsException.getMsg("Conditional delete exceed the request limit"));
                            }
                        }
                    }

                    String storageSQL = recordUser(x);
                    if (storageSQL != null) {
                        st.addBatch(storageSQL);
                        index.incrementAndGet();
                    }

                    focusRetIndex.add(index.getAndIncrement());
                    st.addBatch(buildDelSql(x));
                } catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
                
                
            });

            int[] ints = st.executeBatch();
            return focusRetIndex.stream().mapToInt(x -> ints[x]).sum();
        } else {
                ConditionalStoragePackage targetStoragePackage = storagePackage.get(0);
                /**
                 * focus on which sql
                 */
                if (isCheckConditionalLimit && targetStoragePackage.getLimit() > 0) {
                    //should check limit
                    String limitSql = String.format(LIMIT_COUNT, targetStoragePackage.getMainTableName()
                            , targetStoragePackage.getConditionSql());
                    ResultSet resultSet = st.executeQuery(limitSql);
                    if (resultSet.next()) {
                        int limit = resultSet.getInt(1);
                        if (limit > targetStoragePackage.getLimit()) {
                            throw new InvalidInputsException(InvalidInputsException.getMsg("Conditional delete exceed the request limit"));
                        }
                    }
                }
    
                String storageSQL = recordUser(targetStoragePackage);
                if (storageSQL != null) {
                    st.addBatch(storageSQL);
                    index.incrementAndGet();
                }
    
                focusRetIndex.add(index.getAndIncrement());
                st.addBatch(buildDelSql(targetStoragePackage));
                return st.executeBatch()[focusRetIndex.get(0)];
            }
        }
    }

    private String buildDelSql(ConditionalStoragePackage storagePackage) {
        String mainTableName = storagePackage.getMainTableName();

        //combine multi into one
        StringBuilder base = new StringBuilder();
        base.append("DELETE ");
        if (storagePackage.getRelatedTable().size() > 1) {
            base.append(String.join(",", storagePackage.getRelatedTable()));
        }
        base.append(" FROM ").append(mainTableName);

        String conditionSql = storagePackage.getConditionSql();

        if (!StringUtils.isEmpty(conditionSql)) {
            base.append(" where ").append(conditionSql);
        }

        /**
         * mysql delete multi table not supported
         */
        if (storagePackage.getLimit() > 0 && storagePackage.getRelatedTable().size() < 2) {
            base.append(" limit ").append(storagePackage.getLimit());
        }

        return base.toString();
    }

    private String buildUpdateSql(ConditionalStoragePackage storagePackage) throws SQLException {

        String mainTableName = storagePackage.getMainTableName();

        //combine multi into one
        StringBuilder base = new StringBuilder();
        base.append("UPDATE ").append(mainTableName).append(" SET ");

        String conditionSql = storagePackage.getConditionSql();
        List<String> tableNames = storagePackage.getRelatedTable();

        boolean isFirst = true;

        for (String targetTable : tableNames) {

            if (isFirst) {
                isFirst = false;
            } else {
                base.append(",");
            }
            String concatColumn = targetTable.concat(".").concat(SystemColumn.SYS_VERSION);
            String concatOperate = targetTable.concat(".").concat(SystemColumn.SYS_OPERATE_TIME);
            base.append(concatColumn).append(" = ").append(concatColumn).append(" +1 ");
            base.append(",").append(concatOperate).append(" = ").append(System.currentTimeMillis());
            String update = String.format(UPDATE_USER, targetTable.concat("._sys_dynamic"), Optional.ofNullable(delUserId).orElse(0L)
                    , Optional.ofNullable(delUser).orElse("系统"));
            base.append(",").append(targetTable).append(".").append(SystemColumn.DYNAMIC_FIELD).append(" = ").append(update);
        }

        if (!StringUtils.isEmpty(conditionSql)) {
            base.append(" where ").append(conditionSql);
        } else {
            throw new InvalidInputsException(InvalidInputsException.getMsg("Conditional update should always has a range"));
        }


        return base.toString();
    }
}
