package com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor;


import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.plus.common.executor.Executor;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.MasterEntity;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.MasterStorageEntity;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.*;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

/**
 * Created by justin.xu on 03/2023.
 *
 * @since 1.8
 */
public class DeleteExecutor extends AbstractMasterTaskExecutor<List<MasterStorageEntity>, Boolean[]> {

    private final static String UPDATE_SQL = "UPDATE %s set _sys_dynamic = %s, _sys_operatetime = %s where id in (%s)";
    //update oqs_new20_any0523001 set _sys_dynamic = JSON_MERGE_PATCH(_sys_dynamic,'{"#a": {"grouped": 1}}') where id = 1669166938506395648
    private final static String UPDATE_USER = "JSON_MERGE_PATCH(_sys_dynamic, '{\"#a\":{\"deluid\": %s, \"deluname\":\"%s\"}}')";
    private boolean recordUser;
    private String delUser;
    private Long delUserId;
    
    public DeleteExecutor(Connection connection, long timeout, boolean recordUser, String currentUser, Long currentUserId) {
        super(connection, timeout);
        this.recordUser = recordUser;
        this.delUser = currentUser;
        this.delUserId = currentUserId;
    }

    public static Executor<List<MasterStorageEntity>, Boolean[]> build(
            Connection connection, long timeout, boolean recordUser, String currentUser, Long currentUserId) {
        return new DeleteExecutor(connection, timeout, recordUser, currentUser, currentUserId);
    }

    @Override
    public Boolean[] execute(List<MasterStorageEntity> masterStorageEntities) throws SQLException {

        boolean isBatch = masterStorageEntities.size() > 1;
        List<Integer> focusRetIndex = new ArrayList<>();
        AtomicInteger index = new AtomicInteger(0);
        try (Statement st = getConnection().createStatement()) {
            checkTimeout(st);
            if (isBatch) {
                if (recordUser) {

                    String update = String.format(UPDATE_USER, Optional.ofNullable(delUserId).orElse(0L)
                            , Optional.ofNullable(delUser).orElse("系统"));
                    Map<String, List<MasterStorageEntity>> mapping = masterStorageEntities.stream()
                            .collect(Collectors.groupingBy(MasterEntity::getTableName));
                    mapping.forEach((k, v) -> {
                        String ids = v.stream().map(x -> x.getSystemColumn().getId()).filter(Objects::nonNull).map(Object::toString)
                                .collect(Collectors.joining(","));
                        OptionalLong max = v.stream().mapToLong(x -> x.getSystemColumn().getOperateTime()).max();
                        String updateSQL = String.format(UPDATE_SQL, k, update, max.orElse(0), ids);
                        try {
                            st.addBatch(updateSQL);
                            index.incrementAndGet();
                        } catch (SQLException e) {
                            e.printStackTrace();
                        }
                    });
                }

                for (MasterStorageEntity entity : masterStorageEntities) {
                    String sql = buildSql(entity);
                    st.addBatch(sql);
                    focusRetIndex.add(index.getAndIncrement());
                    if(entity.isOnlyFather()) {
                        /**
                         * should build sql for children
                         */
                        List<String> sqlList = buildChildSql(entity);
                        for(String childSql : sqlList) {
                            st.addBatch(childSql);
                            index.incrementAndGet();
                        }
                    }
                }

                Boolean[] booleans = executedUpdate(st, true);
                return focusRetIndex.stream().map(x -> booleans[x]).toArray(Boolean[]::new);
            } else {
                MasterStorageEntity entity = masterStorageEntities.get(0);

                if (recordUser) {
                    String update = String.format(UPDATE_USER, Optional.ofNullable(delUserId).orElse(0L)
                            , Optional.ofNullable(delUser).orElse("系统"));

                    String updateSQL = String.format(UPDATE_SQL, entity.getTableName()
                            , update
                            , entity.getSystemColumn().getOperateTime()
                            , entity.getSystemColumn().getId());
                    st.addBatch(updateSQL);
                    index.incrementAndGet();
                }

                String sql = buildSql(entity);
                st.addBatch(sql);
                focusRetIndex.add(index.getAndIncrement());
                
                if(entity.isOnlyFather()) {
                   
                    /**
                     * should build sql for children
                     */
                    List<String> sqlList = buildChildSql(entity);
                    sqlList.stream().forEach(targetSql -> {
                        try {
                            st.addBatch(targetSql);
                            index.incrementAndGet();
                        } catch (SQLException e) {
                            e.printStackTrace();
                        }
                    });
                }

                Boolean[] booleans = executedUpdate(st, true);
                return focusRetIndex.stream().map(x -> booleans[x]).toArray(Boolean[]::new);
            }
        }
    }

    protected String buildSql(MasterStorageEntity masterStorageEntity) {

        StringBuilder base = new StringBuilder();
        base.append("DELETE FROM ").append(masterStorageEntity.getTableName());
        base.append(" ").append("where id").append("=").append(masterStorageEntity.getSystemColumn().getId());

        return base.toString();
    }
    
    protected List<String> buildChildSql(MasterStorageEntity masterStorageEntity) {

        EntityClassGroup rawEntityClass = masterStorageEntity.getRawEntityClass();
        Collection<IEntityClass> childrenEntityClass = rawEntityClass.getChildrenEntityClass();
        List<String> childrenSql = new ArrayList<>();
        for (IEntityClass entityClass : childrenEntityClass) {
            String targetTable = entityClass.masterWriteTable(masterStorageEntity.isProfiled());
            StringBuilder base = new StringBuilder();
            base.append("DELETE FROM ").append(targetTable);
            base.append(" ").append("where id").append("=").append(masterStorageEntity.getSystemColumn().getId());
            String targetSql = base.toString();
            childrenSql.add(targetSql);
        }
        return childrenSql;
    }
}
