package com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor;

import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.plus.storage.pojo.dto.select.SelectConfig;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.Tuple3;
import lombok.extern.slf4j.Slf4j;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.*;
import java.util.stream.Collectors;


@Slf4j
public class QuerySubSystemExecutor {

    private static String QUERY_RAW_POLY = "SELECT id, _sys_profile, _sys_entityclass, _sys_ver from %s where id in (%s) and (_sys_profile != ? or _sys_entityclass != ?)";

    private EntityClassEngine engine;

    public QuerySubSystemExecutor(EntityClassEngine engine) {
        this.engine = engine;
    }

    public Map<String, List<Tuple3<Long, String, Long>>>  execute(SelectConfig selectConfig, Connection resource
            , IEntityClass entityClass) throws SQLException {
        List<Long> idsList = selectConfig.getIds();
        Map<String, List<Tuple3<Long, String, Long>>> tableMapping = new HashMap<>();
        if(idsList != null && !idsList.isEmpty()) {
            String ids = idsList.stream().map(Object::toString).collect(Collectors.joining(","));
            String systemSQL = String.format(QUERY_RAW_POLY, String.join(",", entityClass.masterQueryTable()), ids);
            log.debug("System SQL is systemSQL {}", systemSQL);

            PreparedStatement statement = resource.prepareStatement(systemSQL);
            String realProfile = entityClass.realProfile();
            if (realProfile == null) {
                realProfile = "";
            }

            statement.setString(1, realProfile);
            statement.setLong(2, entityClass.id());

            //store all 
            List<Tuple3<Long, String, Long>> ployList = new ArrayList<>();
            try (ResultSet resultSet = statement.executeQuery()) {
                while (resultSet.next()) {
                    ployList.add(Tuple.of(resultSet.getLong(1), resultSet.getString(2), resultSet.getLong(3)));
                }
            }

            Map<Tuple2<Long, String>, List<Tuple3<Long, String, Long>>> grouped = ployList.stream().collect(Collectors.groupingBy(x -> Tuple.of(x._3, x._2)));

            //find target table
            grouped.forEach((k, v) -> {
                String targetTable = findTargetTable(k);
                if (targetTable != null) {
                    tableMapping.compute(targetTable, (k1, v1) -> {
                        if (v1 == null) {
                            v1 = new ArrayList<>(v);
                        } else {
                            v1.addAll(v);
                        }

                        return v1;
                    });
                }
            });
        }
        
        return tableMapping;
    }


    private String findTargetTable(Tuple2<Long, String> tuple) {
        Optional<IEntityClass> load = engine.load(tuple._1.toString(), tuple._2);
        if(load.isPresent()) {
            return load.get().masterQueryTable();
        } else {
            return null;
        }
    }
}
