package com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor;

import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.plus.storage.pojo.dto.select.SelectConfig;
import lombok.extern.slf4j.Slf4j;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Slf4j
public class QuerySystemVerExecutor {

    private String QUERY_RAW_VER = "SELECT id, _sys_ver from %s where id in (%s)";

    public Map<Long, Integer> execute(SelectConfig selectConfig, Connection resource
            , IEntityClass entityClass) throws SQLException {
        List<Long> idsList = selectConfig.getIds();
        String ids = idsList.stream().map(Object::toString).collect(Collectors.joining(","));
        String systemSQL = String.format(QUERY_RAW_VER
                , String.join(",", entityClass.masterQueryTable())
                , ids);
        log.debug("Version SQL is  {}", systemSQL);
        PreparedStatement statement = resource.prepareStatement(systemSQL);
        Map<Long, Integer> verMapping = new HashMap<>();
        try (ResultSet resultSet = statement.executeQuery()) {
            while (resultSet.next()) {
                verMapping.put(resultSet.getLong(1), resultSet.getInt(2));
            }
        }
        return verMapping;
    }
}
