package com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor;

import com.xforceplus.ultraman.oqsengine.plus.common.executor.Executor;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.MasterStorageEntity;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.StorageType;
import com.xforceplus.ultraman.oqsengine.plus.meta.pojo.dto.table.SystemColumn;
import com.xforceplus.ultraman.sdk.core.utils.MasterStorageHelper;
import com.xforceplus.ultraman.sdk.infra.codec.MySQLCodecCustom;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.codecs.Codec;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

/**
 * Created by justin.xu on 12/2023.
 *
 * @since 1.8
 */
public class ReplaceExecutor extends AbstractMasterTaskExecutor<List<MasterStorageEntity>, Boolean[]> {

    /**
     * TODO
     * current static inited
     */
    private Codec<Character> mySQLCodec = new MySQLCodecCustom(MySQLCodecCustom.Mode.STANDARD);

    public ReplaceExecutor(Connection resource, long timeout) {
        super(resource, timeout);
    }

    public static Executor<List<MasterStorageEntity>, Boolean[]> build(
            Connection resource, long timeout) {
        return new ReplaceExecutor(resource, timeout);
    }

    @Override
    public Boolean[] execute(List<MasterStorageEntity> masterStorageEntities) throws SQLException {
        boolean isBatch = masterStorageEntities.size() > 1;

        //  设置值.
        try (Statement st = getConnection().createStatement()) {
            if (isBatch) {
                for (MasterStorageEntity entity : masterStorageEntities) {

                    //  建SQL.
                    String sql = buildSql(entity);

                    st.addBatch(sql);
                }

                return executedUpdate(st, true);
            } else {
                MasterStorageEntity entity = masterStorageEntities.get(0);

                //  建SQL.
                String sql = buildSql(entity);

                return new Boolean[]{st.executeUpdate(sql) > 0};
            }
        }
    }

    protected String buildSql(MasterStorageEntity masterStorageEntity) throws SQLException {
        StringBuilder base = new StringBuilder();
        base.append("REPLACE INTO ").append(masterStorageEntity.getTableName()).append(" (");

        //  systemField.
        base.append(String.join(",", SystemColumn.ID, SystemColumn.SYS_ENTITY_CLASS, SystemColumn.SYS_VERSION, SystemColumn.SYS_OPERATE_TIME, SystemColumn.SYS_DELETED, SystemColumn.SYS_PROFILE));

        //  static field
        if (!masterStorageEntity.getBusinessStaticFields().isEmpty()) {
            for (MasterStorageEntity.TypedStorageValue value : masterStorageEntity.getBusinessStaticFields()) {
                String columnName = value.getEntityField().name().toLowerCase();
                if (!SystemColumn.SYSTEM_WORDS.contains(columnName)) {
                    base.append(",").append(MasterStorageHelper.toStorageName(columnName, true));
                }
            }
        }

        //  dynamic field
        if (!masterStorageEntity.getBusinessDynamicFields().isEmpty()) {
            base.append(",").append(SystemColumn.DYNAMIC_FIELD);
        }

        base.append(") VALUES (");

        base.append(masterStorageEntity.getSystemColumn().getId()).append(",").append(masterStorageEntity.getSystemColumn().getEntityClass()).append(",").append(masterStorageEntity.getSystemColumn().getVersion()).append(",").append(masterStorageEntity.getSystemColumn().getOperateTime()).append(",").append(masterStorageEntity.getSystemColumn().getDeleted()).append(",").append("'").append(masterStorageEntity.getSystemColumn().getProfile()).append("'");

        //  static field
        if (!masterStorageEntity.getBusinessStaticFields().isEmpty()) {
            for (MasterStorageEntity.TypedStorageValue value : masterStorageEntity.getBusinessStaticFields()) {
                if (!SystemColumn.SYSTEM_WORDS.contains(value.getEntityField().name())) {
                    StorageType storageType = StorageType.instance(value.getEntityField().type());
                    if (null == storageType) {
                        throw new SQLException("storageType not found.");
                    }

                    if (value.getValue() != null) {
                        Object targetValue;
                        if(value.isKeepRaw()) {
                            targetValue = value.getValue();
                        } else {
                            targetValue = storageType.isNeedSymbol() ? String.format("'%s'", ESAPI.encoder().encodeForSQL(mySQLCodec, value.getValue().toString())) 
                                    : value.getValue();
                        }
                        base.append(",").append(targetValue);
                    } else {
                        base.append(",").append("null");
                    }
                }

            }
        }

        //  dynamic field
        if (!masterStorageEntity.getBusinessDynamicFields().isEmpty()) {
            base.append(",").append("'").append(masterStorageEntity.getBusinessDynamicFields()).append("'");
        }

        base.append(")");

        return base.toString();
    }
}
