/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.master.iterator;

import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.plus.common.iterator.DataIterator;
import com.xforceplus.ultraman.oqsengine.plus.master.iterator.exception.TaskRetryException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EntityUpdateTimeRangeIterator<T>
implements DataIterator<T> {
    private Logger logger = LoggerFactory.getLogger(EntityUpdateTimeRangeIterator.class);
    protected static final int DEFAULT_BUFFER_SIZE = 1000;
    protected int buffSize;
    protected long startTime;
    protected long endTime;
    protected long startId;
    protected String tableName;
    protected IEntityClass entityClass;
    protected DataSource dataSource;
    protected List<T> buffer;
    protected Connection connection;
    protected PreparedStatement ps;
    protected ResultSet rs;
    protected String filterProfile;

    public void init() throws Exception {
        this.buffer = new ArrayList<T>(this.buffSize);
        this.connection = this.dataSource.getConnection();
        this.ps = this.preparedSQL(this.tableName, this.filterProfile);
        this.rs = this.ps.executeQuery();
    }

    public void destroy() throws Exception {
        if (this.rs != null) {
            this.rs.close();
        }
        if (this.ps != null) {
            this.ps.close();
        }
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public boolean hasNext() {
        if (this.buffer.isEmpty()) {
            this.load();
        }
        return !this.buffer.isEmpty();
    }

    public T next() {
        if (this.hasNext()) {
            return this.buffer.remove(0);
        }
        return null;
    }

    private void load() throws RuntimeException {
        try {
            while (this.rs.next()) {
                T result = this.buildFromResultSet(this.rs);
                if (null == result) continue;
                this.buffer.add(result);
                if (this.buffer.size() != this.buffSize) continue;
                break;
            }
        }
        catch (Exception ex) {
            if (ex instanceof SQLException) {
                throw new TaskRetryException(ex.getMessage(), ex);
            }
            throw new RuntimeException(ex);
        }
    }

    protected abstract T buildFromResultSet(ResultSet var1) throws Exception;

    protected abstract PreparedStatement preparedSQL(String var1, String var2) throws SQLException;
}

