/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.master.iterator;

import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.plus.common.StringUtils;
import com.xforceplus.ultraman.oqsengine.plus.master.iterator.EntityUpdateTimeRangeIterator;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;

public class IdIterator
extends EntityUpdateTimeRangeIterator<Long> {
    @Override
    protected Long buildFromResultSet(ResultSet rs) throws Exception {
        return rs.getLong("id");
    }

    @Override
    protected PreparedStatement preparedSQL(String table, String profile) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        sql.append("id").append(" , ").append("_sys_entityclass").append(" , ").append("_sys_profile");
        sql.append(" FROM ").append(table).append(" WHERE ").append("_sys_operatetime").append(" >= ").append("?").append(" AND ").append("_sys_operatetime").append(" <= ").append("?").append(" AND ").append("id").append(" > ").append("?");
        if (null != profile && !profile.isEmpty()) {
            sql.append(" AND ").append("_sys_profile").append(" = ").append("?");
        }
        sql.append(" ORDER BY ").append("id");
        PreparedStatement ps = this.connection.prepareStatement(sql.toString(), 1003, 1007);
        ps.setFetchSize(Integer.MIN_VALUE);
        int pos = 1;
        ps.setLong(pos++, this.startTime);
        ps.setLong(pos++, this.endTime);
        ps.setLong(pos++, this.startId);
        if (null != profile && !profile.isEmpty()) {
            ps.setString(pos++, this.entityClass.profile());
        }
        return ps;
    }

    public static final class Builder {
        private int buffSize = 1000;
        private long startTime = -1L;
        private long endTime = -1L;
        private String tableName;
        private long startId = 0L;
        private IEntityClass entityClass;
        private DataSource dataSource;

        private Builder() {
        }

        public static Builder anEntityIterator() {
            return new Builder();
        }

        public Builder witherBuffSize(int size) {
            this.buffSize = size;
            return this;
        }

        public Builder witherTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder withStartTime(long startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder withEndTime(long endTime) {
            this.endTime = endTime;
            return this;
        }

        public Builder withEntityClass(IEntityClass entityClass) {
            this.entityClass = entityClass;
            return this;
        }

        public Builder withDataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public Builder withStartId(long startId) {
            this.startId = startId;
            return this;
        }

        public IdIterator build() {
            if (this.entityClass == null) {
                throw new RuntimeException("Invalid meta information.");
            }
            if (this.startTime < 0L) {
                throw new RuntimeException("Invalid start time.");
            }
            if (this.endTime < 0L) {
                throw new RuntimeException("Invalid end time.");
            }
            if (this.startTime > this.endTime) {
                throw new RuntimeException(String.format("The start time cannot be later than the end time.[%d, %d]", this.startTime, this.endTime));
            }
            if (this.dataSource == null) {
                throw new RuntimeException("Invalid data source.");
            }
            if (StringUtils.isEmpty((String)this.tableName)) {
                throw new RuntimeException("Invalid table name.");
            }
            IdIterator entityIterator = new IdIterator();
            entityIterator.buffSize = this.buffSize;
            entityIterator.startTime = this.startTime;
            entityIterator.endTime = this.endTime;
            entityIterator.dataSource = this.dataSource;
            entityIterator.entityClass = this.entityClass;
            entityIterator.tableName = this.tableName;
            entityIterator.startId = this.startId;
            try {
                entityIterator.init();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return entityIterator;
        }
    }
}

