/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.master.mysql.calcite;

import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.service.DictService;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.MysqlSqlDialectEx;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.calcite.InSupportedSqlImplementor;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.query.CopyVisitor;
import com.xforceplus.ultraman.sdk.core.config.ExecutionConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.adapter.jdbc.JdbcImplementor;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttleImpl;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.rel2sql.SqlImplementor;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSqlConvertletTable;
import org.apache.calcite.rex.RexSqlStandardConvertletTable;
import org.apache.calcite.rex.RexToSqlNodeConverterImpl;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.util.SqlString;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.Sarg;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ConditionalSqlShuttle
extends RelShuttleImpl {
    private RelBuilder builder;
    private String targetCode;
    private String conditionSql;
    private EntityClassGroup targetGroup;
    private int limit;
    private ExecutionConfig executionConfig;
    private DictService dictService;

    public ConditionalSqlShuttle(EntityClassGroup targetGroup, RelBuilder builder, String targetCode, DictService dictService, ExecutionConfig executionConfig) {
        this.builder = builder;
        this.targetCode = targetCode;
        this.targetGroup = targetGroup;
        this.executionConfig = executionConfig;
        this.dictService = dictService;
    }

    public int getLimit() {
        return this.limit;
    }

    public String getConditionSql() {
        return this.conditionSql;
    }

    public RelNode visit(LogicalSort sort) {
        RexNode fetch = sort.fetch;
        if (fetch != null) {
            RexLiteral literal = (RexLiteral)fetch;
            this.limit = (Integer)literal.getValueAs(Integer.class);
        }
        return super.visit(sort);
    }

    public RelNode visit(TableScan scan) {
        this.builder = this.builder.scan(new String[]{"oqs", this.targetGroup.getEntityClass().masterQueryTable().toLowerCase()});
        return super.visit(scan);
    }

    public RelNode visit(LogicalValues values) {
        if (values.getTuples().isEmpty()) {
            this.conditionSql = " 1 = 0 ";
        }
        return null;
    }

    public RelNode visit(LogicalFilter filter) {
        InSupportedSqlImplementor simpleContext;
        SqlNode sqlNode;
        CopyVisitor copyVisitor;
        RelNode visit = super.visit(filter);
        RexCall condition = (RexCall)filter.getCondition();
        RexNode finalNode = (RexNode)condition.accept((RexVisitor)(copyVisitor = new CopyVisitor(this.builder, Collections.singletonList(this.targetGroup), (RelNode)filter, this.executionConfig.isUseStrictEnum(), this.dictService, this.executionConfig.getInClauseRewrite())));
        if (finalNode != null && (sqlNode = (simpleContext = new InSupportedSqlImplementor(MysqlSqlDialectEx.DEFAULT, index -> {
            RelDataTypeField relDataTypeField = (RelDataTypeField)this.builder.peek().getRowType().getFieldList().get(index);
            String name = relDataTypeField.getName();
            return new SqlIdentifier(Arrays.asList(this.targetCode, name), SqlParserPos.QUOTED_ZERO);
        }, (SqlImplementor)new JdbcImplementor(MysqlSqlDialectEx.DEFAULT, (JavaTypeFactory)new JavaTypeFactoryImpl(this.builder.getTypeFactory().getTypeSystem())))).toSql(null, finalNode)) != null) {
            SqlString sqlString = sqlNode.toSqlString(MysqlSqlDialectEx.DEFAULT);
            this.conditionSql = sqlString.getSql();
        }
        return visit;
    }

    class MyConverter
    extends RexToSqlNodeConverterImpl {
        private RelNode relNode;
        private String targetCode;

        public MyConverter(String targetCode, RelNode relNode) {
            super((RexSqlConvertletTable)new RexSqlStandardConvertletTable());
            this.relNode = relNode;
            this.targetCode = targetCode;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public @Nullable SqlNode convertCall(RexCall call) {
            if ((call.getOperator() == SqlStdOperatorTable.OR || call.getOperator() == SqlStdOperatorTable.AND) && call.getOperands().size() > 2) {
                Stack<Object> rexNodeStack = new Stack<Object>();
                for (RexNode operand : call.getOperands()) {
                    rexNodeStack.push(operand);
                    if (rexNodeStack.size() != 2) continue;
                    RexNode left = (RexNode)rexNodeStack.pop();
                    RexNode right = (RexNode)rexNodeStack.pop();
                    rexNodeStack.push(call.clone(call.getType(), Arrays.asList(left, right)));
                }
                if (!rexNodeStack.isEmpty()) {
                    return super.convertNode((RexNode)rexNodeStack.pop());
                }
            }
            if (call.getOperator() != SqlStdOperatorTable.SEARCH) return super.convertCall(call);
            List operands = call.getOperands();
            SqlNode key = null;
            SqlNodeList sqlListValue = null;
            SqlBinaryOperator sqlOperator = null;
            SqlNumericLiteral low = null;
            boolean includingLower = false;
            SqlNumericLiteral high = null;
            boolean includingHigh = false;
            for (RexNode operand : operands) {
                Comparable target;
                Comparable value;
                if (operand instanceof RexInputRef) {
                    key = this.convertNode(operand);
                    continue;
                }
                if (!(operand instanceof RexLiteral) || ((RexLiteral)operand).getTypeName() != SqlTypeName.SARG || !((value = ((RexLiteral)operand).getValue()) instanceof Sarg)) continue;
                if (((Sarg)value).isPoints()) {
                    Set ranges = ((Sarg)value).rangeSet.asRanges();
                    List nodes = ranges.stream().map(x -> x.lowerEndpoint()).map(x -> {
                        if (x instanceof Number) {
                            return SqlLiteral.createExactNumeric((String)x.toString(), (SqlParserPos)SqlParserPos.ZERO);
                        }
                        if (x instanceof NlsString) {
                            return SqlLiteral.createCharString((String)((NlsString)x).getValue(), (SqlParserPos)SqlParserPos.ZERO);
                        }
                        return SqlLiteral.createCharString((String)x.toString(), (SqlParserPos)SqlParserPos.ZERO);
                    }).collect(Collectors.toList());
                    sqlListValue = SqlNodeList.of((SqlParserPos)SqlParserPos.ZERO, nodes);
                    sqlOperator = SqlStdOperatorTable.IN;
                    continue;
                }
                Optional first = ((Sarg)value).rangeSet.asRanges().stream().findFirst();
                Range range = (Range)first.get();
                if (range.hasLowerBound()) {
                    includingLower = range.lowerBoundType() == BoundType.CLOSED;
                    target = range.lowerEndpoint();
                    if (target instanceof Number) {
                        low = SqlLiteral.createExactNumeric((String)target.toString(), (SqlParserPos)SqlParserPos.ZERO);
                    } else {
                        if (target instanceof NlsString) {
                            return SqlLiteral.createCharString((String)((NlsString)target).getValue(), (SqlParserPos)SqlParserPos.ZERO);
                        }
                        low = SqlLiteral.createCharString((String)target.toString(), (SqlParserPos)SqlParserPos.ZERO);
                    }
                }
                if (!range.hasUpperBound()) continue;
                includingHigh = range.upperBoundType() == BoundType.CLOSED;
                target = range.lowerEndpoint();
                if (target instanceof Number) {
                    high = SqlLiteral.createExactNumeric((String)target.toString(), (SqlParserPos)SqlParserPos.ZERO);
                    continue;
                }
                high = SqlLiteral.createCharString((String)target.toString(), (SqlParserPos)SqlParserPos.ZERO);
            }
            if (low == null && high == null) return new SqlBasicCall((SqlOperator)SqlStdOperatorTable.IN, Arrays.asList(key, sqlListValue), SqlParserPos.ZERO);
            ArrayList<SqlBasicCall> clause = new ArrayList<SqlBasicCall>();
            if (low != null) {
                if (includingLower) {
                    clause.add(new SqlBasicCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, Arrays.asList(key, low), SqlParserPos.ZERO));
                } else {
                    clause.add(new SqlBasicCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, Arrays.asList(key, low), SqlParserPos.ZERO));
                }
            }
            if (high != null) {
                if (includingHigh) {
                    clause.add(new SqlBasicCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, Arrays.asList(key, low), SqlParserPos.ZERO));
                } else {
                    clause.add(new SqlBasicCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, Arrays.asList(key, low), SqlParserPos.ZERO));
                }
            }
            if (clause.size() <= 1) return (SqlNode)clause.get(0);
            new SqlBasicCall((SqlOperator)SqlStdOperatorTable.AND, clause, SqlParserPos.ZERO);
            return super.convertCall(call);
        }

        public @Nullable SqlNode convertInputRef(RexInputRef ref) {
            int index = ref.getIndex();
            RelDataTypeField relDataTypeField = (RelDataTypeField)ConditionalSqlShuttle.this.builder.peek().getRowType().getFieldList().get(index);
            String name = relDataTypeField.getName();
            return new SqlIdentifier(Arrays.asList(this.targetCode, name), SqlParserPos.QUOTED_ZERO);
        }
    }
}

