/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.master.mysql.devops;

import com.xforceplus.ultraman.oqsengine.plus.common.executor.Executor;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor.AbstractMasterTaskExecutor;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;

public class BatchDeleteExecutor
extends AbstractMasterTaskExecutor<Collection<Long>, Boolean[]> {
    private long startTime;
    private long endTime;
    private String table;

    public BatchDeleteExecutor(Connection connection, long timeout, String table, long startTime, long endTime) {
        super(connection, timeout);
        this.table = table;
        this.startTime = startTime;
        this.endTime = endTime;
        this.table = table;
    }

    public static Executor<Collection<Long>, Boolean[]> build(Connection connection, long timeout, String table, long startTime, long endTime) {
        return new BatchDeleteExecutor(connection, timeout, table, startTime, endTime);
    }

    public Boolean[] execute(Collection<Long> ids) throws SQLException {
        try (Statement st = this.getConnection().createStatement();){
            this.checkTimeout(st);
            for (Long id : ids) {
                String sql = this.buildSql(id);
                st.addBatch(sql);
            }
            Boolean[] booleanArray = this.executedUpdate(st, ids.size() > 1);
            return booleanArray;
        }
    }

    protected String buildSql(Long id) {
        StringBuilder base = new StringBuilder();
        base.append("DELETE FROM ").append(this.table);
        base.append(" ").append("where id").append("=").append(id).append(" and ").append("_sys_operatetime").append(" >= ").append(this.startTime).append(" and ").append("_sys_operatetime").append(" <= ").append(this.endTime);
        return base.toString();
    }
}

