/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor;

import com.xforceplus.ultraman.oqsengine.plus.common.StringUtils;
import com.xforceplus.ultraman.oqsengine.plus.common.executor.Executor;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.ConditionalStoragePackage;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor.AbstractMasterTaskExecutor;
import com.xforceplus.ultraman.sdk.infra.codec.MySQLCodecCustom;
import com.xforceplus.ultraman.sdk.infra.exceptions.InvalidInputsException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.owasp.esapi.codecs.Codec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionalDeleteExecutor
extends AbstractMasterTaskExecutor<List<ConditionalStoragePackage>, Integer> {
    private static final Logger log = LoggerFactory.getLogger(ConditionalDeleteExecutor.class);
    private static final String UPDATE_USER = "JSON_MERGE_PATCH(%s, '{\"#a\":{\"deluid\": %s, \"deluname\":\"%s\"}}')";
    private static final String LIMIT_COUNT = "SELECT COUNT(*) from %s where %s";
    boolean recordUser;
    private String delUser;
    private Long delUserId;
    private boolean isCheckConditionalLimit = false;
    private Codec<Character> mySQLCodec = new MySQLCodecCustom(MySQLCodecCustom.Mode.STANDARD);

    public ConditionalDeleteExecutor(Connection connection, long time, boolean isCheckConditionalLimit, boolean recordUser, String currentUser, Long currentUserId) {
        super(connection, time);
        this.recordUser = recordUser;
        this.delUser = currentUser;
        this.delUserId = currentUserId;
        this.isCheckConditionalLimit = isCheckConditionalLimit;
    }

    public static Executor<List<ConditionalStoragePackage>, Integer> build(Connection connection, long timeout, boolean isCheckConditionalLimit, boolean recordUser, String currentUser, Long currentUserId) {
        return new ConditionalDeleteExecutor(connection, timeout, recordUser, isCheckConditionalLimit, currentUser, currentUserId);
    }

    private String recordUser(ConditionalStoragePackage storagePackage) throws SQLException {
        if (this.recordUser) {
            String updateSQL = this.buildUpdateSql(storagePackage);
            return updateSQL;
        }
        return null;
    }

    public Integer execute(List<ConditionalStoragePackage> storagePackage) throws SQLException {
        if (storagePackage.isEmpty()) {
            return 0;
        }
        ArrayList<Integer> focusRetIndex = new ArrayList<Integer>();
        AtomicInteger index = new AtomicInteger(0);
        try (Statement st = this.getConnection().createStatement();){
            int limit;
            String limitSql;
            ResultSet resultSet;
            if (storagePackage.size() > 1) {
                storagePackage.forEach(x -> {
                    try {
                        int limit;
                        String limitSql;
                        ResultSet resultSet;
                        if (this.isCheckConditionalLimit && x.getLimit() > 0 && (resultSet = st.executeQuery(limitSql = String.format(LIMIT_COUNT, x.getMainTableName(), x.getConditionSql()))).next() && (limit = resultSet.getInt(1)) > x.getLimit()) {
                            throw new InvalidInputsException(InvalidInputsException.getMsg((String[])new String[]{"Conditional delete exceed the request limit"}));
                        }
                        String storageSQL = this.recordUser((ConditionalStoragePackage)x);
                        if (storageSQL != null) {
                            st.addBatch(storageSQL);
                            index.incrementAndGet();
                        }
                        focusRetIndex.add(index.getAndIncrement());
                        st.addBatch(this.buildDelSql((ConditionalStoragePackage)x));
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException(throwable);
                    }
                });
                int[] ints = st.executeBatch();
                Integer n = focusRetIndex.stream().mapToInt(x -> ints[x]).sum();
                return n;
            }
            ConditionalStoragePackage targetStoragePackage = storagePackage.get(0);
            if (this.isCheckConditionalLimit && targetStoragePackage.getLimit() > 0 && (resultSet = st.executeQuery(limitSql = String.format(LIMIT_COUNT, targetStoragePackage.getMainTableName(), targetStoragePackage.getConditionSql()))).next() && (limit = resultSet.getInt(1)) > targetStoragePackage.getLimit()) {
                throw new InvalidInputsException(InvalidInputsException.getMsg((String[])new String[]{"Conditional delete exceed the request limit"}));
            }
            String storageSQL = this.recordUser(targetStoragePackage);
            if (storageSQL != null) {
                st.addBatch(storageSQL);
                index.incrementAndGet();
            }
            focusRetIndex.add(index.getAndIncrement());
            st.addBatch(this.buildDelSql(targetStoragePackage));
            Integer n = st.executeBatch()[(Integer)focusRetIndex.get(0)];
            return n;
        }
    }

    private String buildDelSql(ConditionalStoragePackage storagePackage) {
        String mainTableName = storagePackage.getMainTableName();
        StringBuilder base = new StringBuilder();
        base.append("DELETE ");
        if (storagePackage.getRelatedTable().size() > 1) {
            base.append(String.join((CharSequence)",", storagePackage.getRelatedTable()));
        }
        base.append(" FROM ").append(mainTableName);
        String conditionSql = storagePackage.getConditionSql();
        if (!StringUtils.isEmpty((String)conditionSql)) {
            base.append(" where ").append(conditionSql);
        }
        if (storagePackage.getLimit() > 0 && storagePackage.getRelatedTable().size() < 2) {
            base.append(" limit ").append(storagePackage.getLimit());
        }
        return base.toString();
    }

    private String buildUpdateSql(ConditionalStoragePackage storagePackage) throws SQLException {
        String mainTableName = storagePackage.getMainTableName();
        StringBuilder base = new StringBuilder();
        base.append("UPDATE ").append(mainTableName).append(" SET ");
        String conditionSql = storagePackage.getConditionSql();
        List<String> tableNames = storagePackage.getRelatedTable();
        boolean isFirst = true;
        for (String targetTable : tableNames) {
            if (isFirst) {
                isFirst = false;
            } else {
                base.append(",");
            }
            String concatColumn = targetTable.concat(".").concat("_sys_ver");
            String concatOperate = targetTable.concat(".").concat("_sys_operatetime");
            base.append(concatColumn).append(" = ").append(concatColumn).append(" +1 ");
            base.append(",").append(concatOperate).append(" = ").append(System.currentTimeMillis());
            String update = String.format(UPDATE_USER, targetTable.concat("._sys_dynamic"), Optional.ofNullable(this.delUserId).orElse(0L), Optional.ofNullable(this.delUser).orElse("\u7cfb\u7edf"));
            base.append(",").append(targetTable).append(".").append("_sys_dynamic").append(" = ").append(update);
        }
        if (StringUtils.isEmpty((String)conditionSql)) {
            throw new InvalidInputsException(InvalidInputsException.getMsg((String[])new String[]{"Conditional update should always has a range"}));
        }
        base.append(" where ").append(conditionSql);
        return base.toString();
    }
}

