/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor;

import com.google.common.collect.Sets;
import com.xforceplus.ultraman.metadata.values.IValue;
import com.xforceplus.ultraman.oqsengine.plus.common.StringUtils;
import com.xforceplus.ultraman.oqsengine.plus.common.executor.Executor;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.ConditionalStorageEntity;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.ConditionalStoragePackage;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.MasterStorageEntity;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.StorageType;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor.AbstractMasterTaskExecutor;
import com.xforceplus.ultraman.oqsengine.plus.meta.pojo.dto.table.SystemColumn;
import com.xforceplus.ultraman.sdk.core.utils.MasterStorageHelper;
import com.xforceplus.ultraman.sdk.infra.codec.MySQLCodecCustom;
import com.xforceplus.ultraman.sdk.infra.exceptions.InvalidInputsException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.codecs.Codec;

public class ConditionalReplaceExecutor
extends AbstractMasterTaskExecutor<List<ConditionalStoragePackage>, Integer> {
    private boolean isCheckConditionalLimit = false;
    private Codec<Character> mySQLCodec = new MySQLCodecCustom(MySQLCodecCustom.Mode.STANDARD);
    private static final String LIMIT_COUNT = "SELECT COUNT(*) from %s where %s";

    public ConditionalReplaceExecutor(Connection connection, long time, boolean isCheckConditionalLimit) {
        super(connection, time);
        this.isCheckConditionalLimit = isCheckConditionalLimit;
    }

    public static Executor<List<ConditionalStoragePackage>, Integer> build(Connection connection, long timeout, boolean isCheckConditionalLimit) {
        return new ConditionalReplaceExecutor(connection, timeout, isCheckConditionalLimit);
    }

    public Integer execute(List<ConditionalStoragePackage> storagePackage) throws SQLException {
        if (storagePackage.isEmpty()) {
            return 0;
        }
        try (Statement st = this.getConnection().createStatement();){
            int limit;
            String limitSql;
            ResultSet resultSet;
            if (storagePackage.size() > 1) {
                storagePackage.forEach(x -> {
                    try {
                        String sql = this.buildSql((ConditionalStoragePackage)x);
                        st.addBatch(sql);
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                });
                int[] ints = st.executeBatch();
                Integer n = Arrays.stream(ints).sum();
                return n;
            }
            ConditionalStoragePackage targetStoragePackage = storagePackage.get(0);
            if (this.isCheckConditionalLimit && targetStoragePackage.getLimit() > 0 && (resultSet = st.executeQuery(limitSql = String.format(LIMIT_COUNT, targetStoragePackage.getMainTableName(), targetStoragePackage.getConditionSql()))).next() && (limit = resultSet.getInt(1)) > targetStoragePackage.getLimit()) {
                throw new InvalidInputsException(InvalidInputsException.getMsg((String[])new String[]{"Conditional replace exceed the request limit"}));
            }
            Integer n = st.executeUpdate(this.buildSql(targetStoragePackage));
            return n;
        }
    }

    private String buildSql(ConditionalStoragePackage storagePackage) throws SQLException {
        String mainTableName = storagePackage.getMainTableName();
        StringBuilder base = new StringBuilder();
        base.append("UPDATE ").append(mainTableName).append(" SET ");
        String conditionSql = storagePackage.getConditionSql();
        List<ConditionalStorageEntity> conditionalStorageList = storagePackage.getConditionalStorageList();
        boolean isFirst = true;
        long sampleTime = 0L;
        List<String> relatedTable = storagePackage.getRelatedTable();
        HashSet<String> todo = new HashSet<String>(relatedTable);
        HashSet<String> done = new HashSet<String>();
        for (ConditionalStorageEntity storageEntity : conditionalStorageList) {
            if (isFirst) {
                isFirst = false;
            } else {
                base.append(",");
            }
            String targetTable = storageEntity.getTargetTable();
            done.add(targetTable);
            String concatColumn = targetTable.concat(".").concat("_sys_ver");
            String concatOperate = targetTable.concat(".").concat("_sys_operatetime");
            base.append(concatColumn).append(" = ").append(concatColumn).append(" +1 ");
            sampleTime = storageEntity.getSystemColumn().getOperateTime();
            base.append(",").append(concatOperate).append(" = ").append(storageEntity.getSystemColumn().getOperateTime());
            for (MasterStorageEntity.TypedStorageValue value : storageEntity.getBusinessStaticFields()) {
                String columnName = value.getEntityField().name();
                if (SystemColumn.SYSTEM_WORDS.contains(columnName)) continue;
                StorageType storageType = StorageType.instance(value.getEntityField().type());
                if (null == storageType) {
                    throw new SQLException("storageType not found.");
                }
                base.append(",").append(targetTable.concat(".").concat(MasterStorageHelper.toStorageName((String)columnName, (boolean)true))).append("=");
                if (value.getValue() == null) {
                    base.append("null");
                    continue;
                }
                Object targetValue = value.isKeepRaw() ? value.getValue() : (storageType.isNeedSymbol() ? String.format("'%s'", ESAPI.encoder().encodeForSQL(this.mySQLCodec, value.getValue().toString())) : value.getValue());
                base.append(targetValue);
            }
            List<IValue> businessDynamicFields = storageEntity.getBusinessDynamicFields();
            if (businessDynamicFields == null || businessDynamicFields.isEmpty()) continue;
            Map<String, Object> attachment = storageEntity.getAttachment();
            Map painValues = MasterStorageHelper.toPainValues(businessDynamicFields);
            HashMap<String, Object> dynamicMap = new HashMap<String, Object>(painValues);
            dynamicMap.putAll(attachment);
            String replace = MasterStorageHelper.buildReplace(dynamicMap, this.mySQLCodec, (String)targetTable);
            String remove = MasterStorageHelper.buildRemove(dynamicMap, (String)targetTable);
            if (!replace.isEmpty()) {
                base.append(",");
                base.append(targetTable.concat(".").concat("_sys_dynamic")).append("=").append(replace);
            }
            if (remove.isEmpty()) continue;
            base.append(",");
            base.append(targetTable.concat(".").concat("_sys_dynamic")).append("=").append(remove);
        }
        for (String target : Sets.difference(todo, done)) {
            if (isFirst) {
                isFirst = false;
            } else {
                base.append(",");
            }
            String concatColumn = target.concat(".").concat("_sys_ver");
            String concatOperate = target.concat(".").concat("_sys_operatetime");
            base.append(concatColumn).append(" = ").append(concatColumn).append(" +1 ");
            base.append(",").append(concatOperate).append(" = ").append(sampleTime);
        }
        if (StringUtils.isEmpty((String)conditionSql)) {
            throw new InvalidInputsException(InvalidInputsException.getMsg((String[])new String[]{"Conditional update should always has a range"}));
        }
        base.append(" where ").append(conditionSql);
        return base.toString();
    }
}

