/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor;

import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.values.IValue;
import com.xforceplus.ultraman.metadata.values.OnDuplicateValue;
import com.xforceplus.ultraman.oqsengine.plus.common.executor.Executor;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.MasterStorageEntity;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.StorageType;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor.AbstractMasterTaskExecutor;
import com.xforceplus.ultraman.oqsengine.plus.meta.pojo.dto.Operation;
import com.xforceplus.ultraman.oqsengine.plus.meta.pojo.dto.table.SystemColumn;
import com.xforceplus.ultraman.sdk.core.utils.MasterStorageHelper;
import com.xforceplus.ultraman.sdk.infra.codec.MySQLCodecCustom;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.codecs.Codec;

public class CreateExecutor
extends AbstractMasterTaskExecutor<List<MasterStorageEntity>, Boolean[]> {
    private Codec<Character> mySQLCodec = new MySQLCodecCustom(MySQLCodecCustom.Mode.STANDARD);

    public CreateExecutor(Connection connection, long timeout) {
        super(connection, timeout);
    }

    public static Executor<List<MasterStorageEntity>, Boolean[]> build(Connection connection, long timeout) {
        return new CreateExecutor(connection, timeout);
    }

    public Boolean[] execute(List<MasterStorageEntity> collection) throws SQLException {
        try (Statement st = this.getConnection().createStatement();){
            boolean isBatch;
            this.checkTimeout(st);
            boolean bl = isBatch = collection.size() > 1;
            if (isBatch) {
                for (int i = 0; i < collection.size(); ++i) {
                    String sql = this.buildSql(collection.get(i));
                    st.addBatch(sql);
                }
                Boolean[] i = this.executedUpdate(st, true);
                return i;
            }
            String sql = this.buildSql(collection.get(0));
            Boolean[] booleanArray = new Boolean[]{st.executeUpdate(sql) > 0};
            return booleanArray;
        }
    }

    protected String buildSql(MasterStorageEntity masterStorageEntity) throws SQLException {
        StringBuilder base = new StringBuilder();
        base.append("INSERT INTO ").append(masterStorageEntity.getTableName()).append(" (");
        base.append(String.join((CharSequence)",", "id", "_sys_entityclass", "_sys_ver", "_sys_operatetime", "_sys_deleted", "_sys_profile"));
        if (!masterStorageEntity.getBusinessStaticFields().isEmpty()) {
            for (MasterStorageEntity.TypedStorageValue value : masterStorageEntity.getBusinessStaticFields()) {
                String columnName = value.getEntityField().name().toLowerCase();
                if (SystemColumn.SYSTEM_WORDS.contains(columnName)) continue;
                base.append(",").append(MasterStorageHelper.toStorageName((String)columnName, (boolean)true));
            }
        }
        base.append(",").append("_sys_dynamic");
        base.append(") VALUES (");
        base.append(masterStorageEntity.getSystemColumn().getId()).append(",").append(masterStorageEntity.getSystemColumn().getEntityClass()).append(",").append(masterStorageEntity.getSystemColumn().getVersion()).append(",").append(masterStorageEntity.getSystemColumn().getOperateTime()).append(",").append(masterStorageEntity.getSystemColumn().getDeleted()).append(",").append("'").append(masterStorageEntity.getSystemColumn().getProfile()).append("'");
        if (!masterStorageEntity.getBusinessStaticFields().isEmpty()) {
            for (MasterStorageEntity.TypedStorageValue value : masterStorageEntity.getBusinessStaticFields()) {
                if (SystemColumn.SYSTEM_WORDS.contains(value.getEntityField().name())) continue;
                StorageType storageType = StorageType.instance(value.getEntityField().type());
                if (null == storageType) {
                    throw new SQLException("storageType not found.");
                }
                if (value.getValue() != null) {
                    Object targetValue = value.isKeepRaw() ? value.getValue() : (storageType.isNeedSymbol() ? String.format("'%s'", ESAPI.encoder().encodeForSQL(this.mySQLCodec, value.getValue().toString())) : value.getValue());
                    base.append(",").append(targetValue);
                    continue;
                }
                base.append(",").append("null");
            }
        }
        if (!masterStorageEntity.getBusinessDynamicFields().isEmpty()) {
            List<IValue> businessDynamicFields = masterStorageEntity.getBusinessDynamicFields();
            Map<String, Object> attachment = masterStorageEntity.getAttachment();
            Map painValues = MasterStorageHelper.toPainValues(businessDynamicFields);
            HashMap<String, Object> dynamicMap = new HashMap<String, Object>(painValues);
            dynamicMap.putAll(attachment);
            base.append(",").append("'").append(MasterStorageHelper.toBuildJson(dynamicMap)).append("'");
        } else {
            base.append(",").append("'").append("{}").append("'");
        }
        base.append(") ");
        boolean hasOnDuplicated = this.checkHashOnDuplicated(masterStorageEntity);
        if (hasOnDuplicated) {
            base.append(" ON DUPLICATE KEY UPDATE ");
            base.append("_sys_ver").append("=").append("_sys_ver").append("+1");
            base.append(",").append("_sys_operatetime").append("=").append(masterStorageEntity.getSystemColumn().getOperateTime());
            if (!masterStorageEntity.getBusinessStaticFields().isEmpty()) {
                for (MasterStorageEntity.TypedStorageValue value : masterStorageEntity.getBusinessStaticFields()) {
                    StorageType storageType;
                    String columnName = value.getEntityField().name();
                    if (value.getRawValue() instanceof OnDuplicateValue) {
                        if (SystemColumn.SYSTEM_WORDS.contains(columnName)) continue;
                        storageType = StorageType.instance(value.getEntityField().type());
                        if (null == storageType) {
                            throw new SQLException("storageType not found.");
                        }
                        base.append(",").append(MasterStorageHelper.toStorageName((String)columnName, (boolean)true)).append("=");
                        Object o = ((OnDuplicateValue)value.getRawValue()).storageValue(Operation.REPLACE);
                        if (o == null) {
                            base.append("null");
                            continue;
                        }
                        Object targetValue = o;
                        targetValue = value.isKeepRawOnDuplicate() ? o : (storageType.isNeedSymbol() ? String.format("'%s'", ESAPI.encoder().encodeForSQL(this.mySQLCodec, targetValue.toString())) : targetValue);
                        base.append(targetValue);
                        continue;
                    }
                    if (!SystemColumn.UPDATE_WORDS.contains(columnName)) continue;
                    storageType = StorageType.instance(value.getEntityField().type());
                    if (null == storageType) {
                        throw new SQLException("storageType not found.");
                    }
                    base.append(",").append(MasterStorageHelper.toStorageName((String)columnName, (boolean)true)).append("=");
                    if (value.getValue() != null) {
                        Object targetValue = value.isKeepRaw() ? value.getValue() : (storageType.isNeedSymbol() ? String.format("'%s'", ESAPI.encoder().encodeForSQL(this.mySQLCodec, value.getValue().toString())) : value.getValue());
                        base.append(targetValue);
                        continue;
                    }
                    base.append("null");
                }
            }
            List<IValue> businessDynamicFields = masterStorageEntity.getBusinessDynamicFields();
            Map<String, Object> attachment = masterStorageEntity.getAttachment();
            List onDuplicatedValues = businessDynamicFields.stream().filter(x -> x instanceof OnDuplicateValue).map(x -> (OnDuplicateValue)x).collect(Collectors.toList());
            Map painValues = MasterStorageHelper.toPainOnDuplicateValues(onDuplicatedValues);
            HashMap<String, Object> dynamicMap = new HashMap<String, Object>(painValues);
            dynamicMap.putAll(attachment);
            String replace = MasterStorageHelper.buildReplace(dynamicMap, this.mySQLCodec, null);
            String remove = MasterStorageHelper.buildRemove(dynamicMap, null);
            if (!replace.isEmpty()) {
                base.append(",");
                base.append("_sys_dynamic").append("=").append(replace);
            }
            if (!remove.isEmpty()) {
                base.append(",");
                base.append("_sys_dynamic").append("=").append(remove);
            }
        }
        return base.toString();
    }

    boolean checkHashOnDuplicated(MasterStorageEntity masterStorageEntity) {
        EntityClassGroup rawEntityClass = masterStorageEntity.getRawEntityClass();
        Collection indexes = rawEntityClass.getEntityClass().indexes();
        List onDuplicated = indexes.stream().filter(x -> x.getRule() == 1).collect(Collectors.toList());
        return !onDuplicated.isEmpty();
    }
}

