/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor;

import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.plus.common.executor.Executor;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.MasterEntity;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.MasterStorageEntity;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor.AbstractMasterTaskExecutor;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class DeleteExecutor
extends AbstractMasterTaskExecutor<List<MasterStorageEntity>, Boolean[]> {
    private static final String UPDATE_SQL = "UPDATE %s set _sys_dynamic = %s, _sys_operatetime = %s where id in (%s)";
    private static final String UPDATE_USER = "JSON_MERGE_PATCH(_sys_dynamic, '{\"#a\":{\"deluid\": %s, \"deluname\":\"%s\"}}')";
    private boolean recordUser;
    private String delUser;
    private Long delUserId;

    public DeleteExecutor(Connection connection, long timeout, boolean recordUser, String currentUser, Long currentUserId) {
        super(connection, timeout);
        this.recordUser = recordUser;
        this.delUser = currentUser;
        this.delUserId = currentUserId;
    }

    public static Executor<List<MasterStorageEntity>, Boolean[]> build(Connection connection, long timeout, boolean recordUser, String currentUser, Long currentUserId) {
        return new DeleteExecutor(connection, timeout, recordUser, currentUser, currentUserId);
    }

    public Boolean[] execute(List<MasterStorageEntity> masterStorageEntities) throws SQLException {
        boolean isBatch = masterStorageEntities.size() > 1;
        ArrayList<Integer> focusRetIndex = new ArrayList<Integer>();
        AtomicInteger index = new AtomicInteger(0);
        try (Statement st = this.getConnection().createStatement();){
            this.checkTimeout(st);
            if (isBatch) {
                if (this.recordUser) {
                    String update = String.format(UPDATE_USER, Optional.ofNullable(this.delUserId).orElse(0L), Optional.ofNullable(this.delUser).orElse("\u7cfb\u7edf"));
                    Map<String, List<MasterStorageEntity>> map = masterStorageEntities.stream().collect(Collectors.groupingBy(MasterEntity::getTableName));
                    map.forEach((k, v) -> {
                        String ids = v.stream().map(x -> x.getSystemColumn().getId()).filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(","));
                        OptionalLong max = v.stream().mapToLong(x -> x.getSystemColumn().getOperateTime()).max();
                        String updateSQL = String.format(UPDATE_SQL, k, update, max.orElse(0L), ids);
                        try {
                            st.addBatch(updateSQL);
                            index.incrementAndGet();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    });
                }
                for (MasterStorageEntity masterStorageEntity : masterStorageEntities) {
                    String sql = this.buildSql(masterStorageEntity);
                    st.addBatch(sql);
                    focusRetIndex.add(index.getAndIncrement());
                    if (!masterStorageEntity.isOnlyFather()) continue;
                    List<String> sqlList = this.buildChildSql(masterStorageEntity);
                    for (String childSql : sqlList) {
                        st.addBatch(childSql);
                        index.incrementAndGet();
                    }
                }
                Boolean[] booleans = this.executedUpdate(st, true);
                Boolean[] booleanArray = (Boolean[])focusRetIndex.stream().map(x -> booleans[x]).toArray(Boolean[]::new);
                return booleanArray;
            }
            MasterStorageEntity entity = masterStorageEntities.get(0);
            if (this.recordUser) {
                String string = String.format(UPDATE_USER, Optional.ofNullable(this.delUserId).orElse(0L), Optional.ofNullable(this.delUser).orElse("\u7cfb\u7edf"));
                String updateSQL = String.format(UPDATE_SQL, entity.getTableName(), string, entity.getSystemColumn().getOperateTime(), entity.getSystemColumn().getId());
                st.addBatch(updateSQL);
                index.incrementAndGet();
            }
            String string = this.buildSql(entity);
            st.addBatch(string);
            focusRetIndex.add(index.getAndIncrement());
            if (entity.isOnlyFather()) {
                List<String> sqlList = this.buildChildSql(entity);
                sqlList.stream().forEach(targetSql -> {
                    try {
                        st.addBatch((String)targetSql);
                        index.incrementAndGet();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                });
            }
            Boolean[] booleans = this.executedUpdate(st, true);
            Boolean[] booleanArray = (Boolean[])focusRetIndex.stream().map(x -> booleans[x]).toArray(Boolean[]::new);
            return booleanArray;
        }
    }

    protected String buildSql(MasterStorageEntity masterStorageEntity) {
        StringBuilder base = new StringBuilder();
        base.append("DELETE FROM ").append(masterStorageEntity.getTableName());
        base.append(" ").append("where id").append("=").append(masterStorageEntity.getSystemColumn().getId());
        return base.toString();
    }

    protected List<String> buildChildSql(MasterStorageEntity masterStorageEntity) {
        EntityClassGroup rawEntityClass = masterStorageEntity.getRawEntityClass();
        Collection childrenEntityClass = rawEntityClass.getChildrenEntityClass();
        ArrayList<String> childrenSql = new ArrayList<String>();
        for (IEntityClass entityClass : childrenEntityClass) {
            String targetTable = entityClass.masterWriteTable(masterStorageEntity.isProfiled());
            StringBuilder base = new StringBuilder();
            base.append("DELETE FROM ").append(targetTable);
            base.append(" ").append("where id").append("=").append(masterStorageEntity.getSystemColumn().getId());
            String targetSql = base.toString();
            childrenSql.add(targetSql);
        }
        return childrenSql;
    }
}

