/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor;

import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.plus.storage.pojo.dto.select.SelectConfig;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.Tuple3;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuerySubSystemExecutor {
    private static final Logger log = LoggerFactory.getLogger(QuerySubSystemExecutor.class);
    private static String QUERY_RAW_POLY = "SELECT id, _sys_profile, _sys_entityclass, _sys_ver from %s where id in (%s) and (_sys_profile != ? or _sys_entityclass != ?)";
    private EntityClassEngine engine;

    public QuerySubSystemExecutor(EntityClassEngine engine) {
        this.engine = engine;
    }

    public Map<String, List<Tuple3<Long, String, Long>>> execute(SelectConfig selectConfig, Connection resource, IEntityClass entityClass) throws SQLException {
        List idsList = selectConfig.getIds();
        HashMap<String, List<Tuple3<Long, String, Long>>> tableMapping = new HashMap<String, List<Tuple3<Long, String, Long>>>();
        if (idsList != null && !idsList.isEmpty()) {
            String ids = idsList.stream().map(Object::toString).collect(Collectors.joining(","));
            String systemSQL = String.format(QUERY_RAW_POLY, String.join((CharSequence)",", entityClass.masterQueryTable()), ids);
            log.debug("System SQL is systemSQL {}", (Object)systemSQL);
            PreparedStatement statement = resource.prepareStatement(systemSQL);
            String realProfile = entityClass.realProfile();
            if (realProfile == null) {
                realProfile = "";
            }
            statement.setString(1, realProfile);
            statement.setLong(2, entityClass.id());
            ArrayList<Tuple3> ployList = new ArrayList<Tuple3>();
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    ployList.add(Tuple.of((Object)resultSet.getLong(1), (Object)resultSet.getString(2), (Object)resultSet.getLong(3)));
                }
            }
            Map<Tuple2, List<Tuple3>> grouped = ployList.stream().collect(Collectors.groupingBy(x -> Tuple.of((Object)((Long)x._3), (Object)((String)x._2))));
            grouped.forEach((k, v) -> {
                String targetTable = this.findTargetTable((Tuple2<Long, String>)k);
                if (targetTable != null) {
                    tableMapping.compute(targetTable, (k1, v1) -> {
                        if (v1 == null) {
                            v1 = new ArrayList(v);
                        } else {
                            v1.addAll(v);
                        }
                        return v1;
                    });
                }
            });
        }
        return tableMapping;
    }

    private String findTargetTable(Tuple2<Long, String> tuple) {
        Optional load = this.engine.load(((Long)tuple._1).toString(), (String)tuple._2);
        if (load.isPresent()) {
            return ((IEntityClass)load.get()).masterQueryTable();
        }
        return null;
    }
}

