/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor;

import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.values.IValue;
import com.xforceplus.ultraman.oqsengine.plus.common.executor.Executor;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.MasterEntity;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.MasterStorageEntity;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.StorageType;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor.AbstractMasterTaskExecutor;
import com.xforceplus.ultraman.oqsengine.plus.meta.pojo.dto.table.SystemColumn;
import com.xforceplus.ultraman.sdk.core.utils.MasterStorageHelper;
import com.xforceplus.ultraman.sdk.infra.codec.MySQLCodecCustom;
import com.xforceplus.ultraman.sdk.infra.exceptions.SQLRelatedException;
import io.vavr.Tuple;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.codecs.Codec;

public class UpdateExecutor
extends AbstractMasterTaskExecutor<List<MasterStorageEntity>, Boolean[]> {
    private Codec<Character> mySQLCodec = new MySQLCodecCustom(MySQLCodecCustom.Mode.STANDARD);

    public UpdateExecutor(Connection resource, long timeout) {
        super(resource, timeout);
    }

    public static Executor<List<MasterStorageEntity>, Boolean[]> build(Connection resource, long timeout) {
        return new UpdateExecutor(resource, timeout);
    }

    public Boolean[] execute(List<MasterStorageEntity> masterStorageEntities) throws SQLException {
        boolean isBatch = masterStorageEntities.size() > 1;
        ArrayList<Integer> focusRetIndex = new ArrayList<Integer>();
        AtomicInteger index = new AtomicInteger(0);
        try (Statement st = this.getConnection().createStatement();){
            Map<String, List<MasterStorageEntity>> groupedMapping = masterStorageEntities.stream().filter(x -> x.isUseOptimisticLock() || x.getSystemColumn().getVersion() > -1L).collect(Collectors.groupingBy(MasterEntity::getTableName));
            HashMap versionMap = new HashMap();
            if (!groupedMapping.isEmpty()) {
                groupedMapping.forEach((k, list) -> {
                    String querySql = this.buildVersionQuerySql((String)k, (List<MasterStorageEntity>)list);
                    try {
                        ResultSet resultSet = st.executeQuery(querySql);
                        while (resultSet.next()) {
                            long id = resultSet.getLong("id");
                            Object sysVer = resultSet.getObject("_sys_ver");
                            if (sysVer == null) continue;
                            versionMap.put(Tuple.of((Object)k, (Object)id), resultSet.getInt("_sys_ver"));
                        }
                    }
                    catch (SQLException e) {
                        throw new SQLRelatedException(e);
                    }
                });
            }
            masterStorageEntities.stream().filter(x -> x.isUseOptimisticLock() && x.getSystemColumn().getVersion() >= 0L).forEach(masterStorageEntity -> {
                String tableName = masterStorageEntity.getTableName();
                long id = masterStorageEntity.getSystemColumn().getId();
                versionMap.put(Tuple.of((Object)tableName, (Object)id), Long.valueOf(masterStorageEntity.getSystemColumn().getVersion()).intValue());
            });
            if (isBatch) {
                for (MasterStorageEntity masterStorageEntity2 : masterStorageEntities) {
                    Integer ver = (Integer)versionMap.get(Tuple.of((Object)masterStorageEntity2.getTableName(), (Object)masterStorageEntity2.getSystemColumn().getId()));
                    String sql = this.buildSql(masterStorageEntity2, ver);
                    st.addBatch(sql);
                    focusRetIndex.add(index.getAndIncrement());
                    if (!masterStorageEntity2.isOnlyFather()) continue;
                    List<String> sqlList = this.buildChildSql(masterStorageEntity2);
                    for (String childSql : sqlList) {
                        st.addBatch(childSql);
                        index.incrementAndGet();
                    }
                }
                Boolean[] booleans = this.executedUpdate(st, true);
                Boolean[] booleanArray = (Boolean[])focusRetIndex.stream().map(x -> booleans[x]).toArray(Boolean[]::new);
                return booleanArray;
            }
            MasterStorageEntity entity = masterStorageEntities.get(0);
            Integer n = (Integer)versionMap.get(Tuple.of((Object)entity.getTableName(), (Object)entity.getSystemColumn().getId()));
            String sql = this.buildSql(entity, n);
            focusRetIndex.add(index.getAndIncrement());
            st.addBatch(sql);
            if (entity.isOnlyFather()) {
                List<String> sqlList = this.buildChildSql(entity);
                sqlList.stream().forEach(targetSql -> {
                    try {
                        st.addBatch((String)targetSql);
                        index.incrementAndGet();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                });
            }
            Boolean[] booleans = this.executedUpdate(st, true);
            Boolean[] booleanArray = (Boolean[])focusRetIndex.stream().map(x -> booleans[x]).toArray(Boolean[]::new);
            return booleanArray;
        }
    }

    protected List<String> buildChildSql(MasterStorageEntity masterStorageEntity) {
        EntityClassGroup rawEntityClass = masterStorageEntity.getRawEntityClass();
        Collection childrenEntityClass = rawEntityClass.getChildrenEntityClass();
        ArrayList<String> childrenSql = new ArrayList<String>();
        for (IEntityClass entityClass : childrenEntityClass) {
            String targetTable = entityClass.masterWriteTable(masterStorageEntity.isProfiled());
            StringBuilder base = new StringBuilder();
            base.append(String.format("UPDATE %s SET ", targetTable));
            base.append("_sys_ver").append("=").append("_sys_ver").append("+1");
            base.append(",").append("_sys_operatetime").append("=").append(masterStorageEntity.getSystemColumn().getOperateTime());
            base.append(" ").append("where id").append("=").append(masterStorageEntity.getSystemColumn().getId());
            String targetSql = base.toString();
            childrenSql.add(targetSql);
        }
        return childrenSql;
    }

    protected String buildVersionQuerySql(String tableName, List<MasterStorageEntity> entities) {
        StringBuilder base = new StringBuilder();
        base.append("SELECT id, _sys_ver FROM ").append(tableName).append(" WHERE id in (").append(entities.stream().map(x -> String.valueOf(x.getSystemColumn().getId())).collect(Collectors.joining(","))).append(")");
        return base.toString();
    }

    protected String buildSql(MasterStorageEntity entity, Integer ver) throws SQLException {
        List<IValue> businessDynamicFields;
        StringBuilder base = new StringBuilder();
        base.append(String.format("UPDATE %s SET ", entity.getTableName()));
        base.append("_sys_ver").append("=").append("_sys_ver").append("+1");
        base.append(",").append("_sys_operatetime").append("=").append(entity.getSystemColumn().getOperateTime());
        if (!entity.getBusinessStaticFields().isEmpty()) {
            for (MasterStorageEntity.TypedStorageValue value : entity.getBusinessStaticFields()) {
                String columnName = value.getEntityField().name();
                if (SystemColumn.SYSTEM_WORDS.contains(columnName)) continue;
                StorageType storageType = StorageType.instance(value.getEntityField().type());
                if (null == storageType) {
                    throw new SQLException("storageType not found.");
                }
                base.append(",").append(MasterStorageHelper.toStorageName((String)columnName, (boolean)true)).append("=");
                if (value.getValue() == null) {
                    base.append("null");
                    continue;
                }
                Object targetValue = value.isKeepRaw() ? value.getValue() : (storageType.isNeedSymbol() ? String.format("'%s'", ESAPI.encoder().encodeForSQL(this.mySQLCodec, value.getValue().toString())) : value.getValue());
                base.append(targetValue);
            }
        }
        if ((businessDynamicFields = entity.getBusinessDynamicFields()) != null && !businessDynamicFields.isEmpty()) {
            Map<String, Object> attachment = entity.getAttachment();
            Map painValues = MasterStorageHelper.toPainValues(businessDynamicFields);
            HashMap<String, Object> dynamicMap = new HashMap<String, Object>(painValues);
            dynamicMap.putAll(attachment);
            String replace = MasterStorageHelper.buildReplace(dynamicMap, this.mySQLCodec, null);
            String remove = MasterStorageHelper.buildRemove(dynamicMap, null);
            if (!replace.isEmpty()) {
                base.append(",");
                base.append("_sys_dynamic").append("=").append(replace);
            }
            if (!remove.isEmpty()) {
                base.append(",");
                base.append("_sys_dynamic").append("=").append(remove);
            }
        }
        base.append(" ").append("where id").append("=").append(entity.getSystemColumn().getId());
        base.append(" AND ").append("_sys_deleted").append("=").append(false);
        if (ver != null) {
            base.append(" AND ");
            base.append("_sys_ver").append("=").append(ver);
        }
        return base.toString();
    }
}

