/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.master.mysql.query;

import com.google.common.collect.ImmutableList;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.service.DictService;
import com.xforceplus.ultraman.oqsengine.plus.common.StringUtils;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.query.CopyVisitor;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.utils.RexNodeHelper;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableFunctionScan;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalCalc;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.logical.LogicalExchange;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalIntersect;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalMatch;
import org.apache.calcite.rel.logical.LogicalMinus;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;

public class CopyCustomShuttle
implements RelShuttle {
    private RelBuilder builder;
    private Stack<String> termStack = new Stack();
    private EntityClassGroup entityClass;
    private Map<String, String> projectMapping;
    private EntityClassGroup currentEntityClass;
    private Stack<EntityClassGroup> involvedEntityClasses = new Stack();
    private List<EntityClassGroup> allRelatedEntityClasses = new ArrayList<EntityClassGroup>();
    private List<RexDynamicParam> params = new ArrayList<RexDynamicParam>();
    private boolean useStrictEnum = false;
    private DictService dictService;
    private Map<String, List<String>> rewriteMapping;

    public CopyCustomShuttle(RelBuilder builder, DictService dictService, EntityClassGroup entityClassGroup, Map<String, String> projectMapping, boolean useStrictEnum, Map<String, List<String>> rewriteMapping) {
        this.builder = builder;
        this.projectMapping = projectMapping;
        this.entityClass = entityClassGroup;
        this.useStrictEnum = useStrictEnum;
        this.dictService = dictService;
        this.rewriteMapping = rewriteMapping;
    }

    public RelNode visit(TableScan scan) {
        List qualifiedName = scan.getTable().getQualifiedName();
        String schema = (String)qualifiedName.get(1);
        EntityClassGroup group = this.entityClass.relatedEntityClassWithRawName(schema);
        EntityClassGroup entityClassGroup = group.relatedEntityClassWithRawName(schema.toLowerCase());
        if (entityClassGroup == null) {
            throw new RuntimeException("No related EntityClass:" + schema);
        }
        this.involvedEntityClasses.push(entityClassGroup);
        this.allRelatedEntityClasses.add(entityClassGroup);
        this.currentEntityClass = entityClassGroup;
        this.builder = this.builder.scan(new String[]{"oqs", entityClassGroup.getEntityClass().masterQueryTable().toLowerCase()});
        if (this.currentStackHas("OqsengineJoin")) {
            if (!this.currentStackHas("OqsengineFilter", "OqsengineJoin")) {
                RexNode rexNode = this.builder.getRexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.builder.field("_sys_deleted"), this.builder.literal((Object)false)});
                this.builder.filter(new RexNode[]{rexNode});
                if (this.currentStackHas("OqsengineAggregate", "OqsengineJoin")) {
                    if (!this.currentStackHas("OqsengineProject", "OqsengineAggregate")) {
                        this.expandProject((RelNode)scan, true);
                    }
                } else if (!this.currentStackHas("OqsengineProject")) {
                    this.expandProject((RelNode)scan, true);
                }
            }
        } else if (this.currentStackHas("OqsengineAggregate")) {
            if (!this.currentStackHas("OqsengineProject", "OqsengineAggregate")) {
                this.expandProject((RelNode)scan, true);
            }
        } else if (!this.currentStackHas("OqsengineProject")) {
            this.expandProject((RelNode)scan, true);
        }
        return scan;
    }

    public RelNode visit(TableFunctionScan scan) {
        return null;
    }

    public RelNode visit(LogicalValues values) {
        if (values != null && values.getTuples().isEmpty()) {
            this.builder.projectPlus((Iterable)this.builder.values(values.getRowType()).fields());
        }
        return null;
    }

    public RelNode visit(LogicalFilter filter) {
        return null;
    }

    public RelNode visit(LogicalCalc calc) {
        return null;
    }

    public RelNode visit(LogicalProject project) {
        return null;
    }

    public RelNode visit(LogicalJoin join) {
        return null;
    }

    public RelNode visit(LogicalCorrelate correlate) {
        return null;
    }

    public RelNode visit(LogicalUnion union) {
        return null;
    }

    public RelNode visit(LogicalIntersect intersect) {
        return null;
    }

    public RelNode visit(LogicalMinus minus) {
        return null;
    }

    public RelNode visit(LogicalAggregate aggregate) {
        return null;
    }

    public RelNode visit(LogicalMatch match) {
        return null;
    }

    public RelNode visit(LogicalSort sort) {
        sort.getInput(0).accept((RelShuttle)this);
        this.builder.sort((Iterable)this.builder.fields());
        return null;
    }

    public RelNode visit(LogicalExchange exchange) {
        return null;
    }

    public RelNode visit(LogicalTableModify modify) {
        return null;
    }

    private boolean currentStackHas(String term) {
        int termSearch = this.termStack.search(term);
        return termSearch > 0;
    }

    private boolean currentStackHas(String term, String before) {
        int termSearch = this.termStack.search(term);
        int beforeSearch = this.termStack.search(before);
        if (termSearch > 0) {
            if (beforeSearch > 0) {
                return termSearch < beforeSearch;
            }
            return true;
        }
        return false;
    }

    public RelNode visit(RelNode other) {
        this.termStack.push(other.getRelTypeName());
        other.getInputs().forEach(x -> x.accept((RelShuttle)this));
        if (this.builder.peek() instanceof LogicalValues) {
            return this.builder.peek();
        }
        if (other instanceof Aggregate) {
            this.termStack.pop();
            RelDataType rowType = other.getInput(0).getRowType();
            ImmutableBitSet groupSets = ((Aggregate)other).getGroupSet();
            ArrayList<String> keys = new ArrayList<String>();
            Iterator iterator = groupSets.iterator();
            while (iterator.hasNext()) {
                int group = (Integer)iterator.next();
                String rawKey = (String)((RelDataTypeField)rowType.getFieldList().get(group)).getKey();
                keys.add(this.nameConvertString(rowType, rawKey, this.entityClass));
            }
            List newAgg = ((Aggregate)other).getNamedAggCalls().stream().map(x -> this.aggregateConvert((AggregateCall)x.getKey(), this.builder, rowType, this.builder.peek().getRowType(), this.currentEntityClass, (String)x.getValue())).collect(Collectors.toList());
            this.builder = this.builder.aggregate(this.builder.groupKey(keys.toArray(new String[0])), newAgg);
        } else if (other instanceof Project) {
            this.termStack.pop();
            List namedProjects = ((Project)other).getNamedProjects();
            ArrayList<String> nameList = new ArrayList<String>();
            List<Object> refs = new ArrayList();
            RelNode input = ((Project)other).getInput();
            if (((Project)other).getInput() instanceof Join) {
                RelNode left = input.getInput(0);
                RelNode right = input.getInput(1);
                EntityClassGroup leftEntityClass = this.findRelatedEntityClass(left);
                EntityClassGroup rightEntityClass = this.findRelatedEntityClass(right);
                refs = namedProjects.stream().map(x -> {
                    nameList.add((String)x.getValue());
                    return this.transformProject((RexNode)x.getKey(), other, Arrays.asList(leftEntityClass, rightEntityClass), this.builder);
                }).filter(Objects::nonNull).collect(Collectors.toList());
            } else if (((Project)other).getInput() instanceof LogicalValues) {
                List namedProjects1 = ((Project)other).getNamedProjects();
                LogicalValues values = (LogicalValues)((Project)other).getInput();
                ImmutableList tuples = values.getTuples();
                for (Pair pair : namedProjects1) {
                    int index = ((RexInputRef)pair.getKey()).getIndex();
                    boolean containsValue = tuples.size() > index;
                    refs.addAll(containsValue ? (Set<RexLiteral>)tuples.get(index) : Collections.singleton(this.builder.literal(null)));
                    nameList.add((String)pair.getValue());
                }
            } else {
                refs = namedProjects.stream().map(x -> {
                    nameList.add((String)x.getValue());
                    return this.transformProject((RexNode)x.getKey(), other, Collections.singletonList(this.currentEntityClass), this.builder);
                }).filter(Objects::nonNull).collect(Collectors.toList());
            }
            this.builder = this.builder.project(refs, nameList, true);
        } else if (other instanceof Sort) {
            this.termStack.pop();
            Sort sort = (Sort)other;
            RelDataType rowType = ((Sort)other).getInput().getRowType();
            RelCollation collation = ((Sort)other).getCollation();
            ArrayList<RexNode> sortRexNodes = new ArrayList<RexNode>();
            for (RelFieldCollation fieldCollation : collation.getFieldCollations()) {
                int fieldIndex = fieldCollation.getFieldIndex();
                RexNode rexNode = RexNodeHelper.convert(this.builder, fieldIndex, this.allRelatedEntityClasses, (RelNode)sort, true, 1);
                if (fieldCollation.getDirection() == RelFieldCollation.Direction.DESCENDING) {
                    sortRexNodes.add(this.builder.desc(rexNode));
                    continue;
                }
                sortRexNodes.add(rexNode);
            }
            if (!sortRexNodes.isEmpty()) {
                this.builder.sort(sortRexNodes);
            }
            RexNode offset = sort.offset;
            RexNode fetch = sort.fetch;
            int offsetInt = 0;
            int size = 0;
            if (offset != null) {
                offsetInt = (Integer)((RexLiteral)offset).getValueAs(Integer.class);
            }
            if (fetch != null) {
                size = (Integer)((RexLiteral)fetch).getValueAs(Integer.class);
            }
            if (offset != null || fetch != null) {
                this.builder.limit(offsetInt, size);
            }
        } else if (other instanceof Filter) {
            this.termStack.pop();
            CopyVisitor copyVisitor = new CopyVisitor(this.builder, this.allRelatedEntityClasses, other, this.useStrictEnum, this.dictService, this.rewriteMapping);
            RexNode transformed = (RexNode)((Filter)other).getCondition().accept((RexVisitor)copyVisitor);
            this.params.addAll(copyVisitor.getDynamic());
            if (((Filter)other).getInput() instanceof TableScan) {
                RexNode rexNode = this.builder.getRexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.builder.field("_sys_deleted"), this.builder.literal((Object)false)});
                this.builder.filter(new RexNode[]{this.builder.and(new RexNode[]{transformed, rexNode})});
            } else {
                this.builder.filter(new RexNode[]{transformed});
            }
            if (!this.currentStackHas("OqsengineProject")) {
                this.expandProject(other, false);
            }
        } else if (other instanceof Join) {
            this.termStack.pop();
            EntityClassGroup leftEntityGroup = null;
            EntityClassGroup rightEntityGroup = null;
            if (this.involvedEntityClasses.size() == 1) {
                leftEntityGroup = this.involvedEntityClasses.pop();
            } else {
                rightEntityGroup = this.involvedEntityClasses.pop();
                leftEntityGroup = this.involvedEntityClasses.pop();
            }
            this.involvedEntityClasses.push(leftEntityGroup);
            CopyVisitor copyVisitor = null;
            copyVisitor = rightEntityGroup == null ? new CopyVisitor(this.builder, Arrays.asList(leftEntityGroup), other, this.useStrictEnum, this.dictService, this.rewriteMapping) : new CopyVisitor(this.builder, Arrays.asList(leftEntityGroup, rightEntityGroup), other, this.useStrictEnum, this.dictService, this.rewriteMapping);
            RexNode transformed = (RexNode)((Join)other).getCondition().accept((RexVisitor)copyVisitor);
            this.builder.join(((Join)other).getJoinType(), transformed);
        }
        return null;
    }

    public List<RexDynamicParam> getParams() {
        return this.params;
    }

    private EntityClassGroup findRelatedEntityClass(RelNode relNode) {
        Stack<RelNode> stack = new Stack<RelNode>();
        stack.push(relNode);
        while (!stack.isEmpty()) {
            RelNode input;
            RelNode next = (RelNode)stack.pop();
            if (next instanceof TableScan) {
                RelOptTable table = ((TableScan)next).getTable();
                String entityCode = (String)table.getQualifiedName().get(1);
                Optional<EntityClassGroup> first = this.allRelatedEntityClasses.stream().filter(x -> x.getEntityClass().code().equalsIgnoreCase(entityCode)).findFirst();
                if (!first.isPresent()) continue;
                return first.get();
            }
            if (next instanceof BiRel) {
                input = next.getInput(0);
                stack.push(input);
                continue;
            }
            input = next.getInput(0);
            stack.push(input);
        }
        throw new RuntimeException("No Related EntityClass");
    }

    private String nameConvertString(RelDataType currentType, String originName, EntityClassGroup entityClass) {
        String targetName = originName.toLowerCase();
        Optional fieldOp = entityClass.field(targetName);
        if (fieldOp.isPresent()) {
            IEntityField field = (IEntityField)fieldOp.get();
            String name = field.name();
            return currentType.getFieldNames().stream().filter(x -> x.equalsIgnoreCase(name)).findFirst().orElse(name);
        }
        return originName;
    }

    private void expandProject(RelNode current, boolean withSystem) {
        ArrayList fieldList;
        if (current instanceof Filter) {
            current = current.getInput(0);
        }
        ArrayList rightList = new ArrayList();
        if (current instanceof BiRel) {
            List leftFields = current.getInput(0).getRowType().getFieldList();
            List rightFields = current.getInput(1).getRowType().getFieldList();
            fieldList = new ArrayList(leftFields);
            rightList.addAll(rightFields);
        } else {
            fieldList = current.getRowType().getFieldList();
        }
        ArrayList nameList = new ArrayList();
        RelNode finalCurrent = current;
        ArrayList targetRefs = new ArrayList();
        fieldList.stream().map(x -> {
            nameList.add(x.getName());
            String originField = x.getName();
            this.projectMapping.put(originField, originField);
            return RexNodeHelper.convert(this.builder, x.getIndex(), this.allRelatedEntityClasses, finalCurrent, false, 1);
        }).filter(Objects::nonNull).forEach(x -> targetRefs.add(x));
        rightList.stream().map(x -> {
            nameList.add(x.getName());
            String originField = x.getName();
            this.projectMapping.put(originField, originField);
            return RexNodeHelper.convert(this.builder, x.getIndex() + fieldList.size(), this.allRelatedEntityClasses, finalCurrent, false, 1);
        }).filter(Objects::nonNull).forEach(x -> targetRefs.add(x));
        if (withSystem) {
            ArrayList<RexInputRef> withSystemList = new ArrayList<RexInputRef>(targetRefs);
            withSystemList.add(this.builder.field("_sys_deleted"));
            this.builder = this.builder.project(withSystemList, nameList);
        } else {
            this.builder = this.builder.project(targetRefs, nameList);
        }
    }

    private RelBuilder.AggCall aggregateConvert(AggregateCall aggCall, RelBuilder relBuilder, RelDataType older, RelDataType newer, EntityClassGroup entityClass, String alise) {
        if (null == newer.getFieldNames() || newer.getFieldNames().isEmpty()) {
            throw new RuntimeException("agg convert failed, table relDataType is invalid.");
        }
        ArrayList newArgList = new ArrayList();
        Consumer<Integer> integerConsumer = arg -> {
            RelDataTypeField relDataTypeField = (RelDataTypeField)older.getFieldList().get((int)arg);
            RexNode rexNode = RexNodeHelper.simpleNameConvert(relBuilder, entityClass, relDataTypeField.getName(), relDataTypeField.getName().toLowerCase(), 1, 1, false);
            newArgList.add(((RexInputRef)rexNode).getIndex());
        };
        aggCall.getArgList().forEach(integerConsumer);
        String name = aggCall.getName();
        if (!StringUtils.isEmpty((String)alise)) {
            name = alise;
        }
        RelBuilder.AggCall aggCall1 = relBuilder.aggregateCall(AggregateCall.create((SqlAggFunction)aggCall.getAggregation(), (boolean)aggCall.isDistinct(), (boolean)aggCall.isApproximate(), (boolean)aggCall.ignoreNulls(), newArgList, (int)aggCall.filterArg, (ImmutableBitSet)aggCall.distinctKeys, (RelCollation)aggCall.getCollation(), (RelDataType)newer, (String)name));
        return aggCall1;
    }

    static List<String> fieldNames(final RelDataType rowType) {
        return SqlValidatorUtil.uniquify((List)new AbstractList<String>(){

            @Override
            public String get(int index) {
                String name = ((RelDataTypeField)rowType.getFieldList().get(index)).getName();
                return name.startsWith("$") ? "_" + name.substring(2) : name;
            }

            @Override
            public int size() {
                return rowType.getFieldCount();
            }
        }, (SqlValidatorUtil.Suggester)SqlValidatorUtil.EXPR_SUGGESTER, (boolean)true);
    }

    private static boolean hasDynamic(RelDataType dataType) {
        return dataType.getFieldNames().contains("_sys_dynamic");
    }

    private String genTableName(EntityClassGroup group) {
        String code = group.getEntityClass().code();
        String tableName = "oqs_".concat(group.getEntityClass().ref().getAppCode().concat("_").concat(code));
        return tableName;
    }

    private static boolean isFitName(String name, String finalTargetName) {
        if (name.equalsIgnoreCase(finalTargetName)) {
            return true;
        }
        String transformed = finalTargetName.replaceAll("\\.", "_");
        return name.equalsIgnoreCase(transformed);
    }

    private RexNode transformProject(RexNode rexNode, RelNode relNode, List<EntityClassGroup> involvedEntityClass, RelBuilder relBuilder) {
        return (RexNode)rexNode.accept((RexVisitor)new ProjectVisitor(relNode, relBuilder, involvedEntityClass));
    }

    class ProjectVisitor
    extends RexVisitorImpl<RexNode> {
        private List<EntityClassGroup> entityClass;
        private RelNode currentNode;
        private RelBuilder builder;

        public ProjectVisitor(RelNode currentNode, RelBuilder builder, List<EntityClassGroup> entityClass) {
            super(true);
            this.entityClass = entityClass;
            this.builder = builder;
            this.currentNode = currentNode;
        }

        public RexNode visitInputRef(RexInputRef inputRef) {
            return RexNodeHelper.convert(this.builder, inputRef.getIndex(), CopyCustomShuttle.this.allRelatedEntityClasses, this.currentNode, true, 1);
        }

        public RexNode visitLiteral(RexLiteral literal) {
            return literal;
        }

        public RexNode visitCall(RexCall call) {
            ArrayList<RexNode> newList = new ArrayList<RexNode>();
            for (RexNode operand : call.operands) {
                RexNode accept = (RexNode)operand.accept((RexVisitor)this);
                newList.add(accept);
            }
            return call.clone(call.type, newList);
        }
    }
}

