/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.master.mysql.utils;

import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.plus.master.calcite.func.JsonUnquote;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.Tuple3;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlJsonValueFunction;
import org.apache.calcite.tools.RelBuilder;

public class RexNodeHelper {
    private static RelBuilder newBuilder;

    public static Tuple2<EntityClassGroup, RelDataTypeField> findSource(int index, List<EntityClassGroup> relatedGroup, RelNode currentNode, boolean isStart, Queue<Boolean> footprint) {
        if (currentNode instanceof TableScan || currentNode instanceof Project && !isStart || currentNode instanceof Aggregate) {
            RelDataTypeField relDataTypeField = (RelDataTypeField)currentNode.getRowType().getFieldList().get(index);
            EntityClassGroup relatedEntityClass = RexNodeHelper.findRelatedEntityClass(currentNode, relatedGroup);
            return Tuple.of((Object)relatedEntityClass, (Object)relDataTypeField);
        }
        if (currentNode instanceof BiRel) {
            RelNode left = ((Join)currentNode).getLeft();
            RelNode right = ((Join)currentNode).getRight();
            int leftSize = left.getRowType().getFieldList().size();
            if (index >= leftSize) {
                footprint.add(true);
                return RexNodeHelper.findSource(index - leftSize, relatedGroup, right, false, footprint);
            }
            footprint.add(false);
            return RexNodeHelper.findSource(index, relatedGroup, left, false, footprint);
        }
        return RexNodeHelper.findSource(index, relatedGroup, currentNode.getInput(0), false, footprint);
    }

    public static Tuple3<EntityClassGroup, RelDataTypeField, RelNode> findSourceWithNode(int index, List<EntityClassGroup> relatedGroup, RelNode currentNode, boolean isStart, Queue<Boolean> footprint) {
        if (currentNode instanceof TableScan || currentNode instanceof Project && !isStart || currentNode instanceof Aggregate) {
            RelDataTypeField relDataTypeField = (RelDataTypeField)currentNode.getRowType().getFieldList().get(index);
            EntityClassGroup relatedEntityClass = RexNodeHelper.findRelatedEntityClass(currentNode, relatedGroup);
            return Tuple.of((Object)relatedEntityClass, (Object)relDataTypeField, (Object)currentNode);
        }
        if (currentNode instanceof BiRel) {
            RelNode left = ((Join)currentNode).getLeft();
            RelNode right = ((Join)currentNode).getRight();
            int leftSize = left.getRowType().getFieldList().size();
            if (index >= leftSize) {
                footprint.add(true);
                return RexNodeHelper.findSourceWithNode(index - leftSize, relatedGroup, right, false, footprint);
            }
            footprint.add(false);
            return RexNodeHelper.findSourceWithNode(index, relatedGroup, left, false, footprint);
        }
        return RexNodeHelper.findSourceWithNode(index, relatedGroup, currentNode.getInput(0), false, footprint);
    }

    private static Tuple3<Integer, RelNode, Integer> findTarget(Queue<Boolean> footprint, RelBuilder relBuilder, int size) {
        int i = 0;
        AtomicInteger offSet = new AtomicInteger(0);
        if (size > 1) {
            Boolean isRight = footprint.poll();
            if (isRight.booleanValue()) {
                i = 1;
                offSet.addAndGet(relBuilder.peek(0).getRowType().getFieldCount());
                return Tuple.of((Object)i, (Object)RexNodeHelper.findTarget(footprint, relBuilder.peek(0), offSet), (Object)offSet.get());
            }
            return Tuple.of((Object)i, (Object)RexNodeHelper.findTarget(footprint, relBuilder.peek(1), offSet), (Object)offSet.get());
        }
        return Tuple.of((Object)i, (Object)RexNodeHelper.findTarget(footprint, relBuilder.peek(), offSet), (Object)offSet.get());
    }

    private static RelNode findTarget(Queue<Boolean> footprint, RelNode relNode, AtomicInteger offSet) {
        if (relNode instanceof BiRel) {
            RelNode left = ((BiRel)relNode).getLeft();
            RelNode right = ((BiRel)relNode).getRight();
            Boolean isRight = footprint.poll();
            if (isRight.booleanValue()) {
                offSet.addAndGet(left.getRowType().getFieldCount());
                return RexNodeHelper.findTarget(footprint, right, offSet);
            }
            return RexNodeHelper.findTarget(footprint, left, offSet);
        }
        if (relNode instanceof Project || relNode instanceof TableScan || relNode instanceof Aggregate) {
            return relNode;
        }
        RelNode input = relNode.getInput(0);
        return RexNodeHelper.findTarget(footprint, input, offSet);
    }

    public static RexNode convert(RelBuilder newBuilder, int index, List<EntityClassGroup> relatedGroup, RelNode currentNode, boolean isStart, int totalNum) {
        List fieldNames;
        int i;
        LinkedList<Boolean> footprint = new LinkedList<Boolean>();
        Tuple2<EntityClassGroup, RelDataTypeField> source = RexNodeHelper.findSource(index, relatedGroup, currentNode, isStart, footprint);
        EntityClassGroup entityClass = (EntityClassGroup)source._1;
        RelDataTypeField relDataTypeField = (RelDataTypeField)source._2;
        Tuple3<Integer, RelNode, Integer> targetNode = currentNode instanceof BiRel && newBuilder.size() > 1 ? RexNodeHelper.findTarget(footprint, newBuilder, 2) : RexNodeHelper.findTarget(footprint, newBuilder, 1);
        String originName = relDataTypeField.getName();
        String targetName = originName.toLowerCase();
        if (entityClass != null) {
            Optional fieldOp;
            if (targetName.startsWith("_") && targetName.contains(".")) {
                i = targetName.lastIndexOf(".");
                fieldOp = entityClass.field(targetName.substring(i + 1));
            } else {
                fieldOp = entityClass.field(targetName);
            }
            if (fieldOp.isPresent()) {
                IEntityField field = (IEntityField)fieldOp.get();
                if (field.isDynamic() && RexNodeHelper.hasDynamic(newBuilder.peek().getRowType()) && !RexNodeHelper.fieldIn(((RelNode)targetNode._2).getRowType(), targetName)) {
                    if (currentNode instanceof BiRel && newBuilder.size() > 1) {
                        Integer inputIndex = (Integer)targetNode._1;
                        RexNode call = newBuilder.call((SqlOperator)new SqlJsonValueFunction("JSON_EXTRACT"), new RexNode[]{newBuilder.field(totalNum, inputIndex.intValue(), "_sys_dynamic"), newBuilder.literal((Object)"$.".concat(originName.toLowerCase()))});
                        return newBuilder.call((SqlOperator)new JsonUnquote(), new RexNode[]{call});
                    }
                    RexNode call = newBuilder.call((SqlOperator)new SqlJsonValueFunction("JSON_EXTRACT"), new RexNode[]{newBuilder.field(1, 0, "_sys_dynamic"), newBuilder.literal((Object)"$.".concat(originName.toLowerCase()))});
                    return newBuilder.call((SqlOperator)new JsonUnquote(), new RexNode[]{call});
                }
                String finalTargetName = targetName;
                RelNode targetRelNode = (RelNode)targetNode._2;
                RelDataTypeField relatedTarget = targetRelNode.getRowType().getField(finalTargetName, false, false);
                if (relatedTarget == null && finalTargetName.contains(".")) {
                    String transformed = finalTargetName.replaceAll("\\.", "_");
                    relatedTarget = targetRelNode.getRowType().getField(transformed, false, false);
                }
                if (relatedTarget != null) {
                    if (currentNode instanceof BiRel && newBuilder.size() > 1) {
                        Integer ptx = (Integer)targetNode._1;
                        return newBuilder.field(totalNum, ptx.intValue(), relatedTarget.getIndex());
                    }
                    return newBuilder.field(1, 0, relatedTarget.getIndex() + (Integer)targetNode._3);
                }
                throw new RuntimeException("No Related Code:" + finalTargetName);
            }
        }
        if (currentNode instanceof BiRel) {
            Integer ptx = (Integer)targetNode._1;
            RelNode peek = newBuilder.peek();
            if (newBuilder.size() > 1) {
                fieldNames = newBuilder.peek(1 - ptx).getRowType().getFieldNames();
                int i2 = fieldNames.indexOf(originName);
                return newBuilder.field(totalNum, ptx.intValue(), i2);
            }
            if (peek instanceof BiRel) {
                fieldNames = newBuilder.peek().getInput(1 - ptx).getRowType().getFieldNames();
                if (ptx == 0) {
                    int i3 = fieldNames.indexOf(originName);
                    if (i3 > -1) {
                        return newBuilder.field(1, 0, i3);
                    }
                    return newBuilder.field(1, 0, originName);
                }
                int i4 = fieldNames.indexOf(originName);
                if (i4 > -1) {
                    return newBuilder.field(totalNum, ptx.intValue(), i4 + newBuilder.peek().getInput(0).getRowType().getFieldCount());
                }
                return newBuilder.field(totalNum, ptx.intValue(), originName);
            }
            if (peek.getInput(0) instanceof BiRel) {
                fieldNames = newBuilder.peek().getInput(0).getInput(ptx.intValue()).getRowType().getFieldNames();
                if (ptx == 0) {
                    int i5 = fieldNames.indexOf(originName);
                    return newBuilder.field(totalNum, ptx.intValue(), i5);
                }
                int i6 = fieldNames.indexOf(originName);
                return newBuilder.field(totalNum, ptx.intValue(), i6 + newBuilder.peek().getInput(0).getInput(0).getRowType().getFieldCount());
            }
        }
        fieldNames = newBuilder.peek().getRowType().getFieldNames();
        i = fieldNames.indexOf(originName);
        return newBuilder.field(totalNum, 0, i);
    }

    private static boolean fieldIn(RelDataType rowType, String targetName) {
        RelDataTypeField field = rowType.getField(targetName, false, false);
        return field != null;
    }

    public static RexNode simpleNameConvert(RelBuilder newBuilder, EntityClassGroup entityClass, String originName, String targetName, int totalNum, int inputIndex, boolean isRight) {
        Optional fieldOp = entityClass.field(targetName);
        if (fieldOp.isPresent()) {
            IEntityField field = (IEntityField)fieldOp.get();
            if (field.isDynamic() && RexNodeHelper.hasDynamic(newBuilder.peek().getRowType())) {
                RexNode call = newBuilder.call((SqlOperator)new SqlJsonValueFunction("JSON_EXTRACT"), new RexNode[]{newBuilder.field(totalNum, totalNum > 1 ? 2 - inputIndex : 0, "_sys_dynamic"), newBuilder.literal((Object)"$.".concat(targetName))});
                return newBuilder.call((SqlOperator)new JsonUnquote(), new RexNode[]{call});
            }
            String finalTargetName = targetName;
            RelNode peeked = newBuilder.peek(inputIndex - 1);
            Optional<RelDataTypeField> first = null;
            first = peeked instanceof Join ? (isRight ? ((Join)peeked).getRight().getRowType().getFieldList().stream().filter(x -> RexNodeHelper.isFitName(x.getName(), finalTargetName)).findFirst() : ((Join)peeked).getLeft().getRowType().getFieldList().stream().filter(x -> RexNodeHelper.isFitName(x.getName(), finalTargetName)).findFirst()) : newBuilder.peek(inputIndex - 1).getRowType().getFieldList().stream().filter(x -> RexNodeHelper.isFitName(x.getName(), finalTargetName)).findFirst();
            if (first.isPresent()) {
                RelDataTypeField targetField = first.get();
                int targetIndex = targetField.getIndex();
                if (!isRight) {
                    return newBuilder.field(totalNum, totalNum > 1 ? 2 - inputIndex : 0, targetIndex);
                }
                if (peeked instanceof Join) {
                    return newBuilder.field(totalNum, totalNum > 1 ? 2 - inputIndex : 0, targetIndex + ((Join)peeked).getLeft().getRowType().getFieldCount());
                }
                return newBuilder.field(totalNum, totalNum > 1 ? 2 - inputIndex : 0, targetIndex);
            }
            return newBuilder.field(totalNum, totalNum > 1 ? 2 - inputIndex : 0, targetName);
        }
        List fieldNames = newBuilder.peek().getRowType().getFieldNames();
        int i = fieldNames.indexOf(originName);
        if (i > 0) {
            return newBuilder.field(totalNum, totalNum > 1 ? 2 - inputIndex : 0, i);
        }
        return newBuilder.field(totalNum, totalNum > 1 ? 2 - inputIndex : 0, originName);
    }

    private static EntityClassGroup findRelatedEntityClass(RelNode relNode, List<EntityClassGroup> allRelatedEntityClasses) {
        Stack<RelNode> stack = new Stack<RelNode>();
        stack.push(relNode);
        while (!stack.isEmpty()) {
            RelNode input;
            RelNode next = (RelNode)stack.pop();
            if (next instanceof TableScan) {
                RelOptTable table = ((TableScan)next).getTable();
                String entityCode = (String)table.getQualifiedName().get(1);
                Optional<EntityClassGroup> first = allRelatedEntityClasses.stream().filter(x -> x.getEntityClass().code().equalsIgnoreCase(entityCode)).findFirst();
                if (!first.isPresent()) continue;
                return first.get();
            }
            if (next instanceof BiRel) {
                input = next.getInput(0);
                stack.push(input);
                continue;
            }
            if (next instanceof Values) {
                return null;
            }
            input = next.getInput(0);
            stack.push(input);
        }
        throw new RuntimeException("No Related EntityClass");
    }

    private static boolean hasDynamic(RelDataType dataType) {
        return dataType.getFieldNames().contains("_sys_dynamic");
    }

    private static boolean isFitName(String name, String finalTargetName) {
        String transformed;
        if (name.equalsIgnoreCase(finalTargetName)) {
            return true;
        }
        return finalTargetName.contains(".") && name.equalsIgnoreCase(transformed = finalTargetName.replaceAll("\\.", "_"));
    }
}

