package com.xforceplus.ultraman.oqsengine.plus.master.dto;

import io.vavr.Tuple;
import io.vavr.Tuple2;

import java.util.*;
import java.util.stream.Collectors;

/**
 * query result from a adapter
 */
public class MasterQueryResult {

    private List<Tuple2<String, Class>> fields = new ArrayList<>();

    private List<List<Object>> values = new ArrayList<>();

    private Map<String, Object> extra = new HashMap<>();

    public MasterQueryResult() {
    }

    public void newRecord(){
        ArrayList<Object> objects = new ArrayList<>(fields.size());
        fields.forEach(x -> {
            objects.add(null);
        });
        values.add(objects);
    }

    public List<String> getFieldsNames() {
        return fields.stream().map(x -> x._1).collect(Collectors.toList());
    }

    public boolean isEmpty(){
        return fields.size() > 0;
    }


    public List<Tuple2<String, Class>> getFields() {
        return fields;
    }

    public List<List<Object>> getValues() {
        return values;
    }

    public Map<String, Object> getExtra() {
        return extra;
    }

    public void append(String key, Object value) {
        Optional<Tuple2<String, Class>> first = fields.stream().filter(x -> x._1.equals(key)).findFirst();
        if(!first.isPresent()) {
            return;
        }
        this.values.get(values.size() - 1).set(fields.indexOf(first.get()), value);
    }

    public void appendField(String columnName, Class javaType) {
        this.fields.add(Tuple.of(columnName, javaType));
    }
}
