package com.xforceplus.ultraman.oqsengine.plus.master.dto;

import com.xforceplus.ultraman.metadata.entity.FieldType;

import java.util.Arrays;

/**
 * Created by justin.xu on 03/2023.
 *
 * @since 1.8
 */
public enum StorageType {

    BOOLEAN(FieldType.BOOLEAN, false),
    ENUM(FieldType.ENUM, true),
    DATETIME(FieldType.DATETIME, false),
    LONG(FieldType.LONG, false),
    STRING(FieldType.STRING, true),
    STRINGS(FieldType.STRINGS, true),
    DECIMAL(FieldType.DECIMAL, false);


    private FieldType fieldType;
    private boolean needSymbol;

    StorageType(FieldType fieldType, boolean needSymbol) {
        this.fieldType = fieldType;
        this.needSymbol = needSymbol;
    }

    public FieldType getFieldType() {
        return fieldType;
    }

    public boolean isNeedSymbol() {
        return needSymbol;
    }

    public static StorageType instance(FieldType f) {
        if (null == f) {
            return null;
        }

        return Arrays.stream(StorageType.values()).filter(st -> {
            return st.fieldType.equals(f);
        }).findFirst().orElse(null);

    }
}
