package com.xforceplus.ultraman.oqsengine.plus.master.mock;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.oqsengine.plus.common.utils.BeanInitialization;
import com.xforceplus.ultraman.oqsengine.plus.common.utils.CommonInitialization;
import com.xforceplus.ultraman.oqsengine.plus.common.utils.InitializationHelper;
import com.xforceplus.ultraman.oqsengine.plus.common.utils.SqlInitUtils;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.SQLMasterStorage;
import com.xforceplus.ultraman.oqsengine.plus.storage.executor.TransactionExecutor;
import com.xforceplus.ultraman.oqsengine.plus.storage.route.dynamic.DynamicDataSource;
import com.xforceplus.ultraman.oqsengine.plus.storage.route.dynamic.DynamicRouteMappingProvider;
import org.springframework.transaction.PlatformTransactionManager;

import javax.sql.DataSource;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;

/**
 * Created by justin.xu on 05/2023.
 *
 * @since 1.8
 */
public class MasterDBInitialization implements BeanInitialization {

    private static volatile MasterDBInitialization instance = null;

    public static final String routingKey = "tenant-1";
    public static final String routingDatasource = "master-1";

    private EntityClassEngine engine;

    private PlatformTransactionManager manager;

    private DynamicDataSource dynamicDataSource;
    private SQLMasterStorage masterStorage;
    private TransactionExecutor masterTransactionExecutor;

    private ExecutorService masterDispatcher;

    public static final String MASTER_STORAGE_TABLE = "oqsbigentity";

    private MasterDBInitialization() throws Exception {
    }

    public DynamicDataSource initDynamicDataSource(String[] activeFiles) throws IllegalAccessException {
        Map<String, String> routingMapping = new HashMap<>();
        routingMapping.put(routingKey, routingDatasource);

        return new DynamicDataSource(CommonInitialization.getInstance().getDataSourcePackage(true, activeFiles)
                , new DynamicRouteMappingProvider(routingMapping));
    }

    /**
     * 获取单例.
     */
    public static MasterDBInitialization getInstance() {
        if (null == instance) {
            synchronized (MasterDBInitialization.class) {
                try {
                    if (null == instance) {
                        instance = new MasterDBInitialization();
                        instance.init();
                        InitializationHelper.add(instance);
                    }
                } catch (Exception ex) {
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
        }
        return instance;
    }

    @Override
    public void init() throws Exception {
        dynamicDataSource = initDynamicDataSource(new String[]{});
        masterStorage = new SQLMasterStorage(manager, dynamicDataSource, new ObjectMapper(), masterDispatcher
                , engine, 30000, 100, 100);
        masterStorage.init();
    }

    @Override
    public void clear() throws Exception {
        try {
            for (Map.Entry<Object, Object> object : dynamicDataSource.allMaster().getResourceMapping().entrySet()) {
                SqlInitUtils
                        .truncate((DataSource) object.getValue());
                SqlInitUtils
                        .init("/mysql/truncate", (DataSource) object.getValue());
            }
        } catch (Exception e) {
            //  ignore
        }
    }

    @Override
    public void destroy() throws Exception {
        dynamicDataSource = null;
        masterTransactionExecutor = null;
        masterStorage.destroy();

        instance = null;
    }

    public SQLMasterStorage getMasterStorage() {
        return masterStorage;
    }

    public TransactionExecutor getMasterTransactionExecutor() {
        return masterTransactionExecutor;
    }

    public DynamicDataSource getDynamicDataSource() {
        return dynamicDataSource;
    }
}
