package com.xforceplus.ultraman.oqsengine.plus.master.mock;

import com.xforceplus.ultraman.metadata.domain.vo.dto.BoApiVo;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.engine.dsl.ResourcePath;
import com.xforceplus.ultraman.metadata.engine.impl.EntityClassGroupImpl;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.legacy.impl.ColumnField;
import com.xforceplus.ultraman.metadata.repository.MetadataRepository;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * Created by justin.xu on 05/2023.
 * only use in class engine
 * @since 1.8
 */
public class MockEntityClassEngine implements EntityClassEngine {

    private List<IEntityClass> entityClasses;

    public void initEntityClasses(List<IEntityClass> entityClasses) {
        this.entityClasses = entityClasses;
    }

    public void clear() {
        if (null != entityClasses) {
            entityClasses.clear();
        }
    }

    @Override
    public void onRefresh(Object payload) {

    }

    @Override
    public List<String> codes() {
        return entityClasses.stream().map(IEntityClass::code).collect(Collectors.toList());
    }

    @Override
    public Optional<IEntityClass> load(String boId, String profile) {
        return entityClasses.stream().filter(e -> {
            if (profile.isEmpty()) {
                return Long.parseLong(boId) == e.id();
            } else {
                return Long.parseLong(boId) == e.id() && profile.equals(e.profile());
            }
        }).findFirst();
    }

    @Override
    public Optional<IEntityClass> load(String boId, String profile, String version) {
        return load(boId, profile);
    }

    @Override
    public Optional<IEntityClass> loadByCode(String boCode, String profile) {
        return entityClasses.stream().filter(e -> {
            if (profile.isEmpty()) {
                return boCode.equals(e.code());
            } else {
                return boCode.equals(e.code()) && profile.equals(e.profile());
            }
        }).findFirst();
    }

    @Override
    public Optional<IEntityClass> loadByCode(String boCode, String profile, String version) {
        return loadByCode(boCode, profile);
    }

    @Override
    public EntityClassGroup describe(IEntityClass entityClass, String profile) {
        return new EntityClassGroupImpl(this, null, entityClass, profile);
    }

    @Override
    public List<ColumnField> columns(ResourcePath resourcePath, String profile) {
        return null;
    }

    @Override
    public MetadataRepository getRepository() {
        return null;
    }

    @Override
    public List<ColumnField> columns(IEntityClass root, ResourcePath resourcePath, String profile) {
        return null;
    }

    @Override
    public Optional<ColumnField> column(ResourcePath resourcePath, String profile) {
        return Optional.empty();
    }

    @Override
    public Optional<ColumnField> column(IEntityClass root, ResourcePath resourcePath, String profile) {
        return Optional.empty();
    }

    @Override
    public List<IEntityClass> findAllEntities(String profile) {
        return entityClasses.stream().filter(
            e -> {
                return e.profile().equals(profile);
            }
        ).collect(Collectors.toList());
    }

    @Override
    public Set<String> findCustomActionsById(long id) {
        return null;
    }

    @Override
    public List<BoApiVo> loadApiByCode(String code, String profile) {
        return null;
    }
}
