package com.xforceplus.ultraman.oqsengine.plus.master.mysql;

import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.dialect.MysqlSqlDialect;

public class MysqlSqlDialectEx extends MysqlSqlDialect {

    public static final SqlDialect DEFAULT = new MysqlSqlDialectEx(DEFAULT_CONTEXT);

    /**
     * Creates a MysqlSqlDialect.
     *
     * @param context
     */
    public MysqlSqlDialectEx(Context context) {
        super(context);
    }

    @Override
    public void quoteStringLiteral(StringBuilder buf, String charsetName,
                                   String val) {
        if (charsetName != null) {
            buf.append("_");
            buf.append(charsetName);
        }
        buf.append(literalQuoteString);
        buf.append(val.replace(literalEndQuoteString, literalEscapedQuote));
        buf.append(literalEndQuoteString);
    }
}
