package com.xforceplus.ultraman.oqsengine.plus.master.mysql.query;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.helper.ConvertHelper;
import com.xforceplus.ultraman.oqsengine.plus.common.StringUtils;
import com.xforceplus.ultraman.oqsengine.plus.master.calcite.visitor.RemoveSortWithLimitVisitor;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.MasterQueryEntity;
import com.xforceplus.ultraman.oqsengine.plus.master.dto.MasterQueryResult;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.MysqlSqlDialectEx;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.executor.AbstractMasterTaskExecutor;
import com.xforceplus.ultraman.oqsengine.plus.meta.pojo.dto.table.SystemColumn;
import com.xforceplus.ultraman.oqsengine.plus.storage.pojo.dto.select.SelectConfig;
import com.xforceplus.ultraman.sdk.core.utils.MasterStorageHelper;
import io.vavr.Tuple2;
import lombok.extern.slf4j.Slf4j;
import org.apache.calcite.DataContext;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.rel2sql.RelToSqlConverter;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.rex.*;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.dialect.MysqlSqlDialect;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Sarg;
import org.apache.calcite.util.Util;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.function.Consumer;
import java.util.stream.Collectors;

/**
 * Created by justin.xu on 03/2023.
 *
 * @since 1.8
 */
@Slf4j
public abstract class AbstractMasterQueryExecutor<T, R> extends AbstractMasterTaskExecutor<T, R> {

    private String schemaName = "oqsengine";

    private static ZoneId zoneId = ZoneId.of("Asia/Shanghai");

    private static DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private List<Map.Entry<String, Tuple2<StructKind, Class>>> targetFields;

    public AbstractMasterQueryExecutor(Connection connection, long timeoutMs) {
        super(connection, timeoutMs);
    }

    private void genProjectFromType(Pair<RexNode, String> projectPair
            , RelDataType dataType, IEntityClass entityClass
            , List<Pair<String, String>> fieldMapping) {
        RexNode inputRef = projectPair.getKey();
        if (inputRef instanceof RexInputRef) {
            String originField = dataType.getFieldList().get(((RexInputRef) inputRef).getIndex()).getName();
            String field = nameConvert(originField, entityClass);
            fieldMapping.add(new Pair<>(field, projectPair.getValue()));
        }
    }

//    private void genProjectFromAgg(Pair<RexNode, String> projectPair, RelDataType dataType
//            , List<AggregateCall> aggs, IEntityClass entityClass, Map<String, String> finalMapping) {
//        RexNode inputRef = projectPair.getKey();
//        if (inputRef instanceof RexInputRef) {
//            int index = ((RexInputRef) inputRef).getIndex();
//            AggregateCall aggregateCall = aggs.get(index - 1);
//            String originField = dataType.getFieldList().get().getName();
//            String field = nameConvert(originField, entityClass);
//            finalMapping.put(field, projectPair.getValue());
//        }
//    }

    protected MasterQueryResult executeQuery(
            SelectConfig selectConfig
            , EntityClassGroup entityClassGroup
            , FrameworkConfig config) throws SQLException {

        Connection resource = getConnection();

        List<MasterQueryEntity> queryEntities = new ArrayList<>();

        try {
            RelBuilder relBuilder = makeRelBuilder(config);
            RelNode rawTree = selectConfig.getRawTree();
            String plan = RelOptUtil.toString(rawTree);
            log.debug("old plan {}", plan);
            //transform a new tree with new scan with old one
            CopyCustomShuttle copyCustomShuttle = new CopyCustomShuttle(relBuilder, entityClassGroup, new HashMap<>());
            rawTree.accept(copyCustomShuttle);
//            rawTree.childrenAccept(new CopyRelVisitor(relBuilder))

            RelNode finalNode = relBuilder.build();
            HepProgram program = HepProgram.builder().build();
            HepPlanner planner = new HepPlanner(program);
            planner.setRoot(finalNode);
            RelNode optimizedNode = planner.findBestExp();

            String newPlan = RelOptUtil.toString(optimizedNode);
            log.debug("new plan {}", newPlan);

            SqlNode sqlNode = new RelToSqlConverter(MysqlSqlDialect.DEFAULT).visitRoot(optimizedNode).asStatement();
            String s = Util.toLinux(sqlNode.toSqlString(MysqlSqlDialectEx.DEFAULT).getSql()).replaceAll("\n", " ");
            log.debug("final sql {}", s);

            //final last
            List<Map.Entry<String, Tuple2<StructKind, Class>>> targetFields = selectConfig.getFields();

            /**
             * find final key to get the value and to convert the type from old type to new type
             * * the key
             * * the origin key
             * * the real type
             * * the taregt type
             */
            MasterQueryResult result = new MasterQueryResult();
            PreparedStatement preparedStatement = resource.prepareStatement(s);

            DataContext dataContext = selectConfig.getDataContext();
//            ParameterMetaData parameterMetaData = preparedStatement.getParameterMetaData();
//            for(int i = 0 ; i < parameterMetaData.getParameterCount() ; i ++) {
//                int parameterType = parameterMetaData.getParameterType(i);
//                preparedStatement.setObject(i, dataContext.get("?" + i), parameterType);
//            }

            List<RexDynamicParam> params = copyCustomShuttle.getParams();

            params.forEach(param -> {
                int index = param.getIndex();
                SqlTypeName sqlTypeName = param.getType().getSqlTypeName();
                try {
                    preparedStatement.setObject(index + 1, dataContext.get(param.getName()), sqlTypeName.getJdbcOrdinal());
                } catch (SQLException e) {
                    e.printStackTrace();
                }
            });

            long queryStart = System.currentTimeMillis();
            try (ResultSet rs = preparedStatement.executeQuery()) {
                System.out.println("Main Query Consume:" + (System.currentTimeMillis() - queryStart));

                /**
                 * get value from targetField
                 */
                long convertStart = System.currentTimeMillis();
                for (Map.Entry<String, Tuple2<StructKind, Class>> targetField : targetFields) {
                    String key = targetField.getKey();
                    if (key.startsWith(SqlUtil.GENERATED_EXPR_ALIAS_PREFIX)) {
                        String index = key.substring(SqlUtil.GENERATED_EXPR_ALIAS_PREFIX.length());
                        //from 0
                        key = rs.getMetaData().getColumnLabel(Integer.parseInt(index) + 1);
                    }

                    result.appendField(key, targetField.getValue()._2);
                }

                System.out.println("Convert Consume:" + (System.currentTimeMillis() - convertStart));

//                ResultSetMetaData metaData = rs.getMetaData();
//                int columnCount = metaData.getColumnCount();
//

                long convertStart2 = System.currentTimeMillis();
                while (rs.next()) {
                    result.newRecord();
                    result.getFields().forEach(x -> {
                        Object rs1 = MasterStorageHelper.getRs(rs, x._1, x._2);
                        result.append(x._1, rs1);
                    });
                }
                System.out.println("Convert2 Consume:" + (System.currentTimeMillis() - convertStart2));
            }

            //TODO mysql related
            if (hasCount(selectConfig)) {
//                try (Connection connection = calciteQueryPackage.getConnection()) {
                long start = System.currentTimeMillis();
                RelNode countNode = buildCount(relBuilder, optimizedNode);
                SqlNode countSqlNode = new RelToSqlConverter(MysqlSqlDialect.DEFAULT).visitRoot(countNode).asStatement();
                String countSql = Util.toLinux(countSqlNode.toSqlString(MysqlSqlDialectEx.DEFAULT).getSql()).replaceAll("\n", " ");
                System.out.println("Cosume To Count:" + (System.currentTimeMillis() - start));
                PreparedStatement statement = resource.prepareStatement(countSql);
                //do prepare
                params.forEach(param -> {
                    int index = param.getIndex();
                    SqlTypeName sqlTypeName = param.getType().getSqlTypeName();
                    try {
                        preparedStatement.setObject(index + 1, dataContext.get(param.getName()), sqlTypeName.getJdbcOrdinal());
                    } catch (SQLException e) {
                        e.printStackTrace();
                    }
                });
                ResultSet resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    long count = resultSet.getLong("c");
                    selectConfig.getContext().put("show_count", count);
                    result.getExtra().put("show_count", count);
                }
            }
            return result;
        } catch (Throwable throwable) {
            throwable.printStackTrace();
            throw throwable;
        } finally {
////            calciteQueryPackage.destroyInstance();
//            if (null != resource && !resource.isClosed()) {
//                resource.close();
//            }
        }
    }

    /**
     * remove page size and limit
     *
     * @param builder
     * @param optimizedNode
     * @return
     */
    private RelNode buildCount(RelBuilder builder, RelNode optimizedNode) {
        RemoveSortWithLimitVisitor removeSortWithLimitVisitor = RemoveSortWithLimitVisitor.DEFAULT_INS;
        builder.clear();
        builder.push(optimizedNode.accept(removeSortWithLimitVisitor));
        builder.push(builder.aggregate(builder.groupKey(), builder.countStar("c")).build());
        return builder.build();
    }

    /**
     * TODO
     *
     * @return
     */
    private Class convertToJavaType() {
        return String.class;
    }

    /**
     * calculate the final mapping
     *
     * @param selectConfig
     * @return
     */
//    private List<Map.Entry<String, Tuple2<StructKind, Class>>> calculate(SqlNodeList selectList, SelectConfig selectConfig, boolean hasAgg, IEntityClass entityClass) {
//        if (hasAgg) {
//            List<Map.Entry<String, Tuple2<StructKind, Class>>> fields = selectConfig.getFields();
//            List<Map.Entry<String, Tuple2<StructKind, Class>>> newFields = new ArrayList<>(fields);
//            Map<String, String> keyMapping = new HashMap<>();
//            newFields.forEach(pair -> {
//                String key = pair.getKey();
//                if (key.startsWith("EXPR")) {
//
//                    Optional<AggregateCall> first = selectConfig.getAggs().stream().filter(x -> x.getName().equals(key)).findFirst();
//                    if (first.isPresent()) {
//                        AggregateCall aggregateCall = first.get();
//                        String args = aggregateCall.getArgList().stream().map(index -> {
//                            String name = nameConvert(selectConfig.getRelDataType().getFieldList().get(index).getName(), entityClass);
//                            return name;
//                        }).collect(Collectors.joining(","));
//                        if (StringUtils.isEmpty(args)) {
//                            args = "*";
//                        }
//
//                        String name = aggregateCall.getAggregation().getName();
//                        String trueName = name.concat("(").concat(args).concat(")");
//                        keyMapping.put(key, trueName);
//                    }
//                }
//            });
//
//            keyMapping.forEach((k, v) -> {
//                newFields.replaceAll(x -> {
//                    if (x.getKey().equals(k)) {
//                        return new Pair<>(v, x.getValue());
//                    }
//                    return x;
//                });
//            });
//
//            return newFields;
//        } else {
//            return selectConfig.getFields();
//        }
//    }
    private boolean hasCount(SelectConfig selectConfig) {
        return selectConfig.getHints().stream().anyMatch(x -> x.hintName.equalsIgnoreCase("show_count"));
    }

    private RexNode[] toSorts(RelBuilder relBuilder, IEntityClass entityClass, List<Map.Entry<String, RelFieldCollation.Direction>> sorts) {
        int sortSize = sorts.size();
        RexNode[] rexNodes = new RexNode[sortSize];
        for (int i = 0; i < sortSize; i++) {
            Map.Entry<String, RelFieldCollation.Direction> sort = sorts.get(i);

            RexInputRef rexInputRef = relBuilder.field(nameConvert(sort.getKey(), entityClass));

            if (sort.getValue().isDescending()) {
                rexNodes[i] = relBuilder.desc(rexInputRef);
            } else {
                rexNodes[i] = rexInputRef;
            }
        }
        return rexNodes;
    }

    private RelBuilder makeRelBuilder(FrameworkConfig config) {
        return RelBuilder.create(config);
    }

    private RelBuilder.AggCall aggregateConvert(AggregateCall aggCall, RelBuilder relBuilder, RelDataType older, RelDataType newer, IEntityClass entityClass, String alise) {

        if (null == newer.getFieldNames() || newer.getFieldNames().isEmpty()) {
            throw new RuntimeException("agg convert failed, table relDataType is invalid.");
        }

        //  遍历获取新的位置.
        List<Integer> newArgList = new ArrayList<>();
        List<String> nameList = new ArrayList<>();
        Consumer<Integer> integerConsumer = arg -> {
            String field = older.getFieldList().get(arg).getName();
            String tableColumnName = field;

            if (!tableColumnName.equals("*")) {
                tableColumnName = nameConvert(field, entityClass);
            }
            nameList.add(tableColumnName);
            for (int i = 0; i < newer.getFieldNames().size(); i++) {
                if (tableColumnName.equals(newer.getFieldNames().get(i))) {
                    newArgList.add(i);
                    break;
                }
            }
        };
        aggCall.getArgList().forEach(integerConsumer);

        String name = aggCall.getName();
        if (!StringUtils.isEmpty(alise)) {
            name = alise;
        }

//        RelBuilder.AggCall aggCall1 = relBuilder.aggregateCall(AggregateCall.create(aggCall.getAggregation()
////                , aggCall.isDistinct(), aggCall.isApproximate(), aggCall.ignoreNulls()
////                , newArgList, aggCall.filterArg
////                , aggCall.distinctKeys, aggCall.getCollation(), newer, name));
        RelBuilder.AggCall aggCall1 = relBuilder.aggregateCall(aggCall.getAggregation(), nameList.stream().map(x -> relBuilder.field(x)).collect(Collectors.toList()));
        return aggCall1;
    }

    /**
     * table visitor.
     */
    public static class TableRexVisitor extends RexVisitorImpl<RexNode> {
        private RelBuilder builder;
        private IEntityClass entityClass;
        private RelDataType dataType;
        private RefNameValue refNameValue;


        public TableRexVisitor(RelBuilder builder, RelDataType type, IEntityClass entityClass) {
            super(true);
            this.builder = builder;
            this.entityClass = entityClass;
            this.dataType = type;
        }

        @Override
        public RexNode visitCall(RexCall call) {
            refNameValue = new RefNameValue(builder);

            switch (call.getKind()) {
                case AND:
                    builder = builder.filter(builder.and(call.getOperands().stream().map(operand -> operand.accept(this)).toArray(RexNode[]::new)));
                    return call;
                case OR:
                    builder = builder.filter(builder.or(call.getOperands().stream().map(operand -> operand.accept(this)).toArray(RexNode[]::new)));
                    return call;
                case EQUALS:
                    travel(call);
                    builder = builder.filter(builder.equals(refNameValue.toRexField(), refNameValue.toFirstRexLiteral()));
                    return call;
                case NOT_EQUALS:
                    travel(call);
                    builder = builder.filter(builder.notEquals(refNameValue.toRexField(), refNameValue.toFirstRexLiteral()));
                    return call;
                case GREATER_THAN:
                    travel(call);
                    builder = builder.filter(builder.greaterThan(refNameValue.toRexField(), refNameValue.toFirstRexLiteral()));
                    return call;
                case GREATER_THAN_OR_EQUAL:
                    travel(call);
                    builder = builder.filter(builder.greaterThanOrEqual(refNameValue.toRexField(), refNameValue.toFirstRexLiteral()));
                    return call;
                case LESS_THAN:
                    travel(call);
                    builder = builder.filter(builder.lessThan(refNameValue.toRexField(), refNameValue.toFirstRexLiteral()));
                    return call;
                case LESS_THAN_OR_EQUAL:
                    travel(call);
                    builder = builder.filter(builder.lessThanOrEqual(refNameValue.toRexField(), refNameValue.toFirstRexLiteral()));
                    return call;
                case IN: {
                    travel(call);
                    builder = builder.filter(builder.in(refNameValue.toRexField(), refNameValue.toRexLiterals()));
                    return call;
                }
                case SEARCH:
                case BETWEEN: {
                    travel(call);
                    RexNode[] rexNodes = refNameValue.toRexLiterals();

                    if (rexNodes.length != 2) {
                        throw new RuntimeException("between must have two range value");
                    }
                    builder = builder.filter(builder.between(refNameValue.toRexField(), rexNodes[0], rexNodes[1]));
                    return call;
                }
                case LIKE:
                    travel(call);
                    builder = builder.filter(builder
                            .getRexBuilder()
                            .makeCall(SqlStdOperatorTable.LIKE, refNameValue.toRexField(), refNameValue.toFirstRexLiteral()));
                    return call;
                case CAST:
                    travel(call);
                    return call;
                case PLUS:
                case MINUS:
                case TIMES:
                case DIVIDE:
                default:
                    throw new RuntimeException("Unsupported RexCall type: " + call.getKind());
            }
        }

        @Override
        public RexNode visitInputRef(RexInputRef inputRef) {
            String originField = dataType.getFieldList().get(inputRef.getIndex()).getName();
            String field = nameConvert(originField, entityClass);
            refNameValue.setField(field);
            return inputRef;
        }

        @Override
        public RexNode visitLiteral(RexLiteral literal) {
            rexLiteralParser(refNameValue, literal);
            return literal;
        }

        private void travel(RexCall call) {
            call.operands.forEach(c -> {
                c.accept(this);
            });
        }


        private Object rexLiteralParser(RefNameValue refNameValue, RexLiteral literal) {
            if (null == refNameValue.getField()) {
                throw new RuntimeException("filter field could not be null");
            }

            if (null == literal.getValue2()) {
                return literal;
            }

            RelDataTypeField realType = builder.peek().getRowType().getField(refNameValue.getField(), false, false);

//            String originValue = literal.getValue2().toString();

            SqlTypeName typeName = literal.getTypeName();
            switch (typeName) {
                case BOOLEAN:
                    // Unlike SqlLiteral, we do not allow boolean null.
                case INTEGER: // not allowed -- use Decimal
                case TINYINT:
                case SMALLINT:
                case DECIMAL:
                case DOUBLE:
                case FLOAT:
                case REAL:
                case BIGINT:
                case DATE:
                case TIME:
                case TIME_WITH_LOCAL_TIME_ZONE:
                case TIMESTAMP:
                case TIMESTAMP_WITH_LOCAL_TIME_ZONE:
                case INTERVAL_YEAR:
                case INTERVAL_YEAR_MONTH:
                case INTERVAL_MONTH:
                case INTERVAL_DAY:
                case INTERVAL_DAY_HOUR:
                case INTERVAL_DAY_MINUTE:
                case INTERVAL_DAY_SECOND:
                case INTERVAL_HOUR:
                case INTERVAL_HOUR_MINUTE:
                case INTERVAL_HOUR_SECOND:
                case INTERVAL_MINUTE:
                case INTERVAL_MINUTE_SECOND:
                case INTERVAL_SECOND:
                case VARCHAR: // not allowe
                case CHAR:
                case VARBINARY: // not allowed -- use Binary
                case BINARY:
                case SYMBOL:
                case ROW:
                case GEOMETRY:
                case ANY:
                case NULL:
                    Object singleValue = literal.getValue2();
                    String convert = ConvertHelper.convert(singleValue);
                    addTargetValue(realType, convert, singleValue);
                    break;
                case SARG:
                    Object rangeValue = literal.getValue2();
                    Sarg sarg = (Sarg) rangeValue;
                    RangeSet rangeSet = sarg.rangeSet;
                    if (sarg.isPoints()) {
                        //in
                        Set<Range> ranges = sarg.rangeSet.asRanges();
                        ranges.stream().forEach(range -> {
                            String converted = ConvertHelper.convert(range.lowerEndpoint());
                            addTargetValue(realType, converted, range.lowerEndpoint());
                        });
                    } else {
                        Optional<Range> first = sarg.rangeSet.asRanges().stream().findFirst();
                        Range range = first.get();
                        if (range.hasLowerBound()) {
                            String converted = ConvertHelper.convert(range.lowerEndpoint());
                            addTargetValue(realType, converted, range.lowerEndpoint());
                        }

                        if (range.hasUpperBound()) {
                            String converted = ConvertHelper.convert(range.upperEndpoint());
                            addTargetValue(realType, converted, range.upperEndpoint());
                        }
                    }
                    break;
                case MULTISET:
                default:
                    throw Util.unexpected(typeName);
            }

            return literal;
        }

        private void addTargetValue(RelDataTypeField realType, String originValue, Object rawObj) {
            if (null != realType) {
                switch (realType.getType().getSqlTypeName()) {
                    case BIGINT:
                        refNameValue.getLiterals().add(builder.literal(Long.parseLong(originValue)));
                        break;
                    case DECIMAL:
                        refNameValue.getLiterals().add(builder.literal(new BigDecimal(originValue)));
                        break;
                    case VARCHAR:
                        refNameValue.getLiterals().add(builder.literal(originValue));
                        break;
                    case BOOLEAN:
                        refNameValue.getLiterals().add(builder.literal(Boolean.parseBoolean(originValue)));
                        break;
                    case TIMESTAMP: {
                        if (rawObj instanceof Long) {
                            //turn long to date
                            LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli((long) rawObj), zoneId);
                            //Timestamp timeStamp = Timestamp.from(Instant.ofEpochMilli((long) rawObj));
                            //TO String
                            refNameValue.getLiterals().add(builder.literal(dateTime.format(formatter)));
                        } else if (rawObj instanceof BigDecimal) {
                            //turn long to date
                            LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(((BigDecimal) rawObj).longValue()), zoneId);
                            //Timestamp timeStamp = Timestamp.from(Instant.ofEpochMilli((long) rawObj));
                            //TO String
                            refNameValue.getLiterals().add(builder.literal(dateTime.format(formatter)));
                        } else {
                            refNameValue.getLiterals().add(builder.literal(originValue));
                        }

                        break;
                    }
                    default:
                        refNameValue.getLiterals().add(builder.literal(rawObj));
                }
            }
        }
    }

    private static String nameConvert(String originName, IEntityClass entityClass) {
        originName = originName.toLowerCase();
        Optional<IEntityField> fieldOp = entityClass.field(originName);
        if (fieldOp.isPresent()) {
            IEntityField field = fieldOp.get();

            //  表示查询了一个dynamic字段 && !field.isIndex()
            if (field.isDynamic()) {
                return SystemColumn.DYNAMIC_FIELD + ".$" + originName;
            }
        }
        return originName;
    }


    private static class RefNameValue {
        private String field;
        private List<RexLiteral> literals;
        private RelBuilder relBuilder;

        public RefNameValue(RelBuilder relBuilder) {
            this.relBuilder = relBuilder;
            this.literals = new ArrayList<>();
        }

        public String getField() {
            return field;
        }

        public void setField(String field) {
            this.field = field;
        }

        public List<RexLiteral> getLiterals() {
            return literals;
        }

        public RexNode toRexField() {
            if (null != field) {
                return relBuilder.field(field);
            }

            throw new RuntimeException("build rexField error, field is not init");
        }

        public RexNode toFirstRexLiteral() {
            if (null == literals || literals.isEmpty()) {
                throw new RuntimeException("build rexField error, literals is not init");
            }

            return literals.get(0);
        }

        public RexNode[] toRexLiterals() {
            if (null == literals || literals.isEmpty()) {
                throw new RuntimeException("build rexField error, literals is not init");
            }

            RexNode[] rexNodes = new RexNode[literals.size()];
            for (int i = 0; i < literals.size(); i++) {
                rexNodes[i] = literals.get(i);
            }
            return rexNodes;
        }
    }


}
