package com.xforceplus.ultraman.oqsengine.plus.master.mysql.query;

import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.utils.RexNodeHelper;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.*;
import org.apache.calcite.tools.RelBuilder;

import java.util.ArrayList;
import java.util.List;

/**
 * TODO add custom filter
 */
public class CopyVisitor extends RexVisitorImpl<RexNode> {

    private RelBuilder builder;
    private List<EntityClassGroup> involvedEntityClasses;
    private RelNode currentNode;

    private List<RexDynamicParam> dynamic = new ArrayList<>();

    public CopyVisitor(
            RelBuilder builder
            , List<EntityClassGroup> involvedEntityClasses
            , RelNode currentNode
    ) {

        super(true);
        this.builder = builder;
        this.involvedEntityClasses = involvedEntityClasses;

        /**
         * current node is in old type
         * if is a join will get left and right
         */
        this.currentNode = currentNode;
    }

    @Override
    public RexNode visitDynamicParam(RexDynamicParam param) {
        dynamic.add(param);
        return param;
    }

    public List<RexDynamicParam> getDynamic() {
        return dynamic;
    }

    /**
     * @param inputRef
     * @return
     */
    @Override
    public RexNode visitInputRef(RexInputRef inputRef) {
        //turn origin to current type
//        RelDataTypeField relDataTypeField = null;
//        EntityClassGroup ptr = null;
//        int input = 1;
//
//        RelNode nodePtr = currentNode;
//
//        /**
//         * case the filter - join has no project .will cause the filter fields is not right
//         * for example
//         *    join A, B , C, D
//         *    filter will see A, B, C,D
//         *    but if use builder.field("C") may fail
//         */
////        if(nodePtr instanceof Filter) {
////
////        }
//        int inputCount = 1;
//        boolean isRight = false;
//        /**
//         * TODO multi field on ??
//         * if join the case is on condition
//         * we need do two field on
//         */
//        if (nodePtr instanceof Join) {
//            inputCount = 2;
//            int leftSize = nodePtr.getInput(0).getRowType().getFieldList().size();
//            int index = inputRef.getIndex();
//            if (index >= leftSize) {
//                //find in 1
//                relDataTypeField = nodePtr.getInput(1).getRowType().getFieldList().get(index - leftSize);
//                ptr = involvedEntityClasses.get(1);
//                input = 1;
//                isRight = true;
//            } else {
//                //find in 0
//                relDataTypeField = nodePtr.getInput(0).getRowType().getFieldList().get(index);
//                ptr = involvedEntityClasses.get(0);
//                input = 2;
//            }
//        } else if (nodePtr instanceof Filter || nodePtr instanceof Project) {
//            if (((SingleRel) nodePtr).getInput() instanceof Join) {
//                //if no project join real field should do in join
//                nodePtr = ((Filter) nodePtr).getInput();
//                //find real field for filter
//                int leftSize = nodePtr.getInput(0).getRowType().getFieldList().size();
//                int index = inputRef.getIndex();
//                if (index >= leftSize) {
//                    //find in 1
//                    relDataTypeField = nodePtr.getInput(1).getRowType().getFieldList().get(index - leftSize);
//                    ptr = involvedEntityClasses.get(1);
//                    isRight = true;
//                } else {
//                    //find in 0
//                    relDataTypeField = nodePtr.getInput(0).getRowType().getFieldList().get(index);
//                    ptr = involvedEntityClasses.get(1);
//                }
//            }
//        }
//
//        /**
//         * other case
//         */
//        if (relDataTypeField == null) {
//            ptr = involvedEntityClasses.get(0);
//            relDataTypeField = nodePtr.getRowType().getFieldList().get(inputRef.getIndex());
//        }
//
//        /**
//         * first find the real target field
//         */
//        if (relDataTypeField != null) {
//            String name = relDataTypeField.getName();
//            return nameConvert(builder, name, ptr, input, inputCount, isRight);
//        }
//
//        throw new RuntimeException("No Related Column");

        return RexNodeHelper.convert(builder, inputRef.getIndex(), involvedEntityClasses, currentNode, true, currentNode instanceof BiRel ? 2 : 1);
    }

    @Override
    public RexNode visitLiteral(RexLiteral literal) {
        RexNode copy = builder.getRexBuilder().copy(literal);
        return copy;
    }

    @Override
    public RexNode visitCall(RexCall call) {
        List<RexNode> operands = visitList(call.getOperands());
        return builder.getRexBuilder().makeCall(call.getType(), call.getOperator(), operands);
    }

//    private String nameConvert(String originName, IEntityClass entityClass) {
//        originName = originName.toLowerCase();
//        Optional<IEntityField> fieldOp = entityClass.field(originName);
//        if (fieldOp.isPresent()) {
//            IEntityField field = fieldOp.get();
//
//            //  表示查询了一个dynamic字段 && !field.isIndex()
//            if (field.isDynamic()) {
//                return SystemColumn.DYNAMIC_FIELD + ".$" + originName;
//            }
//        }
//        return originName;
//    }
}
