package com.xforceplus.ultraman.oqsengine.data.boot;

import com.xforceplus.ultraman.oqsengine.data.om.audit.EnableOmAuditLogAspect;
import com.xforceplus.ultraman.oqsengine.data.om.controller.QOmBoApiController;
import com.xforceplus.ultraman.oqsengine.data.om.controller.QOmBulkApiController;
import com.xforceplus.ultraman.oqsengine.data.om.controller.QOmDataController;
import com.xforceplus.ultraman.oqsengine.data.om.controller.QOmDictApiController;
import com.xforceplus.ultraman.oqsengine.data.om.util.OmTenantUtil;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@ConditionalOnProperty(value = "xplat.oqsengine.sdk.om.enabled", matchIfMissing = true)
public class OmAutoConfiguration {

    @Bean
    public OmTenantUtil omTenantUtil() {
        return new OmTenantUtil();
    }
    
    @Bean
    public OmController omController(){
        return new OmController();
    }

    @Bean
    public QOmBoApiController apiController(){
        return new QOmBoApiController();
    }

    @Bean
    public QOmDataController dataController(){
        return new QOmDataController();
    }

    @Bean
    public QOmBulkApiController bulkApiController(){
        return new QOmBulkApiController();
    }

    @Bean
    public QOmDictApiController qOmDictApiController() {
        return new QOmDictApiController();
    }

    @Bean
    public EnableOmAuditLogAspect enableOmAuditLogAspect() {
        return new EnableOmAuditLogAspect();
    }
}
