package com.xforceplus.ultraman.oqsengine.data.boot;

import org.springframework.core.io.ClassPathResource;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;

@RequestMapping
public class OmController {

    private String template;

    private void loadTemplate() throws IOException {
        try (InputStream inputStream = new ClassPathResource("om.html").getInputStream()) {
            template = StreamUtils.copyToString(inputStream, Charset.defaultCharset());
        }
    }

    @PostConstruct
    public void init() throws IOException {
        loadTemplate();
    }

    @GetMapping("/data-om")
    public void dataOm(HttpServletRequest request, HttpServletResponse response, @PathVariable Map<String, String> params) throws IOException {
        response.setContentType("text/html; charset=UTF-8");
        response.getOutputStream().write(template.getBytes(Charset.defaultCharset()));
    }
}
