/*
 * Decompiled with CFR 0.152.
 */
package com.xforcpelus.ultraman.oqsengine.sdk.business.meta;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforcpelus.ultraman.oqsengine.sdk.business.meta.EntityClassId;
import io.vavr.Tuple2;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

public class EntityKey {
    private EntityClassId entityClassId;
    private IEntityClass entityClass;
    private Map<String, Object> businessKey = new HashMap<String, Object>();

    public static EntityKey of(IEntityClass entityClass, Tuple2<String, Object> ... keyValues) {
        return new EntityKey(entityClass, keyValues);
    }

    public static EntityKey of(EntityClassId classId, Tuple2<String, Object> ... keyValues) {
        return new EntityKey(classId, keyValues);
    }

    public EntityKey(EntityClassId entityClassId, Tuple2<String, Object> ... keyValues) {
        Objects.requireNonNull(keyValues, "business key value should not be null");
        this.entityClassId = entityClassId;
        Stream.of(keyValues).forEach(x -> this.businessKey.put((String)x._1(), x._2()));
    }

    public EntityKey(IEntityClass entityClass, Tuple2<String, Object> ... keyValues) {
        Objects.requireNonNull(keyValues, "business key value should not be null");
        this.entityClass = entityClass;
        Stream.of(keyValues).forEach(x -> this.businessKey.put((String)x._1(), x._2()));
    }

    public IEntityClass getSchema() {
        return this.entityClass;
    }

    public Map<String, Object> getBusinessKey() {
        return Collections.unmodifiableMap(this.businessKey);
    }
}

