/*
 * Decompiled with CFR 0.152.
 */
package com.xforcpelus.ultraman.oqsengine.sdk.business.meta.service.impl;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldLikeRelationType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.Relation;
import com.xforceplus.ultraman.oqsengine.pojo.reader.record.Record;
import com.xforceplus.ultraman.oqsengine.pojo.utils.PropertyHelper;
import com.xforceplus.ultraman.oqsengine.sdk.facade.EntityFacade;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpCondition;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpContext;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpFactory;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpField;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpNode;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpOperator;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpQuery;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpRange;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpRel;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpSort;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpValue;
import com.xforceplus.ultraman.oqsengine.sdk.service.core.ExecutionConfig;
import com.xforceplus.ultraman.oqsengine.sdk.vo.DataCollection;
import com.xforceplus.xplat.galaxy.framework.context.ContextService;
import com.xforcpelus.ultraman.oqsengine.sdk.business.meta.EntityId;
import com.xforcpelus.ultraman.oqsengine.sdk.business.meta.EntityInstance;
import com.xforcpelus.ultraman.oqsengine.sdk.business.meta.EntityKey;
import com.xforcpelus.ultraman.oqsengine.sdk.business.meta.GeneralEntityInstance;
import com.xforcpelus.ultraman.oqsengine.sdk.business.meta.ValueBasedEntityInstance;
import com.xforcpelus.ultraman.oqsengine.sdk.business.meta.exception.OptimizeConflictException;
import com.xforcpelus.ultraman.oqsengine.sdk.business.meta.service.BusinessFacade;
import io.vavr.control.Either;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BusinessFacadeImpl
implements BusinessFacade {
    private Logger logger = LoggerFactory.getLogger(BusinessFacade.class);
    private final ContextService contextService;
    private final EntityFacade entityFacade;
    private ExecutionConfig config;

    public BusinessFacadeImpl(EntityFacade entityFacade, ExecutionConfig config, @Autowired(required=false) ContextService contextService) {
        this.entityFacade = entityFacade;
        this.contextService = contextService;
        this.config = config;
    }

    private Map<String, Object> getContext() {
        return Optional.ofNullable(this.contextService).map(ContextService::getAll).orElseGet(Collections::emptyMap);
    }

    private <T> T get(CompletionStage<T> completionStage) {
        return completionStage.toCompletableFuture().join();
    }

    private EntityInstance toEntityInstance(Record record, IEntityClass iEntityClass) {
        Long typeId = record.getTypeId();
        if (typeId != null && typeId > 0L) {
            Collection iEntityClasses;
            Optional<IEntityClass> typeOp;
            if (typeId.equals(iEntityClass.id())) {
                return new GeneralEntityInstance(record, iEntityClass);
            }
            if (iEntityClass.extendEntityClass() != null && typeId.equals(iEntityClass.extendEntityClass().id())) {
                return new GeneralEntityInstance(record, iEntityClass);
            }
            if (iEntityClass.childEntityClasses() != null && !iEntityClass.childEntityClasses().isEmpty() && (typeOp = (iEntityClasses = iEntityClass.childEntityClasses()).stream().filter(entityClass -> typeId.equals(entityClass.id())).findFirst()).isPresent()) {
                return new GeneralEntityInstance(record, typeOp.get());
            }
        }
        return new ValueBasedEntityInstance(record);
    }

    @Override
    public EntityFacade entity() {
        return this.entityFacade;
    }

    @Override
    public IEntityClass load(String code) {
        return (IEntityClass)this.entityFacade.loadByCode(code).orElseThrow(() -> new RuntimeException("entityClass with code [" + code + "] not found"));
    }

    @Override
    public IEntityClass load(Long id) {
        return (IEntityClass)this.entityFacade.load(id.toString()).orElseThrow(() -> new RuntimeException("entityClass with id [" + id + "] not found"));
    }

    @Override
    public Long create(IEntityClass entityClass, Map<String, Object> body) {
        return (Long)((Either)this.get(this.entityFacade.create(entityClass, body, this.getContext()))).getOrElseThrow(x -> new RuntimeException((String)x));
    }

    @Override
    public Long saveByUniqueKey(EntityKey entityKey, Map<String, Object> value, boolean ignoreIfExists) {
        Optional<EntityInstance> oneByKey = this.findOneByKey(entityKey);
        if (oneByKey.isPresent()) {
            if (!ignoreIfExists) {
                this.replaceById(oneByKey.get().id(), value);
            }
            return oneByKey.get().id().getId();
        }
        return this.create(entityKey.getSchema(), value);
    }

    @Override
    public Integer updateByKey(EntityKey entityKey, Map<String, Object> body) {
        Optional<EntityInstance> oneByKey = this.findOneByKey(entityKey);
        return oneByKey.map(x -> this.updateById(x.id(), body)).orElse(0);
    }

    @Override
    public Integer replaceByKey(EntityKey entityKey, Map<String, Object> body) {
        Optional<EntityInstance> oneByKey = this.findOneByKey(entityKey);
        return oneByKey.map(x -> this.replaceById(x.id(), body)).orElse(0);
    }

    @Override
    public Integer updateById(EntityId entityId, Map<String, Object> body) {
        this.logger.info("update {} by id {}", (Object)entityId.getiEntityClass().code(), (Object)entityId.getId());
        return (Integer)((Either)this.get(this.entityFacade.updateById(entityId.getiEntityClass(), entityId.getId(), body, this.getContext()))).getOrElseThrow(x -> new RuntimeException((String)x));
    }

    @Override
    public Integer updateById(EntityId entityId, Map<String, Object> body, int version) throws OptimizeConflictException {
        return (Integer)((Either)this.get(this.entityFacade.updateById(entityId.getiEntityClass(), entityId.getId(), body, version, this.getContext()))).getOrElseThrow(x -> new RuntimeException((String)x));
    }

    @Override
    public Integer replaceById(EntityId entityId, Map<String, Object> body) {
        return (Integer)((Either)this.get(this.entityFacade.replaceById(entityId.getiEntityClass(), entityId.getId(), body, this.getContext()))).getOrElseThrow(x -> new RuntimeException((String)x));
    }

    @Override
    public Integer replaceById(EntityId entityId, Map<String, Object> body, int version) throws OptimizeConflictException {
        return (Integer)((Either)this.get(this.entityFacade.replaceById(entityId.getiEntityClass(), entityId.getId(), body, version, this.getContext()))).getOrElseThrow(x -> new RuntimeException((String)x));
    }

    @Override
    public Integer deleteOne(EntityId entityId) {
        return (Integer)((Either)this.get(this.entityFacade.deleteOne(entityId.getiEntityClass(), entityId.getId(), this.getContext()))).getOrElseThrow(x -> new RuntimeException((String)x));
    }

    @Override
    public Integer deleteByCondition(IEntityClass entityClass, ExpRel expRel) {
        AtomicInteger counter = new AtomicInteger(0);
        AtomicInteger failed = new AtomicInteger(0);
        this.findByCondition(entityClass, expRel).getRows().forEach(x -> {
            try {
                Integer retValue = this.deleteOne(x.id());
                counter.addAndGet(retValue);
            }
            catch (Exception ex) {
                this.logger.error("{}", (Throwable)ex);
                failed.getAndIncrement();
            }
        });
        return counter.get();
    }

    @Override
    public Integer deleteByKey(EntityKey entityKey) {
        return this.deleteOne(this.findOneByKey(entityKey).get().id());
    }

    @Override
    public Optional<EntityInstance> findOne(EntityId entityId) {
        return ((Either)this.get(this.entityFacade.findOneById(entityId.getiEntityClass(), entityId.getId(), this.getContext()))).map(x -> this.toEntityInstance((Record)x, entityId.getiEntityClass())).peekLeft(x -> this.logger.error("find one got error {}", x)).toJavaOptional();
    }

    @Override
    public Optional<EntityInstance> findOneByKey(EntityKey entityKey) {
        Map<String, Object> businessKey = entityKey.getBusinessKey();
        ExpQuery expQuery = ExpFactory.createFrom(businessKey);
        ExpContext expContext = new ExpContext().setSchema(this.entityFacade.getReader(entityKey.getSchema())).withContext(this.getContext());
        Either dataCollections = (Either)this.get(this.entityFacade.query(expContext, (ExpRel)expQuery, this.config.getLegacy().booleanValue()));
        Optional entityInstance = dataCollections.map(x -> {
            Integer rowNum = x.getRowNum();
            if (rowNum > 1) {
                this.logger.warn("expected one but return multi on {} with Map[{}]", (Object)entityKey.getSchema().code(), (Object)businessKey);
            }
            if (rowNum > 0) {
                Record record = (Record)x.getRows().get(0);
                return this.toEntityInstance(record, entityKey.getSchema());
            }
            return null;
        }).toJavaOptional();
        return entityInstance;
    }

    private DataCollection<EntityInstance> toEntityInstances(Either<String, DataCollection<Record>> dataCollections, IEntityClass entityClass) {
        List result = (List)dataCollections.map(x -> x.getRows().stream().map(record -> this.toEntityInstance((Record)record, entityClass)).collect(Collectors.toList())).getOrElseThrow(x -> new RuntimeException((String)x));
        return new DataCollection(((DataCollection)dataCollections.get()).getRowNum(), result);
    }

    private Long toCount(Either<String, DataCollection<Record>> dataCollections) {
        return (Long)dataCollections.map(x -> new Long(x.getRowNum().intValue())).getOrElseThrow(x -> new RuntimeException((String)x));
    }

    @Override
    public DataCollection<EntityInstance> findByCondition(IEntityClass entityClass, ExpRel expRel) {
        Either dataCollections = (Either)this.get(this.entityFacade.query(entityClass, expRel, this.getContext(), this.config.getLegacy().booleanValue()));
        return this.toEntityInstances((Either<String, DataCollection<Record>>)dataCollections, entityClass);
    }

    @Override
    public Long countAll(IEntityClass entityClass) {
        Either dataCollections = (Either)this.get(this.entityFacade.query(entityClass, ExpFactory.EMPTY, this.getContext(), this.config.getLegacy().booleanValue()));
        return this.toCount((Either<String, DataCollection<Record>>)dataCollections);
    }

    @Override
    public DataCollection<EntityInstance> findAllByRelation(EntityInstance entityInstance, String toManyRelationCode, ExpRange page, ExpSort sort) {
        IEntityClass type = entityInstance.type();
        if (type != null) {
            EntityId id = entityInstance.id();
            Optional<Relation> related = type.relations().stream().filter(x -> x.getRelationType().equalsIgnoreCase(FieldLikeRelationType.ONE2MANY.getName()) && x.getName().equalsIgnoreCase(toManyRelationCode)).findAny();
            if (related.isPresent()) {
                IEntityClass relatedEntityClass = this.entityFacade.getReader(type).getRelatedEntityClass(related.get().getName());
                ExpQuery expQuery = new ExpQuery();
                if (page != null) {
                    expQuery.setRange(page);
                }
                if (sort != null) {
                    expQuery.sort(sort);
                }
                expQuery.filters((ExpNode)ExpCondition.call((ExpOperator)ExpOperator.EQUALS, (ExpNode)ExpField.field((String)(toManyRelationCode + ".id")), (List)ExpValue.from((Object)id.getId())));
                Either dataCollections = (Either)this.get(this.entityFacade.query(relatedEntityClass, (ExpRel)expQuery, this.getContext(), this.config.getLegacy().booleanValue()));
                return this.toEntityInstances((Either<String, DataCollection<Record>>)dataCollections, relatedEntityClass);
            }
        }
        return DataCollection.empty();
    }

    @Override
    public Long countAllByRelation(EntityInstance entityInstance, String toManyRelationCode) {
        IEntityClass type = entityInstance.type();
        if (type != null) {
            EntityId id = entityInstance.id();
            Optional<Relation> related = type.relations().stream().filter(x -> x.getRelationType().equalsIgnoreCase(FieldLikeRelationType.ONE2MANY.getName()) && x.getName().equalsIgnoreCase(toManyRelationCode)).findAny();
            if (related.isPresent()) {
                IEntityClass relatedEntityClass = this.entityFacade.getReader(type).getRelatedEntityClass(related.get().getName());
                ExpQuery expQuery = new ExpQuery();
                expQuery.filters((ExpNode)ExpCondition.call((ExpOperator)ExpOperator.EQUALS, (ExpNode)ExpField.field((String)PropertyHelper.generateRelatedFieldName((String)toManyRelationCode, (String)"id")), (List)ExpValue.from((Object)id.getId())));
                Either dataCollections = (Either)this.get(this.entityFacade.query(relatedEntityClass, (ExpRel)expQuery, this.getContext(), this.config.getLegacy().booleanValue()));
                return this.toCount((Either<String, DataCollection<Record>>)dataCollections);
            }
        }
        this.logger.warn("Entity Type is missing or no such relation {}", (Object)toManyRelationCode);
        return 0L;
    }

    @Override
    public EntityInstance findOneByRelation(EntityInstance entityInstance, String toOneRelationCode) {
        Optional<Relation> related;
        IEntityClass type = entityInstance.type();
        if (type != null && (related = type.relations().stream().filter(x -> (x.getRelationType().equalsIgnoreCase(FieldLikeRelationType.MANY2ONE.getName()) || x.getRelationType().equalsIgnoreCase(FieldLikeRelationType.ONE2ONE.getName())) && x.getName().equalsIgnoreCase(toOneRelationCode)).findAny()).isPresent()) {
            IEntityClass relatedEntityClass = this.entityFacade.getReader(type).getRelatedEntityClass(related.get().getName());
            Optional<Object> value = entityInstance.getValue(toOneRelationCode + ".id");
            if (value.isPresent()) {
                Object idObj = value.get();
                Either recordE = (Either)this.get(this.entityFacade.findOneById(relatedEntityClass, Long.valueOf(Long.parseLong(idObj.toString())), this.getContext()));
                return (EntityInstance)recordE.map(e -> this.toEntityInstance((Record)e, relatedEntityClass)).getOrElseGet(x -> {
                    this.logger.error("Got error msg {}", x);
                    return null;
                });
            }
        }
        return null;
    }

    @Override
    public Long count(IEntityClass entityClass, ExpRel expRel) {
        return this.toCount((Either<String, DataCollection<Record>>)((Either)this.get(this.entityFacade.query(entityClass, expRel, this.getContext(), this.config.getLegacy().booleanValue()))));
    }
}

