/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.business.meta.service.impl;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldLikeRelationType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.Relation;
import com.xforceplus.ultraman.oqsengine.pojo.reader.record.GeneralRecord;
import com.xforceplus.ultraman.oqsengine.pojo.reader.record.Record;
import com.xforceplus.ultraman.oqsengine.pojo.utils.PropertyHelper;
import com.xforceplus.ultraman.oqsengine.sdk.business.meta.ChangeVersion;
import com.xforceplus.ultraman.oqsengine.sdk.business.meta.EntityId;
import com.xforceplus.ultraman.oqsengine.sdk.business.meta.EntityIdVersion;
import com.xforceplus.ultraman.oqsengine.sdk.business.meta.EntityInstance;
import com.xforceplus.ultraman.oqsengine.sdk.business.meta.EntityKey;
import com.xforceplus.ultraman.oqsengine.sdk.business.meta.GeneralEntityInstance;
import com.xforceplus.ultraman.oqsengine.sdk.business.meta.ValueBasedEntityInstance;
import com.xforceplus.ultraman.oqsengine.sdk.business.meta.service.BusinessFacade;
import com.xforceplus.ultraman.oqsengine.sdk.exception.OptimizeConflictException;
import com.xforceplus.ultraman.oqsengine.sdk.facade.EntityFacade;
import com.xforceplus.ultraman.oqsengine.sdk.facade.ProfileFetcher;
import com.xforceplus.ultraman.oqsengine.sdk.facade.QueryProvider;
import com.xforceplus.ultraman.oqsengine.sdk.facade.result.CreateMultiResult;
import com.xforceplus.ultraman.oqsengine.sdk.facade.result.CreateOneResult;
import com.xforceplus.ultraman.oqsengine.sdk.facade.result.DeleteMultiResult;
import com.xforceplus.ultraman.oqsengine.sdk.facade.result.DeleteOneResult;
import com.xforceplus.ultraman.oqsengine.sdk.facade.result.QueryResult;
import com.xforceplus.ultraman.oqsengine.sdk.facade.result.ResultStatus;
import com.xforceplus.ultraman.oqsengine.sdk.facade.result.UpdateMultiResult;
import com.xforceplus.ultraman.oqsengine.sdk.facade.result.UpdateOneResult;
import com.xforceplus.ultraman.oqsengine.sdk.facade.result.UpdateResult;
import com.xforceplus.ultraman.oqsengine.sdk.graphql.config.GraphQLSchemaHolder;
import com.xforceplus.ultraman.oqsengine.sdk.graphql.gen.BatchDataLoader;
import com.xforceplus.ultraman.oqsengine.sdk.lock.LockConfig;
import com.xforceplus.ultraman.oqsengine.sdk.lock.RemoteMultiLock;
import com.xforceplus.ultraman.oqsengine.sdk.lock.synchronizer.RemoteMultiLockSynchronizer;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpCondition;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpContext;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpFactory;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpField;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpNode;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpOperator;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpQuery;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpRange;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpRel;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpSort;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpValue;
import com.xforceplus.ultraman.oqsengine.sdk.service.core.ExecutionConfig;
import com.xforceplus.ultraman.oqsengine.sdk.store.engine.IEntityClassEngine;
import com.xforceplus.ultraman.oqsengine.sdk.store.engine.IEntityClassGroup;
import com.xforceplus.ultraman.oqsengine.sdk.tracing.TraceHelper;
import com.xforceplus.ultraman.oqsengine.sdk.transactional.OqsTransactionManager;
import com.xforceplus.ultraman.oqsengine.sdk.transactional.annotation.Propagation;
import com.xforceplus.ultraman.oqsengine.sdk.utils.IteratorUtils;
import com.xforceplus.ultraman.oqsengine.sdk.vo.DataCollection;
import com.xforceplus.xplat.galaxy.framework.context.ContextService;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.execution.ExecutionId;
import io.opentracing.Tracer;
import io.sentry.ISpan;
import io.sentry.Sentry;
import io.vavr.control.Either;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dataloader.BatchLoaderWithContext;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BusinessFacadeImpl
implements BusinessFacade {
    private Logger logger = LoggerFactory.getLogger(BusinessFacade.class);
    private final ContextService contextService;
    private final ProfileFetcher fetcher;
    private final EntityFacade entityFacade;
    private final IEntityClassEngine engine;
    private ExecutionConfig config;
    @Autowired(required=false)
    private OqsTransactionManager transactionManager;
    @Autowired(required=false)
    private RemoteMultiLockSynchronizer synchronizer;
    @Autowired(required=false)
    private Tracer tracer;
    @Autowired
    private GraphQLSchemaHolder schemaHolder;
    @Autowired
    private List<QueryProvider> queryProviders;

    public BusinessFacadeImpl(EntityFacade entityFacade, IEntityClassEngine engine, ProfileFetcher fetcher, ExecutionConfig config, @Autowired(required=false) ContextService contextService) {
        this.entityFacade = entityFacade;
        this.contextService = contextService;
        this.config = config;
        this.engine = engine;
        this.fetcher = fetcher;
    }

    public GraphQLSchemaHolder getSchemaHolder() {
        return this.schemaHolder;
    }

    public void setSchemaHolder(GraphQLSchemaHolder schemaHolder) {
        this.schemaHolder = schemaHolder;
    }

    public List<QueryProvider> getQueryProviders() {
        return this.queryProviders;
    }

    public void setQueryProviders(List<QueryProvider> queryProviders) {
        this.queryProviders = queryProviders;
    }

    public RemoteMultiLockSynchronizer getSynchronizer() {
        return this.synchronizer;
    }

    public void setSynchronizer(RemoteMultiLockSynchronizer synchronizer) {
        this.synchronizer = synchronizer;
    }

    public BusinessFacadeImpl(EntityFacade entityFacade, IEntityClassEngine engine, ProfileFetcher fetcher, ExecutionConfig config, @Autowired(required=false) ContextService contextService, RemoteMultiLockSynchronizer synchronizer, OqsTransactionManager transactionManager) {
        this.entityFacade = entityFacade;
        this.contextService = contextService;
        this.config = config;
        this.engine = engine;
        this.fetcher = fetcher;
        this.synchronizer = synchronizer;
        this.transactionManager = transactionManager;
    }

    private Map<String, Object> getContext() {
        return Optional.ofNullable(this.contextService).map(ContextService::getAll).orElseGet(Collections::emptyMap);
    }

    private <T> T get(CompletionStage<T> completionStage) {
        try {
            return completionStage.toCompletableFuture().join();
        }
        catch (RuntimeException ex) {
            if (ex.getCause() != null) {
                throw (RuntimeException)ex.getCause();
            }
            throw ex;
        }
    }

    private EntityInstance toEntityInstance(Record record, IEntityClassGroup group) {
        Long typeId = record.getTypeId();
        if (typeId != null && typeId > 0L) {
            if (typeId.equals(group.getEntityClass().id())) {
                return new GeneralEntityInstance(record, group.getEntityClass(), this);
            }
            if (!group.getFatherEntityClass().isEmpty() && group.getFatherEntityClass().stream().anyMatch(parent -> typeId.equals(parent.id()))) {
                Optional<IEntityClass> firstParent = group.getFatherEntityClass().stream().filter(parent -> typeId.equals(parent.id())).findFirst();
                return new GeneralEntityInstance(record, firstParent.get(), this);
            }
            if (!group.getChildrenEntityClass().isEmpty() && group.getChildrenEntityClass().stream().anyMatch(child -> typeId.equals(child.id()))) {
                Optional<IEntityClass> firstChild = group.getChildrenEntityClass().stream().filter(child -> typeId.equals(child.id())).findFirst();
                return new GeneralEntityInstance(record, firstChild.get(), this);
            }
        }
        return new ValueBasedEntityInstance(record);
    }

    @Override
    public Optional<EntityInstance> toEntityInstance(String code, long id, Map<String, Object> data) {
        IEntityClass targetEntityClass = this.load(code);
        if (targetEntityClass != null) {
            GeneralRecord generalRecord = new GeneralRecord((Collection)targetEntityClass.fields(), Integer.valueOf(0));
            generalRecord.fromMap(data);
            generalRecord.setId(Long.valueOf(id));
            return Optional.of(new GeneralEntityInstance((Record)generalRecord, targetEntityClass, this));
        }
        return Optional.empty();
    }

    @Override
    public boolean isAssignableFrom(IEntityClass entityClassA, IEntityClass entityClassB) {
        IEntityClass ptr = entityClassB;
        if (entityClassB.id() == entityClassA.id()) {
            return true;
        }
        if (entityClassB.extendEntityClass() != null) {
            if (entityClassB.extendEntityClass().id() == entityClassA.id()) {
                return true;
            }
            IEntityClassGroup group = this.engine.describe(entityClassB, this.fetcher.getProfile(Collections.emptyMap()));
            return group.getFatherEntityClass().stream().anyMatch(x -> x.id() == entityClassA.id());
        }
        return false;
    }

    @Override
    public EntityFacade entity() {
        return this.entityFacade;
    }

    @Override
    public IEntityClass load(String code) {
        return (IEntityClass)this.entityFacade.loadByCode(code, this.fetcher.getProfile(Collections.emptyMap())).orElseThrow(() -> new RuntimeException("entityClass with code [" + code + "] not found"));
    }

    @Override
    public IEntityClass load(Long id) {
        return (IEntityClass)this.entityFacade.load(id.toString(), this.fetcher.getProfile(Collections.emptyMap())).orElseThrow(() -> new RuntimeException("entityClass with id [" + id + "] not found"));
    }

    @Override
    public Long create(IEntityClass entityClass, Map<String, Object> body) {
        return this.create(entityClass, body, x -> {
            if (x.getOriginCause() == ResultStatus.OriginStatus.HALF_SUCCESS) {
                return x.getId();
            }
            throw new RuntimeException(x.getMessage());
        });
    }

    @Override
    public Long create(IEntityClass entityClass, Map<String, Object> body, Function<CreateOneResult, Long> handler) {
        return (Long)((Either)this.get(this.entityFacade.create(entityClass, body, this.getContext()))).getOrElseGet(x -> (Long)handler.apply((CreateOneResult)x));
    }

    @Override
    public Integer createMulti(IEntityClass entityClass, List<Map<String, Object>> body) {
        return this.createMulti(entityClass, body, x -> {
            if (x.getOriginCause() == ResultStatus.OriginStatus.HALF_SUCCESS) {
                return x.getInsertedRows();
            }
            throw new RuntimeException(x.getMessage());
        });
    }

    @Override
    public Integer createMulti(IEntityClass entityClass, List<Map<String, Object>> body, Function<CreateMultiResult, Integer> handler) {
        return (Integer)((Either)this.get(this.entityFacade.createMulti(entityClass, body, this.getContext()))).getOrElseGet(x -> (Integer)handler.apply((CreateMultiResult)x));
    }

    @Override
    public Long saveByUniqueKey(EntityKey entityKey, Map<String, Object> value, boolean ignoreIfExists) {
        Optional<EntityInstance> oneByKey = this.findOneByKey(entityKey);
        if (oneByKey.isPresent()) {
            if (!ignoreIfExists) {
                this.replaceById(oneByKey.get().id(), value);
            }
            return oneByKey.get().id().getId();
        }
        return this.create(entityKey.getSchema(), value);
    }

    @Override
    public Integer updateByKey(EntityKey entityKey, Map<String, Object> body) {
        Optional<EntityInstance> oneByKey = this.findOneByKey(entityKey);
        return oneByKey.map(x -> this.updateById(x.id(), body)).orElse(0);
    }

    @Override
    public Integer replaceByKey(EntityKey entityKey, Map<String, Object> body) {
        Optional<EntityInstance> oneByKey = this.findOneByKey(entityKey);
        return oneByKey.map(x -> this.replaceById(x.id(), body)).orElse(0);
    }

    @Override
    public Integer updateById(EntityId entityId, Map<String, Object> body) {
        this.logger.info("update {} by id {}", (Object)entityId.getiEntityClass().code(), (Object)entityId.getId());
        return this.updateById(entityId, body, x -> {
            if (x.getOriginCause() == ResultStatus.OriginStatus.HALF_SUCCESS) {
                return 1;
            }
            if (x.getOriginCause() == ResultStatus.OriginStatus.NOT_FOUND) {
                return 0;
            }
            if (x.getOriginCause() == ResultStatus.OriginStatus.CONFLICT) {
                throw new OptimizeConflictException();
            }
            throw new RuntimeException(x.getMessage());
        });
    }

    @Override
    public Integer updateMulti(IEntityClass entityClass, List<Map<String, Object>> body) {
        return this.updateMulti(entityClass, body, x -> {
            if (x.getOriginCause() == ResultStatus.OriginStatus.HALF_SUCCESS) {
                return x.getUpdatedRows();
            }
            throw new RuntimeException(x.getMessage());
        });
    }

    @Override
    public Integer updateMulti(IEntityClass entityClass, List<Map<String, Object>> body, Function<UpdateMultiResult, Integer> handler) {
        return (Integer)((Either)this.get(this.entityFacade.updateMulti(entityClass, body, this.getContext()))).getOrElseGet(x -> (Integer)handler.apply((UpdateMultiResult)x));
    }

    @Override
    public Integer updateByCondition(IEntityClass entityClass, Map<String, Object> body, ExpRel expRel) {
        return this.updateByCondition(entityClass, body, expRel, x -> {
            if (x.getOriginCause() == ResultStatus.OriginStatus.HALF_SUCCESS) {
                return 0;
            }
            throw new RuntimeException(x.getMessage());
        });
    }

    @Override
    public Integer updateByCondition(IEntityClass entityClass, Map<String, Object> body, ExpRel expRel, Function<UpdateResult, Integer> handler) {
        return (Integer)((Either)this.get(this.entityFacade.updateByCondition(entityClass, expRel, body, this.getContext()))).getOrElseGet(x -> (Integer)handler.apply((UpdateResult)x));
    }

    @Override
    public Integer replaceByCondition(IEntityClass entityClass, Map<String, Object> body, ExpRel expRel) {
        return this.replaceByCondition(entityClass, body, expRel, x -> {
            if (x.getOriginCause() == ResultStatus.OriginStatus.HALF_SUCCESS) {
                return 0;
            }
            throw new RuntimeException(x.getMessage());
        });
    }

    @Override
    public Integer replaceByCondition(IEntityClass entityClass, Map<String, Object> body, ExpRel expRel, Function<UpdateResult, Integer> handler) {
        return (Integer)((Either)this.get(this.entityFacade.updateByCondition(entityClass, expRel, body, this.getContext()))).getOrElseGet(x -> (Integer)handler.apply((UpdateResult)x));
    }

    @Override
    public Integer replaceMulti(IEntityClass entityClass, List<Map<String, Object>> body) {
        return this.replaceMulti(entityClass, body, x -> {
            if (x.getOriginCause() == ResultStatus.OriginStatus.HALF_SUCCESS) {
                return x.getUpdatedRows();
            }
            throw new RuntimeException(x.getMessage());
        });
    }

    @Override
    public Integer replaceMulti(IEntityClass entityClass, List<Map<String, Object>> body, Function<UpdateMultiResult, Integer> handler) {
        return (Integer)((Either)this.get(this.entityFacade.replaceMulti(entityClass, body, this.getContext()))).getOrElseGet(x -> (Integer)handler.apply((UpdateMultiResult)x));
    }

    @Override
    public Integer updateById(EntityId entityId, Map<String, Object> body, Function<UpdateOneResult, Integer> handler) {
        this.logger.info("update {} by id {}", (Object)entityId.getiEntityClass().code(), (Object)entityId.getId());
        return (Integer)((Either)this.get(this.entityFacade.updateById(entityId.getiEntityClass(), Long.valueOf(entityId.getId()), body, this.getContext()))).getOrElseGet(x -> (Integer)handler.apply((UpdateOneResult)x));
    }

    @Override
    public Integer replaceById(EntityId entityId, Map<String, Object> body) {
        return this.replaceById(entityId, body, x -> {
            if (x.getOriginCause() == ResultStatus.OriginStatus.HALF_SUCCESS) {
                return 1;
            }
            if (x.getOriginCause() == ResultStatus.OriginStatus.NOT_FOUND) {
                return 0;
            }
            if (x.getOriginCause() == ResultStatus.OriginStatus.CONFLICT) {
                throw new OptimizeConflictException();
            }
            throw new RuntimeException(x.getMessage());
        });
    }

    @Override
    public Integer replaceById(EntityId entityId, Map<String, Object> body, Function<UpdateOneResult, Integer> handler) {
        return (Integer)((Either)this.get(this.entityFacade.replaceById(entityId.getiEntityClass(), Long.valueOf(entityId.getId()), body, this.getContext()))).getOrElseGet(x -> (Integer)handler.apply((UpdateOneResult)x));
    }

    @Override
    public Integer deleteOne(EntityId entityId) {
        return this.deleteOne(entityId, x -> {
            if (x.getOriginCause() == ResultStatus.OriginStatus.CONFLICT) {
                throw new OptimizeConflictException();
            }
            if (x.getOriginCause() == ResultStatus.OriginStatus.NOT_FOUND) {
                return 0;
            }
            throw new RuntimeException(x.getMessage());
        });
    }

    @Override
    public Integer deleteOne(EntityId entityId, Function<DeleteOneResult, Integer> handler) {
        return (Integer)((Either)this.get(this.entityFacade.deleteOne(entityId.getiEntityClass(), Long.valueOf(entityId.getId()), this.getContext()))).getOrElseGet(x -> (Integer)handler.apply((DeleteOneResult)x));
    }

    @Override
    public Integer deleteMulti(List<EntityId> entityId) {
        return this.deleteMulti(entityId, x -> x.getAffectedRows());
    }

    @Override
    public Integer deleteMulti(List<EntityId> entityId, Function<DeleteMultiResult, Integer> handler) {
        if (entityId.isEmpty()) {
            return 0;
        }
        EntityId sample = entityId.get(0);
        List ids = entityId.stream().map(x -> x.getId()).collect(Collectors.toList());
        return (Integer)((Either)this.get(this.entityFacade.deleteMulti(sample.getiEntityClass(), ids, this.getContext()))).getOrElseGet(x -> (Integer)handler.apply((DeleteMultiResult)x));
    }

    @Override
    public Integer deleteByCondition(IEntityClass entityClass, ExpRel expRel) {
        AtomicInteger counter = new AtomicInteger(0);
        AtomicInteger failed = new AtomicInteger(0);
        this.findByCondition(entityClass, expRel).getRows().forEach(x -> {
            try {
                Integer retValue = this.deleteOne(x.id());
                counter.addAndGet(retValue);
            }
            catch (Exception ex) {
                this.logger.error("{}", (Throwable)ex);
                failed.getAndIncrement();
            }
        });
        return counter.get();
    }

    @Override
    public Integer deleteByConditionByBatch(IEntityClass entityClass, ExpRel expRel) {
        List<EntityId> entityIds = this.findByCondition(entityClass, expRel).getRows().stream().map(x -> x.id()).collect(Collectors.toList());
        return this.deleteMulti(entityIds);
    }

    @Override
    public Integer deleteByKey(EntityKey entityKey) {
        return this.deleteOne(this.findOneByKey(entityKey).get().id());
    }

    @Override
    public Optional<EntityInstance> findOne(EntityId entityId) {
        IEntityClassGroup group = this.engine.describe(entityId.getiEntityClass(), this.fetcher.getProfile(this.getContext()));
        return ((Either)this.get(this.entityFacade.findOneById(entityId.getiEntityClass(), Long.valueOf(entityId.getId()), this.getContext()))).map(x -> this.toEntityInstance((Record)x, group)).peekLeft(x -> this.logger.error("find one got error {}", x)).toJavaOptional();
    }

    @Override
    public Optional<EntityInstance> findOneByKey(EntityKey entityKey) {
        Map<String, Object> businessKey = entityKey.getBusinessKey();
        ExpQuery expQuery = ExpFactory.createFrom(businessKey);
        ExpContext expContext = new ExpContext().setSchema(this.entityFacade.getReader(entityKey.getSchema(), this.contextService.getAll())).withContext(this.getContext());
        Either dataCollections = (Either)this.get(this.entityFacade.query(expContext, ExpFactory.withRange((ExpRel)expQuery, (ExpRange)new ExpRange(Integer.valueOf(1), Integer.valueOf(10)))));
        IEntityClassGroup group = this.engine.describe(entityKey.getSchema(), this.fetcher.getProfile(this.getContext()));
        Optional entityInstance = dataCollections.map(x -> {
            Integer rowNum = x.getRowNum();
            if (rowNum > 1) {
                this.logger.warn("expected one but return multi on {} with Map[{}]", (Object)entityKey.getSchema().code(), (Object)businessKey);
            }
            if (rowNum > 0) {
                Record record = (Record)x.getRows().get(0);
                return this.toEntityInstance(record, group);
            }
            return null;
        }).toJavaOptional();
        return entityInstance;
    }

    private DataCollection<EntityInstance> toEntityInstances(Either<QueryResult, DataCollection<Record>> dataCollections, IEntityClass entityClass) {
        IEntityClassGroup group = this.engine.describe(entityClass, this.fetcher.getProfile(this.getContext()));
        List result = (List)dataCollections.map(x -> x.getRows().stream().map(record -> this.toEntityInstance((Record)record, group)).collect(Collectors.toList())).getOrElseThrow(x -> new RuntimeException(x.getMessage()));
        return new DataCollection(((DataCollection)dataCollections.get()).getRowNum(), result);
    }

    private Long toCount(Either<QueryResult, DataCollection<Record>> dataCollections) {
        return (Long)dataCollections.map(x -> new Long(x.getRowNum().intValue())).getOrElseThrow(x -> new RuntimeException(x.getMessage()));
    }

    @Override
    public DataCollection<EntityInstance> findByCondition(IEntityClass entityClass, ExpRel expRel, boolean simplify) {
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        contextMap.putAll(this.getContext());
        contextMap.put("simplify", simplify);
        Either dataCollections = (Either)this.get(this.entityFacade.query(entityClass, expRel, contextMap));
        return this.toEntityInstances((Either<QueryResult, DataCollection<Record>>)dataCollections, entityClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataCollection<EntityInstance> findByCondition(IEntityClass entityClass, ExpRel expRel) {
        Either dataCollections;
        ISpan span = Sentry.getSpan();
        if (span == null) {
            span = Sentry.startTransaction((String)"query", (String)"selectByConditions");
        }
        try {
            dataCollections = (Either)this.get(this.entityFacade.query(entityClass, expRel, this.getContext()));
        }
        finally {
            span.finish();
        }
        return this.toEntityInstances((Either<QueryResult, DataCollection<Record>>)dataCollections, entityClass);
    }

    @Override
    public Long countAll(IEntityClass entityClass) {
        Either dataCollections = (Either)this.get(this.entityFacade.query(entityClass, ExpFactory.EMPTY, this.getContext()));
        return this.toCount((Either<QueryResult, DataCollection<Record>>)dataCollections);
    }

    @Override
    public Iterator<EntityInstance> findAllByRelation(EntityInstance entityInstance, String toManyRelationCode, ExpRel filter) {
        IEntityClass type = entityInstance.type();
        if (type != null) {
            EntityId id = entityInstance.id();
            Optional<Relation> related = type.relations().stream().filter(x -> x.getRelationType().equalsIgnoreCase(FieldLikeRelationType.ONE2MANY.getName()) && x.getName().equalsIgnoreCase(toManyRelationCode)).findAny();
            if (related.isPresent()) {
                Optional relatedEntityClassOp = this.entityFacade.getReader(type, this.contextService.getAll()).relatedEntityClass(related.get().getName());
                if (!relatedEntityClassOp.isPresent()) {
                    return Collections.emptyIterator();
                }
                IEntityClass relatedEntityClass = (IEntityClass)relatedEntityClassOp.get();
                IEntityClassGroup group = this.engine.describe(relatedEntityClass, this.fetcher.getProfile(this.getContext()));
                ExpQuery newQuery = new ExpQuery();
                ExpField expId = ExpField.field((String)"id");
                newQuery.project(filter.getProjects()).filters(filter.getFilters()).filters((ExpNode)ExpCondition.call((ExpOperator)ExpOperator.EQUALS, (ExpNode)ExpField.field((String)(toManyRelationCode + ".id")), (List)ExpValue.from((Object)id.getId()))).filters((ExpNode)ExpCondition.call((String)"$id", (ExpOperator)ExpOperator.GREATER_THAN, (ExpNode)expId, (List)ExpValue.from((Object)0))).sort(ExpSort.init().withSort("id", "asc")).range(Integer.valueOf(1), Integer.valueOf(1000));
                return this.entityFacade.queryIterate(relatedEntityClass, (ExpRel)newQuery, (query, record) -> {
                    if (record != null) {
                        ((ExpQuery)query).mutateCondition(cond -> {
                            if ("$id".equals(cond.getMark())) {
                                List expNodes = cond.getExpNodes();
                                expNodes.clear();
                                expNodes.add(expId);
                                expNodes.add(ExpValue.fromSingle((Object)record.getId()));
                            }
                        });
                    }
                    return query;
                }, x -> this.toEntityInstance((Record)x, group), this.getContext()).iterator();
            }
        }
        return Collections.emptyIterator();
    }

    @Override
    public Stream<EntityInstance> findAllByRelationStream(EntityInstance entityInstance, String toManyRelationCode, ExpRel filter) {
        return IteratorUtils.toStream(this.findAllByRelation(entityInstance, toManyRelationCode, filter));
    }

    @Override
    public Iterator<EntityInstance> findAll(IEntityClass entityClass, ExpRel filter) {
        ExpQuery newQuery = new ExpQuery();
        ExpField expId = ExpField.field((String)"id");
        newQuery.project(filter.getProjects()).filters(filter.getFilters()).filters((ExpNode)ExpCondition.call((String)"$id", (ExpOperator)ExpOperator.GREATER_THAN, (ExpNode)expId, (List)ExpValue.from((Object)0))).sort(ExpSort.init().withSort("id", "asc")).range(Integer.valueOf(1), Integer.valueOf(5000));
        IEntityClassGroup group = this.engine.describe(entityClass, this.fetcher.getProfile(this.getContext()));
        return this.entityFacade.queryIterate(entityClass, (ExpRel)newQuery, (query, record) -> {
            if (record != null) {
                ((ExpQuery)query).mutateCondition(cond -> {
                    if ("$id".equals(cond.getMark())) {
                        List expNodes = cond.getExpNodes();
                        expNodes.clear();
                        expNodes.add(expId);
                        expNodes.add(ExpValue.fromSingle((Object)record.getId()));
                    }
                });
            }
            return query;
        }, x -> this.toEntityInstance((Record)x, group), this.getContext()).iterator();
    }

    @Override
    public Stream<EntityInstance> findAllStream(IEntityClass entityClass, ExpRel filter) {
        return IteratorUtils.toStream(this.findAll(entityClass, filter));
    }

    @Override
    @Deprecated
    public DataCollection<EntityInstance> findAllByRelation(EntityInstance entityInstance, String toManyRelationCode, ExpRange page, ExpSort sort) {
        IEntityClass type = entityInstance.type();
        if (type != null) {
            EntityId id = entityInstance.id();
            Optional<Relation> related = type.relations().stream().filter(x -> x.getRelationType().equalsIgnoreCase(FieldLikeRelationType.ONE2MANY.getName()) && x.getName().equalsIgnoreCase(toManyRelationCode)).findAny();
            if (related.isPresent()) {
                Optional relatedEntityClassOp = this.entityFacade.getReader(type, this.contextService.getAll()).relatedEntityClass(related.get().getName());
                if (!relatedEntityClassOp.isPresent()) {
                    throw new RuntimeException("Cannot find related entityClass");
                }
                IEntityClass relatedEntityClass = (IEntityClass)relatedEntityClassOp.get();
                ExpQuery expQuery = new ExpQuery();
                if (page != null) {
                    expQuery.setRange(page);
                }
                if (sort != null) {
                    expQuery.sort(sort);
                }
                expQuery.filters((ExpNode)ExpCondition.call((ExpOperator)ExpOperator.EQUALS, (ExpNode)ExpField.field((String)(toManyRelationCode + ".id")), (List)ExpValue.from((Object)id.getId())));
                Either dataCollections = (Either)this.get(this.entityFacade.query(relatedEntityClass, ExpFactory.withRange((ExpRel)expQuery, (ExpRange)new ExpRange(Integer.valueOf(1), Integer.valueOf(1000))), this.getContext()));
                return this.toEntityInstances((Either<QueryResult, DataCollection<Record>>)dataCollections, relatedEntityClass);
            }
        }
        return DataCollection.empty();
    }

    @Override
    public Long countAllByRelation(EntityInstance entityInstance, String toManyRelationCode) {
        IEntityClass type = entityInstance.type();
        if (type != null) {
            EntityId id = entityInstance.id();
            Optional<Relation> related = type.relations().stream().filter(x -> x.getRelationType().equalsIgnoreCase(FieldLikeRelationType.ONE2MANY.getName()) && x.getName().equalsIgnoreCase(toManyRelationCode)).findAny();
            if (related.isPresent()) {
                Optional relatedEntityClassOp = this.entityFacade.getReader(type, this.contextService.getAll()).relatedEntityClass(related.get().getName());
                if (!relatedEntityClassOp.isPresent()) {
                    throw new RuntimeException("Cannot find related entityClass");
                }
                IEntityClass relatedEntityClass = (IEntityClass)relatedEntityClassOp.get();
                ExpQuery expQuery = new ExpQuery();
                expQuery.filters((ExpNode)ExpCondition.call((ExpOperator)ExpOperator.EQUALS, (ExpNode)ExpField.field((String)PropertyHelper.generateRelatedFieldName((String)toManyRelationCode, (String)"id")), (List)ExpValue.from((Object)id.getId())));
                Either dataCollections = (Either)this.get(this.entityFacade.query(relatedEntityClass, (ExpRel)expQuery, this.getContext()));
                return this.toCount((Either<QueryResult, DataCollection<Record>>)dataCollections);
            }
        }
        this.logger.warn("Entity Type is missing or no such relation {}", (Object)toManyRelationCode);
        return 0L;
    }

    @Override
    public EntityInstance findOneByRelation(EntityInstance entityInstance, String toOneRelationCode) {
        Optional<Relation> related;
        IEntityClass type = entityInstance.type();
        if (type != null && (related = type.relations().stream().filter(x -> (x.getRelationType().equalsIgnoreCase(FieldLikeRelationType.MANY2ONE.getName()) || x.getRelationType().equalsIgnoreCase(FieldLikeRelationType.ONE2ONE.getName())) && x.getName().equalsIgnoreCase(toOneRelationCode)).findAny()).isPresent()) {
            Optional relatedEntityClassOp = this.entityFacade.getReader(type, this.contextService.getAll()).relatedEntityClass(related.get().getName());
            if (!relatedEntityClassOp.isPresent()) {
                throw new RuntimeException("Cannot find related entityClass");
            }
            IEntityClass relatedEntityClass = (IEntityClass)relatedEntityClassOp.get();
            Optional<Object> value = entityInstance.getValue(toOneRelationCode + ".id");
            IEntityClassGroup relatedGroup = this.engine.describe(relatedEntityClass, this.fetcher.getProfile(this.getContext()));
            if (value.isPresent()) {
                Object idObj = value.get();
                Either recordE = (Either)this.get(this.entityFacade.findOneById(relatedEntityClass, Long.valueOf(Long.parseLong(idObj.toString())), this.getContext()));
                return (EntityInstance)recordE.map(e -> this.toEntityInstance((Record)e, relatedGroup)).getOrElseGet(x -> {
                    this.logger.error("Got error msg {}", x);
                    return null;
                });
            }
        }
        return null;
    }

    @Override
    public Long count(IEntityClass entityClass, ExpRel expRel) {
        return this.toCount((Either<QueryResult, DataCollection<Record>>)((Either)this.get(this.entityFacade.query(entityClass, expRel, this.getContext()))));
    }

    @Override
    public Optional<EntityInstance> replay(EntityIdVersion entityIdVersion, boolean onlySelf) {
        long objId = entityIdVersion.getEntityId().getId();
        long version = entityIdVersion.getVersion();
        IEntityClass entityClass = entityIdVersion.getEntityId().getiEntityClass();
        IEntityClassGroup group = this.engine.describe(entityClass, this.fetcher.getProfile(this.getContext()));
        CompletionStage replay = this.entityFacade.replay(objId, group, version, onlySelf);
        return ((Either)this.get(replay)).map(x -> this.toEntityInstance((Record)x, group)).peekLeft(x -> this.logger.error("replay got error {}", x)).toJavaOptional();
    }

    @Override
    public List<ChangeVersion> changelogList(EntityId entityId, boolean onlySelf, int pageNo, int pageSize) {
        long objId = entityId.getId();
        long entityclassId = entityId.getiEntityClass().id();
        CompletionStage changelogList = this.entityFacade.getChangelogList(objId, entityclassId, onlySelf, pageNo, pageSize);
        return (List)((Either)this.get(changelogList)).map(x -> x.stream().map(cp -> {
            ChangeVersion changeVersion = new ChangeVersion();
            changeVersion.setComment(cp.getComment());
            changeVersion.setId(cp.getId());
            changeVersion.setSource(cp.getSource());
            changeVersion.setTimestamp(cp.getTimestamp());
            changeVersion.setUsername(cp.getUsername());
            changeVersion.setVersion(cp.getVersion());
            return changeVersion;
        }).collect(Collectors.toList())).getOrElseGet(x -> Collections.emptyList());
    }

    @Override
    public Map<Long, Long> changelogCount(long entityClassId, List<Long> ids) {
        CompletionStage changelogCount = this.entityFacade.getChangelogCount(entityClassId, ids);
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        ((Either)this.get(changelogCount)).forEach(x -> x.getCountList().forEach(single -> map.put(single.getObjId(), single.getCount())));
        return map;
    }

    @Override
    public void tryLock(List<Long> ids, Consumer<List<Long>> consumer) {
        this.tryLock(ids, consumer, LockConfig.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tryLock(final List<Long> ids, final Consumer<List<Long>> consumer, final LockConfig config) {
        if (config.getOpenTrans().booleanValue()) {
            try {
                this.transactionManager.transactionExecution(Propagation.REQUIRES_NEW, -1, "lock multi", new Class[0], new Class[]{Exception.class}, (Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        RemoteMultiLock lock = new RemoteMultiLock(ids, BusinessFacadeImpl.this.synchronizer, config);
                        try {
                            lock.lock();
                            consumer.accept(ids);
                        }
                        finally {
                            lock.unlock();
                        }
                        return null;
                    }
                });
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
        RemoteMultiLock lock = new RemoteMultiLock(ids, this.synchronizer, config);
        try {
            lock.lock();
            consumer.accept(ids);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T tryLockGet(final List<Long> ids, final Function<List<Long>, T> mapper, final LockConfig config) {
        if (config.getOpenTrans().booleanValue()) {
            try {
                this.transactionManager.transactionExecution(Propagation.REQUIRES_NEW, -1, "lock multi", new Class[0], new Class[]{Exception.class}, new Callable<T>(){

                    @Override
                    public T call() throws Exception {
                        RemoteMultiLock lock = new RemoteMultiLock(ids, BusinessFacadeImpl.this.synchronizer, config);
                        try {
                            lock.lock();
                            Object r = mapper.apply(ids);
                            return r;
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        } else {
            RemoteMultiLock lock = new RemoteMultiLock(ids, this.synchronizer, config);
            try {
                lock.lock();
                T t = mapper.apply(ids);
                return t;
            }
            finally {
                lock.unlock();
            }
        }
        return null;
    }

    @Override
    public <T> T tryLockGet(List<Long> ids, Function<List<Long>, T> mapper) {
        return this.tryLockGet(ids, mapper, LockConfig.getDefault());
    }

    @Override
    public ExecutionResult query(String queryString) {
        GraphQL graphQL = this.schemaHolder.getGraphQL(this.fetcher.getProfile(this.contextService.getAll()));
        Optional currentSpan = TraceHelper.currentSpan((Tracer)this.tracer);
        DataLoaderRegistry registry = new DataLoaderRegistry();
        this.engine.getRepository().codes().forEach(code -> registry.computeIfAbsent(code, lazy -> DataLoader.newDataLoader((BatchLoaderWithContext)new BatchDataLoader(this.queryProviders))));
        ExecutionInput executionInput = ExecutionInput.newExecutionInput().query(queryString).dataLoaderRegistry(registry).variables(this.contextService.getAll()).executionId(ExecutionId.from((String)currentSpan.map(x -> x.toString()).orElse(""))).build();
        return graphQL.execute(executionInput);
    }

    @Override
    public ExecutionResult mutation(String mutation) {
        GraphQL graphQL = this.schemaHolder.getGraphQL(this.fetcher.getProfile(this.contextService.getAll()));
        Optional currentSpan = TraceHelper.currentSpan((Tracer)this.tracer);
        ExecutionInput executionInput = ExecutionInput.newExecutionInput().query(mutation).variables(this.contextService.getAll()).executionId(ExecutionId.from((String)currentSpan.map(x -> x.toString()).orElse(""))).build();
        return graphQL.execute(executionInput);
    }
}

