package com.xforceplus.ultraman.oqsengine.sdk.business.meta;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import io.vavr.Tuple2;

import java.util.*;
import java.util.stream.Stream;

/**
 * a entity key with business key-value
 */
public class EntityKey {

    private EntityClassId entityClassId;

    private IEntityClass entityClass;

    private Map<String, Object> businessKey = new HashMap<>();

    public static EntityKey of(IEntityClass entityClass, Tuple2<String, Object>... keyValues){
        return new EntityKey(entityClass, keyValues);
    }

    public static EntityKey of(EntityClassId classId, Tuple2<String, Object>... keyValues){
        return new EntityKey(classId, keyValues);
    }

    public EntityKey(EntityClassId entityClassId, Tuple2<String, Object>... keyValues){
        Objects.requireNonNull(keyValues, "business key value should not be null");
        this.entityClassId = entityClassId;
        Stream.of(keyValues).forEach(x -> {
            businessKey.put(x._1(), x._2());
        });

    }

    public EntityKey(IEntityClass entityClass, Tuple2<String, Object>... keyValues) {
        Objects.requireNonNull(keyValues, "business key value should not be null");
        this.entityClass = entityClass;
        Stream.of(keyValues).forEach(x -> {
            businessKey.put(x._1(), x._2());
        });
    }

    public IEntityClass getSchema() {
        return entityClass;
    }

    public Map<String, Object> getBusinessKey() {
        return Collections.unmodifiableMap(businessKey);
    }
}