package com.xforceplus.ultraman.oqsengine.sdk.business.meta;

import com.xforceplus.ultraman.bocp.gen.typed.TypedField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.reader.record.Record;
import com.xforceplus.ultraman.oqsengine.sdk.business.meta.service.BusinessFacade;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 *
 */
public class GeneralEntityInstance implements EntityInstance {

    private Record record;

    private IEntityClass entityClass;

    private EntityId entityId;

    private BusinessFacade businessFacade;

    public GeneralEntityInstance(Record record, IEntityClass entityClass, BusinessFacade businessFacade) {
        this.record = record;
        this.entityClass = entityClass;
        this.businessFacade = businessFacade;
        entityId = new EntityId(entityClass, record.getId());
    }

    @Override
    public boolean instanceOf(IEntityClass entityClass) {
        return businessFacade.isAssignableFrom(entityClass, type());
    }

    @Override
    public EntityId id() {
        return entityId;
    }

    @Override
    public IEntityClass type() {
        return this.entityClass;
    }

    @Override
    public <T> Optional<T> into(Class<T> clazz) {
       return Optional.ofNullable(record.into(clazz));
    }

    @Override
    public Map<String, Object> value() {
        return record.toMap(null);
    }

    @Override
    public <T> Optional<T> getValue(TypedField<T> field) {
        return record.get(field);
    }

    @Override
    public Record getRecord() {
        return record;
    }

    @Override
    public Optional<Object> getValue(String name) {
        return record.get(name);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GeneralEntityInstance that = (GeneralEntityInstance) o;
        return Objects.equals(record, that.record) &&
                Objects.equals(entityId, that.entityId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(record, entityId);
    }

    @Override
    public String toString() {
        return "GeneralEntityInstance{" +
                "record=" + record +
                ", entityClass=" + entityClass.code() +
                ", entityId=" + entityId +
                '}';
    }
}
