package com.xforceplus.ultraman.oqsengine.sdk.business.meta;

import com.xforceplus.ultraman.bocp.gen.typed.TypedField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.reader.record.Record;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 *
 */
public class ValueBasedEntityInstance implements EntityInstance{

    private Record record;

    public ValueBasedEntityInstance(Record record) {
        this.record = record;
    }

    @Override
    public boolean instanceOf(IEntityClass entityClass) {
        return false;
    }

    @Override
    public EntityId id() {
        return new EntityId(null, record.getId());
    }

    @Override
    public IEntityClass type() {
        return null;
    }

    @Override
    public <T> Optional<T> into(Class<T> clazz) {
        return Optional.ofNullable(record.into(clazz));
    }

    @Override
    public Map<String, Object> value() {
        return record.toMap(null);
    }

    @Override
    public <T> Optional<T> getValue(TypedField<T> field) {
        return record.get(field);
    }

    @Override
    public Record getRecord() {
        return record;
    }

    @Override
    public Optional<Object> getValue(String name) {
        return record.get(name);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ValueBasedEntityInstance that = (ValueBasedEntityInstance) o;
        return Objects.equals(record, that.record);
    }

    @Override
    public int hashCode() {
        return Objects.hash(record);
    }

    @Override
    public String toString() {
        return "ValueBasedEntityInstance{" +
                "record=" + record.toMap(null) +
                '}';
    }
}
