/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.business.meta;

import com.xforceplus.ultraman.bocp.gen.typed.TypedField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.reader.record.Record;
import com.xforceplus.ultraman.oqsengine.sdk.business.meta.EntityId;
import com.xforceplus.ultraman.oqsengine.sdk.business.meta.EntityInstance;
import com.xforceplus.ultraman.oqsengine.sdk.business.meta.service.BusinessFacade;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class GeneralEntityInstance
implements EntityInstance {
    private Record record;
    private IEntityClass entityClass;
    private EntityId entityId;
    private BusinessFacade businessFacade;

    public GeneralEntityInstance(Record record, IEntityClass entityClass, BusinessFacade businessFacade) {
        this.record = record;
        this.entityClass = entityClass;
        this.businessFacade = businessFacade;
        this.entityId = new EntityId(entityClass, record.getId());
    }

    @Override
    public boolean instanceOf(IEntityClass entityClass) {
        return this.businessFacade.isAssignableFrom(entityClass, this.type());
    }

    @Override
    public EntityId id() {
        return this.entityId;
    }

    @Override
    public IEntityClass type() {
        return this.entityClass;
    }

    @Override
    public <T> Optional<T> into(Class<T> clazz) {
        return Optional.ofNullable(this.record.into(clazz));
    }

    @Override
    public Map<String, Object> value() {
        return this.record.toMap(null);
    }

    @Override
    public <T> Optional<T> getValue(TypedField<T> field) {
        return this.record.get(field);
    }

    @Override
    public Record getRecord() {
        return this.record;
    }

    @Override
    public Optional<Object> getValue(String name) {
        return this.record.get(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeneralEntityInstance that = (GeneralEntityInstance)o;
        return Objects.equals(this.record, that.record) && Objects.equals(this.entityId, that.entityId);
    }

    public int hashCode() {
        return Objects.hash(this.record, this.entityId);
    }

    public String toString() {
        return "GeneralEntityInstance{record=" + this.record + ", entityClass=" + this.entityClass.code() + ", entityId=" + this.entityId + '}';
    }
}

