package com.xforceplus.ultraman.oqsengine.sdk.business.meta;

/**
 * id how to determine entity
 */
public class EntityClassId {

    private String appId;

    private String branch;

    private String code;

    private Long guid;

    public EntityClassId(String appId, String branch, String code, Long guid) {
        this.appId = appId;
        this.branch = branch;
        this.code = code;
        this.guid = guid;
    }

    public static Builder builder(){
        return new Builder();
    }

    public static class Builder{

        Long id;

        String code;

        String app;

        String branch;

        public Builder id(Long id){
            this.id = id;
            return  this;
        };

        public Builder code(String code){
            this.code = code;
            return  this;
        };

        public Builder app(String app){
            this.app = app;
            return  this;
        };

        public Builder branch(String branch){
            this.branch = branch;
            return  this;
        };

        public EntityClassId build(){
            return new EntityClassId(app, branch, code, id);
        }
    }
}
