/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.service.export.impl;

import akka.NotUsed;
import akka.stream.ActorMaterializer;
import akka.stream.IOResult;
import akka.stream.Materializer;
import akka.stream.javadsl.Sink;
import akka.stream.javadsl.Source;
import akka.util.ByteString;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.Relation;
import com.xforceplus.ultraman.oqsengine.sdk.event.EntityErrorExported;
import com.xforceplus.ultraman.oqsengine.sdk.event.EntityExported;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpRel;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ClassifiedRecord;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.EntityExportService;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportCallBack;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportQuery;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportSchemaConfig;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportSink;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportSource;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportStringTransformer;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.NameMapping;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEntityExportService
implements EntityExportService {
    private Logger logger = LoggerFactory.getLogger(EntityExportService.class);
    private final List<ExportSource> exportSourceList;
    private final ExportSink exportSink;
    private final ExportStringTransformer transformer;
    private final ActorMaterializer mat;
    private final ExportCallBack callback;
    private static final String SYNC = "sync";

    public AbstractEntityExportService(List<ExportSource> exportSourceList, ExportSink exportSink, ExportStringTransformer transformer, ExportCallBack exportCallBack, ActorMaterializer mat) {
        this.exportSourceList = exportSourceList;
        this.exportSink = exportSink;
        this.callback = exportCallBack;
        this.transformer = transformer;
        this.mat = mat;
    }

    private boolean isMultiSchema(ExportQuery exportQuery) {
        Map<String, ExpRel> subQuery = exportQuery.getSubQuery();
        return subQuery != null && !subQuery.isEmpty();
    }

    private Source<ClassifiedRecord, NotUsed> genMultiSchema(List<ExportQuery> exportQueries, Map<String, Object> context) {
        Optional<Source> independentSourceOp = exportQueries.stream().map(exportQuery -> {
            Source<ClassifiedRecord, NotUsed> independentQuery = this.getIndependentSource((ExportQuery)exportQuery, context);
            return independentQuery;
        }).reduce(Source::concat);
        return independentSourceOp.orElseGet(Source::empty);
    }

    private Source<ClassifiedRecord, NotUsed> getIndependentSource(ExportQuery exportQuery, Map<String, Object> context) {
        IEntityClass entityClass = exportQuery.getEntityClass();
        boolean multiSchema = this.isMultiSchema(exportQuery);
        Optional<ExportSource> sourceOp = this.exportSourceList.stream().sorted().filter(x -> x.isAccept(entityClass, multiSchema, context)).findFirst();
        ExpRel mainQuery = exportQuery.getMainQuery();
        Map<String, ExpRel> subQuery = exportQuery.getSubQuery();
        return sourceOp.map(x -> x.source(null, entityClass, mainQuery, subQuery, context)).orElseGet(() -> {
            this.logger.warn("no suitable source found for {} when {}", (Object)entityClass.code(), (Object)context);
            return Source.empty();
        });
    }

    protected Source<ClassifiedRecord, NotUsed> prepareSource(List<ExportQuery> exportQueries, Map<String, Object> context) {
        Source<ClassifiedRecord, NotUsed> source;
        if (exportQueries.size() > 1) {
            if (this.isSupportMultiSchema()) {
                source = this.genMultiSchema(exportQueries, context);
            } else {
                ExportQuery exportQuery = exportQueries.get(0);
                source = this.getIndependentSource(exportQuery, context);
            }
        } else {
            ExportQuery exportQuery = exportQueries.get(0);
            source = this.getIndependentSource(exportQuery, context);
        }
        return source;
    }

    protected Sink<ByteString, CompletionStage<Tuple2<IOResult, String[]>>> prepareSink(String downloadName, String fileName) {
        return this.exportSink.getSink(this.generateFileType(), downloadName, fileName);
    }

    private List<IEntityClass> getRelatedMainEntityClassList(List<ExportQuery> exportQueries) {
        return exportQueries.stream().map(ExportQuery::getEntityClass).collect(Collectors.toList());
    }

    private Map<String, ExportSchemaConfig> getExportSchemaConfigMapping(List<ExportQuery> exportQueries) {
        HashMap<String, ExportSchemaConfig> mapping = new HashMap<String, ExportSchemaConfig>();
        exportQueries.forEach(x -> {
            String entityCode = x.getEntityClass().code();
            Map<String, List<NameMapping>> nameMapping = x.getNameMapping();
            List nameMappings = Optional.ofNullable(nameMapping.get(entityCode)).orElseGet(Collections::emptyList);
            Map<String, String> nMapping = nameMappings.stream().filter(nameItem -> nameItem.getText() != null && nameItem.getCode() != null).collect(Collectors.toMap(NameMapping::getCode, NameMapping::getText, (a, b) -> a));
            HashMap<String, String> modifyMapping = new HashMap<String, String>(nMapping);
            modifyMapping.putIfAbsent(entityCode, x.getEntityClass().name());
            ExpRel mainQuery = x.getMainQuery();
            List orderColumn = mainQuery.getOrderedProjectNames();
            ExportSchemaConfig exportSchemaConfig = new ExportSchemaConfig();
            exportSchemaConfig.setNameMapping(modifyMapping);
            exportSchemaConfig.setOrderedColumn(orderColumn);
            mapping.put(entityCode, exportSchemaConfig);
            if (x.getSubQuery() != null) {
                x.getSubQuery().forEach((key, value) -> {
                    List subNameMappings = Optional.ofNullable(nameMapping.get(key)).orElseGet(Collections::emptyList);
                    Map<String, String> subMapping = subNameMappings.stream().filter(subItem -> subItem.getText() != null && subItem.getCode() != null).collect(Collectors.toMap(NameMapping::getCode, NameMapping::getText, (a, b) -> a));
                    HashMap<String, String> subModifyMapping = new HashMap<String, String>(subMapping);
                    Optional<Relation> first = x.getEntityClass().relations().stream().filter(rel -> rel.getName().equalsIgnoreCase((String)key)).findFirst();
                    first.ifPresent(relation -> subModifyMapping.putIfAbsent((String)key, relation.getName()));
                    ExportSchemaConfig sub = new ExportSchemaConfig();
                    sub.setNameMapping(subModifyMapping);
                    sub.setOrderedColumn(value.getOrderedProjectNames());
                    mapping.put((String)key, sub);
                });
            }
        });
        return mapping;
    }

    protected String getStringValue(IEntityClass entityClass, IEntityField field, Object value, Map<String, Object> context) {
        return this.transformer.toString(entityClass, field, value, context);
    }

    protected abstract Source<ByteString, ?> toByteStringSource(List<IEntityClass> var1, Source<ClassifiedRecord, NotUsed> var2, Map<String, ExportSchemaConfig> var3, boolean var4, Map<String, Object> var5);

    @Override
    public CompletableFuture<Either<String, String>> export(List<ExportQuery> exportQueries, String token, String fileName, String exportType, boolean skipTransformer, Map<String, Object> context, Map<String, Object> notifyContext) {
        if (exportQueries == null || exportQueries.isEmpty()) {
            return CompletableFuture.completedFuture(Either.left((Object)"Empty Query for Export"));
        }
        List<IEntityClass> entityClassList = this.getRelatedMainEntityClassList(exportQueries);
        try {
            Source<ClassifiedRecord, NotUsed> source = this.prepareSource(exportQueries, context);
            Sink<ByteString, CompletionStage<Tuple2<IOResult, String[]>>> sink = this.prepareSink(token, fileName);
            Source<ByteString, ?> byteStringSource = this.toByteStringSource(entityClassList, source, this.getExportSchemaConfigMapping(exportQueries), skipTransformer, context);
            CompletionStage syncCompleteResult = ((CompletableFuture)((CompletionStage)byteStringSource.runWith(sink, (Materializer)this.mat)).toCompletableFuture().thenApply(x -> {
                String downloadUrl = this.exportSink.getDownloadUrl(this.generateFileType(), (String[])x._2());
                if (this.callback != null) {
                    this.callback.onSuccess(() -> new EntityExported(entityClassList, downloadUrl, fileName, exportType, context, notifyContext));
                }
                return Either.right((Object)downloadUrl);
            })).exceptionally(th -> {
                if (this.callback != null) {
                    this.callback.onFailure(() -> new EntityErrorExported(token, th.getMessage(), context, notifyContext));
                }
                return Either.left((Object)th.getMessage());
            });
            if (SYNC.equalsIgnoreCase(exportType)) {
                return syncCompleteResult;
            }
            return CompletableFuture.completedFuture(Either.right((Object)"\u8bf7\u6c42\u5b8c\u6210"));
        }
        catch (Exception ex) {
            this.logger.error("{}", (Throwable)ex);
            return CompletableFuture.completedFuture(Either.left((Object)ex.getMessage()));
        }
    }
}

