/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.service.export.impl;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.sdk.command.ConditionExportCmd;
import com.xforceplus.ultraman.oqsengine.sdk.command.GetImportTemplateCmd;
import com.xforceplus.ultraman.oqsengine.sdk.command.ImportCmd;
import com.xforceplus.ultraman.oqsengine.sdk.facade.EntityFacade;
import com.xforceplus.ultraman.oqsengine.sdk.query.export.ExportCmdQuery;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.BulkService;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.DownloadFilenameGenerator;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.EntityExportService;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportQuery;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ImportService;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.config.ExportConfig;
import com.xforceplus.ultraman.oqsengine.sdk.store.engine.IEntityClassEngine;
import com.xforceplus.ultraman.oqsengine.sdk.store.engine.IEntityClassGroup;
import com.xforceplus.ultraman.oqsengine.sdk.store.engine.ProfileFetcher;
import com.xforceplus.ultraman.oqsengine.sdk.transactional.OqsTransactionManager;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.NameMapping;
import com.xforceplus.xplat.galaxy.framework.context.ContextService;
import com.xforceplus.xplat.galaxy.framework.dispatcher.anno.QueryHandler;
import com.xforceplus.xplat.galaxy.framework.dispatcher.messaging.MetaData;
import com.xforceplus.xplat.galaxy.framework.dispatcher.messaging.QueryMessage;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class BulkServiceImpl
implements BulkService {
    private EntityFacade entityFacade;
    private List<EntityExportService> exportServices;
    private ImportService importService;
    private ContextService contextService;
    private ProfileFetcher fetcher;
    private ExportConfig exportConfig;
    private DownloadFilenameGenerator filenameGenerator;
    private IEntityClassEngine engine;
    private OqsTransactionManager manager;
    private static final String MISSING_ENTITIES = "\u67e5\u8be2\u5bf9\u8c61\u4e0d\u5b58\u5728";

    public BulkServiceImpl(EntityFacade entityFacade, ImportService importService, List<EntityExportService> exportServices, ContextService contextService, ExportConfig exportConfig, DownloadFilenameGenerator filenameGenerator, ProfileFetcher fetcher, IEntityClassEngine engine, OqsTransactionManager manager) {
        this.entityFacade = entityFacade;
        this.exportServices = exportServices;
        this.contextService = contextService;
        this.exportConfig = exportConfig;
        this.filenameGenerator = filenameGenerator;
        this.importService = importService;
        this.fetcher = fetcher;
        this.engine = engine;
        this.manager = manager;
    }

    @Override
    @QueryHandler(isDefault=true)
    public CompletableFuture<Either<String, String>> conditionExport(QueryMessage<ConditionExportCmd, ?> message) {
        ConditionExportCmd cmd = (ConditionExportCmd)message.getPayload();
        MetaData metaData = message.getMetaData();
        Long currentTime = System.nanoTime();
        String token = Optional.ofNullable(metaData.get((Object)"code")).map(Object::toString).orElse(cmd.getBoId()).trim() + "-" + currentTime;
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.putAll((Map<String, Object>)metaData);
        context.putAll(Optional.ofNullable(this.contextService).map(ContextService::getAll).orElseGet(Collections::emptyMap));
        String fileName = this.filenameGenerator.getFileName(cmd, context);
        String exportType = cmd.getExportType();
        String exportFileType = cmd.getExportFileType();
        List<ExportQuery> exportQueries = this.toExportQueryList(cmd.getExports(), cmd.version());
        if (exportQueries.isEmpty()) {
            return CompletableFuture.completedFuture(Either.left((Object)MISSING_ENTITIES));
        }
        Optional<EntityExportService> exportServiceOp = this.exportServices.stream().filter(x -> x.isAccept(exportFileType)).findAny();
        if (exportServiceOp.isPresent()) {
            EntityExportService entityExportService = exportServiceOp.get();
            HashMap<String, Object> notifyContext = new HashMap<String, Object>();
            notifyContext.put("appId", Optional.ofNullable(cmd.getAppId()).orElse(this.exportConfig.getNotifyId()));
            return entityExportService.export(exportQueries, token, fileName, exportType, cmd.isSkipTransformer(), Optional.ofNullable(this.contextService).map(x -> x.getAll()).orElseGet(Collections::emptyMap), notifyContext);
        }
        return CompletableFuture.completedFuture(Either.left((Object)("No suitable ExportService for " + exportFileType)));
    }

    private List<ExportQuery> toExportQueryList(Map<String, ExportCmdQuery> exports, String version) {
        return exports.entrySet().stream().map(entry -> {
            String boId = (String)entry.getKey();
            String profile = this.fetcher.getProfile(Collections.emptyMap());
            Optional iEntityClassOp = version == null ? this.entityFacade.load(boId, profile) : this.entityFacade.load(boId, profile, version);
            if (iEntityClassOp.isPresent()) {
                ExportQuery exportQuery = new ExportQuery();
                HashMap<String, List<NameMapping>> map = new HashMap<String, List<NameMapping>>();
                ExportCmdQuery cmdQuery = (ExportCmdQuery)entry.getValue();
                map.put(((IEntityClass)iEntityClassOp.get()).code(), cmdQuery.getMainMapping());
                map.putAll(cmdQuery.getSubMapping());
                exportQuery.setEntityClass((IEntityClass)iEntityClassOp.get());
                exportQuery.setNameMapping(map);
                exportQuery.setMainQuery(cmdQuery.getMainQuery());
                exportQuery.setSubQuery(cmdQuery.getSubQuery());
                return exportQuery;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    @QueryHandler(isDefault=true)
    public CompletableFuture<Either<String, String>> importTemplateCustom(GetImportTemplateCmd cmd) {
        String profile;
        String boId = cmd.getBoId();
        Optional entityClass = this.entityFacade.load(boId, profile = this.fetcher.getProfile(Collections.emptyMap()));
        if (entityClass.isPresent()) {
            IEntityClassGroup group = this.engine.describe((IEntityClass)entityClass.get(), profile);
            List mappingList = cmd.getMappingList();
            String name = this.importService.fileName((IEntityClass)entityClass.get());
            String fileType = this.importService.fileType();
            String uuid = this.importService.getCustomTemplate(group, mappingList, cmd.getSubMapping());
            return CompletableFuture.completedFuture(Either.right((Object)uuid));
        }
        return CompletableFuture.completedFuture(Either.left((Object)MISSING_ENTITIES));
    }

    @Override
    @QueryHandler(isDefault=true)
    public Either<String, Tuple2<String, InputStream>> importTemplate(GetImportTemplateCmd cmd) {
        String profile;
        String boId = cmd.getBoId();
        Optional entityClass = this.entityFacade.load(boId, profile = this.fetcher.getProfile(Collections.emptyMap()));
        if (entityClass.isPresent()) {
            IEntityClassGroup group = this.engine.describe((IEntityClass)entityClass.get(), profile);
            String name = this.importService.fileName((IEntityClass)entityClass.get());
            String fileType = this.importService.fileType();
            return Either.right((Object)Tuple.of((Object)(name + "." + fileType), (Object)this.importService.getTemplateInputStream(group, cmd.isSkipSystem())));
        }
        return Either.left((Object)MISSING_ENTITIES);
    }

    private String getKeyFromHeader(String headerPart) {
        int start = headerPart.indexOf("[");
        int end = headerPart.indexOf("]");
        if (start < 0 || end < 0) {
            return headerPart;
        }
        return headerPart.substring(start + 1, end);
    }

    @Override
    @QueryHandler(isDefault=true)
    public Either<String, String> batchImport(ImportCmd cmd) {
        String profile;
        String boId = cmd.getBoId();
        Optional entityClassOp = this.entityFacade.load(boId, profile = this.fetcher.getProfile(Collections.emptyMap()));
        if (entityClassOp.isPresent()) {
            Either ret;
            try {
                IEntityClassGroup entityClassGroup = this.engine.describe((IEntityClass)entityClassOp.get(), profile);
                if (cmd.isUseTrans()) {
                    this.importService.consumeStep(entityClassGroup, cmd.isUseBatch(), cmd.getTimeout(), cmd.getStep(), cmd.getInputStream());
                    return Either.right((Object)"ok");
                }
                this.importService.consume(entityClassGroup, cmd.getInputStream());
                ret = Either.right((Object)"ok");
            }
            catch (Throwable e) {
                e.printStackTrace();
                ret = Either.left((Object)e.getMessage());
            }
            return ret;
        }
        return Either.left((Object)MISSING_ENTITIES);
    }
}

