/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.service.export.impl;

import akka.NotUsed;
import akka.japi.function.Function;
import akka.stream.ActorMaterializer;
import akka.stream.Graph;
import akka.stream.javadsl.Flow;
import akka.stream.javadsl.Source;
import akka.util.ByteString;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.ColumnField;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ClassifiedRecord;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportCallBack;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportSchemaConfig;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportSink;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportSource;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportStringTransformer;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.impl.AbstractEntityExportService;
import io.vavr.Tuple2;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVEntityExportServiceImpl
extends AbstractEntityExportService {
    private Logger logger = LoggerFactory.getLogger(CSVEntityExportServiceImpl.class);

    public CSVEntityExportServiceImpl(List<ExportSource> exportSourceList, ExportSink exportSink, ExportCallBack callBack, ExportStringTransformer transformer, ActorMaterializer mat) {
        super(exportSourceList, exportSink, transformer, callBack, mat);
    }

    @Override
    public boolean isAccept(String extension) {
        return !"xls".equals(extension);
    }

    @Override
    public boolean isSupportMultiSchema() {
        return false;
    }

    @Override
    public String generateFileType() {
        return "csv";
    }

    private Source<ByteString, NotUsed> getCSVHeaderSource() {
        byte[] bom = new byte[]{-17, -69, -65};
        return Source.single((Object)ByteString.fromArray((byte[])bom));
    }

    @Override
    protected Source<ByteString, ?> toByteStringSource(List<IEntityClass> entityClasses, Source<ClassifiedRecord, NotUsed> rawSource, Map<String, ExportSchemaConfig> schemaMapping, boolean skipTransformer, Map<String, Object> context) {
        Flow<ClassifiedRecord, String, NotUsed> flow = this.getFlow(schemaMapping, context, skipTransformer);
        Source<ByteString, NotUsed> bomSource = this.getCSVHeaderSource();
        return bomSource.concat((Graph)rawSource.via(flow).map((Function & Serializable)x -> ByteString.fromString((String)x, (Charset)StandardCharsets.UTF_8)));
    }

    private String csvEscape(String strValue) {
        return StringEscapeUtils.escapeCsv((String)("\t" + strValue));
    }

    private Flow<ClassifiedRecord, String, NotUsed> getFlow(Map<String, ExportSchemaConfig> schemaMapping, Map<String, Object> context, boolean skipTransformer) {
        AtomicBoolean isFirstLine = new AtomicBoolean(true);
        return Flow.create().map((Function & Serializable)record -> {
            String classifyStr = record.getClassifyStr();
            ExportSchemaConfig schemaConfig = (ExportSchemaConfig)schemaMapping.get(classifyStr);
            Map nameMapping = Optional.ofNullable(schemaConfig).map(ExportSchemaConfig::getNameMapping).orElseGet(Collections::emptyMap);
            List orderedColumn = Optional.ofNullable(schemaConfig).map(ExportSchemaConfig::getOrderedColumn).orElseGet(Collections::emptyList);
            StringBuilder sb = new StringBuilder();
            if (isFirstLine.get()) {
                String header = record.getRecord().stream(orderedColumn).map(Tuple2::_1).map(x -> Optional.ofNullable(x).map(y -> {
                    String fieldName = y.name();
                    String name = (String)nameMapping.get(fieldName);
                    if (name == null) {
                        return y.cnName();
                    }
                    return name;
                }).orElse("")).collect(Collectors.joining(","));
                sb.append(header);
                sb.append("\n");
                isFirstLine.set(false);
            }
            String line = record.getRecord().stream(orderedColumn).map(x -> {
                ColumnField field = (ColumnField)x._1();
                Object value = x._2();
                String safeSourceValue = Optional.ofNullable(value).map(Object::toString).orElse("");
                if (!skipTransformer) {
                    safeSourceValue = this.getStringValue(field.originEntityClass(), (IEntityField)field, value, context);
                }
                return this.csvEscape(safeSourceValue);
            }).collect(Collectors.joining(","));
            sb.append(line);
            sb.append("\n");
            return sb.toString();
        });
    }
}

