/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.service.export.impl;

import akka.NotUsed;
import akka.japi.function.Creator;
import akka.japi.function.Function;
import akka.japi.function.Procedure;
import akka.stream.ActorMaterializer;
import akka.stream.Materializer;
import akka.stream.javadsl.Sink;
import akka.stream.javadsl.Source;
import akka.stream.javadsl.StreamConverters;
import akka.util.ByteString;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.ColumnField;
import com.xforceplus.ultraman.oqsengine.pojo.reader.record.Record;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ClassifiedRecord;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportCallBack;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportSchemaConfig;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportSink;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportSource;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportStringTransformer;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.config.ExportExcelConfig;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.impl.AbstractEntityExportService;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.FormulaError;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelEntityExportServiceImpl
extends AbstractEntityExportService {
    private ExportExcelConfig excelConfig;
    private final ActorMaterializer mat;
    private ExecutorService executorService;
    private Logger logger = LoggerFactory.getLogger(ExcelEntityExportServiceImpl.class);

    public ExcelEntityExportServiceImpl(List<ExportSource> exportSourceList, ExportSink exportSink, ExportCallBack callBack, ExportStringTransformer transformer, ExportExcelConfig excelConfig, ActorMaterializer mat, ExecutorService executorService) {
        super(exportSourceList, exportSink, transformer, callBack, mat);
        this.mat = mat;
        this.excelConfig = excelConfig;
        this.executorService = executorService;
    }

    @Override
    public boolean isAccept(String extension) {
        return "xlsx".equals(extension) || "xls".equals(extension);
    }

    @Override
    public boolean isSupportMultiSchema() {
        return true;
    }

    @Override
    public String generateFileType() {
        return "xlsx";
    }

    private void insertCell(Record record, Row row, List<String> orderedColumn, Map<String, Object> context, boolean isSkipTransformer) {
        AtomicInteger ai = new AtomicInteger(0);
        orderedColumn = orderedColumn.stream().map(x -> {
            if (x.startsWith("_")) {
                return x.substring(1);
            }
            return x;
        }).collect(Collectors.toList());
        record.stream(orderedColumn).forEach(x -> {
            ColumnField field = (ColumnField)x._1();
            IEntityClass entityClass = field.originEntityClass();
            Cell cell = row.createCell(ai.getAndIncrement());
            if (x._2() != null) {
                try {
                    String value = x._2.toString();
                    if (!isSkipTransformer) {
                        value = this.getStringValue(entityClass, (IEntityField)field, x._2.toString(), context);
                    }
                    cell.setCellValue(value);
                }
                catch (Exception ex) {
                    this.logger.error("{}", (Throwable)ex);
                    cell.setBlank();
                    cell.setCellErrorValue(FormulaError.VALUE.getCode());
                }
            }
        });
    }

    private void insertHeader(Record record, Row row, List<String> orderedColumn, Map<String, String> nameMappings) {
        AtomicInteger ai = new AtomicInteger(0);
        orderedColumn = orderedColumn.stream().map(x -> x.startsWith("_") ? x.substring(1) : x).collect(Collectors.toList());
        record.stream(orderedColumn).forEach(x -> {
            Cell cell = row.createCell(ai.getAndIncrement());
            String key = ((IEntityField)x._1()).name();
            String columnName = Optional.ofNullable(nameMappings).flatMap(np -> Optional.ofNullable(np.get(key))).orElse(((IEntityField)x._1).cnName());
            cell.setCellValue(Optional.ofNullable(columnName).orElse(key));
        });
    }

    private void prepareSheet(SXSSFWorkbook wb, List<IEntityClass> entityClasses, Map<String, ExportSchemaConfig> schemaMapping, Map<String, Tuple2<Sheet, AtomicInteger>> sheetMapping) {
        entityClasses.forEach(entityClass -> {
            String sheetCode = entityClass.code();
            Tuple2 sheetTuple = (Tuple2)sheetMapping.get(sheetCode);
            ExportSchemaConfig schemaConfig = (ExportSchemaConfig)schemaMapping.get(sheetCode);
            Map mapping = Optional.ofNullable(schemaConfig).map(ExportSchemaConfig::getNameMapping).orElseGet(Collections::emptyMap);
            String sheetName = Optional.ofNullable(mapping.get(sheetCode)).orElse(sheetCode);
            if (sheetTuple == null) {
                SXSSFSheet sheet = wb.createSheet(sheetName);
                AtomicInteger linesInSheet = new AtomicInteger(0);
                sheetTuple = Tuple.of((Object)sheet, (Object)linesInSheet);
                sheetMapping.put(sheetCode, sheetTuple);
            }
        });
    }

    public Sink<ClassifiedRecord, InputStream> excelSink(List<IEntityClass> entityClasses, Map<String, ExportSchemaConfig> schemaMapping, boolean isSkipTransformer, Map<String, Object> context) {
        SXSSFWorkbook wb = new SXSSFWorkbook(this.excelConfig.getInMemRow().intValue());
        ConcurrentHashMap<String, Tuple2<Sheet, AtomicInteger>> sheetMapping = new ConcurrentHashMap<String, Tuple2<Sheet, AtomicInteger>>(36);
        this.prepareSheet(wb, entityClasses, schemaMapping, sheetMapping);
        PipedOutputStream out = new PipedOutputStream();
        PipedInputStream in = new PipedInputStream();
        try {
            in.connect(out);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        Sink excelSink = Sink.foreach((Procedure & Serializable)tuple -> {
            try {
                Row row;
                String sheetCode = tuple.getClassifyStr();
                Tuple2 sheetTuple = (Tuple2)sheetMapping.get(sheetCode);
                Record record = tuple.getRecord();
                ExportSchemaConfig schemaConfig = (ExportSchemaConfig)schemaMapping.get(sheetCode);
                Map mapping = Optional.ofNullable(schemaConfig).map(ExportSchemaConfig::getNameMapping).orElseGet(Collections::emptyMap);
                List orderedColumn = Optional.ofNullable(schemaConfig).map(x -> x.getOrderedColumn()).orElseGet(Collections::emptyList);
                String sheetName = Optional.ofNullable(mapping.get(sheetCode)).orElse(sheetCode);
                if (sheetTuple == null) {
                    SXSSFSheet sheet = wb.createSheet(sheetName);
                    AtomicInteger linesInSheet = new AtomicInteger(0);
                    sheetTuple = Tuple.of((Object)sheet, (Object)linesInSheet);
                    sheetMapping.put(sheetCode, sheetTuple);
                }
                if (((AtomicInteger)sheetTuple._2()).get() == 0) {
                    row = ((Sheet)sheetTuple._1).createRow(((AtomicInteger)sheetTuple._2).getAndIncrement());
                    this.insertHeader(record, row, orderedColumn, mapping);
                }
                row = ((Sheet)sheetTuple._1).createRow(((AtomicInteger)sheetTuple._2).getAndIncrement());
                this.insertCell(record, row, orderedColumn, context, isSkipTransformer);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }).mapMaterializedValue((Function & Serializable)x -> {
            x.thenRunAsync(() -> {
                try {
                    wb.write((OutputStream)out);
                    wb.close();
                    wb.dispose();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                finally {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }, this.executorService);
            return in;
        });
        return excelSink;
    }

    @Override
    protected Source<ByteString, ?> toByteStringSource(List<IEntityClass> entityClasses, Source<ClassifiedRecord, NotUsed> rawSource, Map<String, ExportSchemaConfig> schemaMapping, boolean isSkipTransformer, Map<String, Object> context) {
        InputStream inputStreamCompletionStage = (InputStream)rawSource.runWith(this.excelSink(entityClasses, schemaMapping, isSkipTransformer, context), (Materializer)this.mat);
        Source source = StreamConverters.fromInputStream((Creator & Serializable)() -> inputStreamCompletionStage);
        return source;
    }
}

