/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.service.export.impl;

import akka.Done;
import akka.japi.function.Function;
import akka.stream.IOResult;
import akka.stream.javadsl.Sink;
import akka.stream.javadsl.StreamConverters;
import akka.util.ByteString;
import com.xforceplus.tower.file.client.model.Policy;
import com.xforceplus.tower.storage.StorageFactory;
import com.xforceplus.tower.storage.model.UploadFileRequest;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportSink;
import com.xforceplus.xplat.galaxy.framework.context.ContextKeys;
import com.xforceplus.xplat.galaxy.framework.context.ContextService;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.io.InputStream;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import scala.util.Try;

public class StorageSink
implements ExportSink {
    private StorageFactory storageFactory;
    private ContextService contextService;
    private String appId;
    private Integer expireInDays = 7;
    private String contextPath = "download/file/%s?type=%s";
    private String contextPathWithFileName = "download/file/%s?filename=%s&type=%s";
    private ExecutorService executionService;

    public StorageSink(StorageFactory storageFactory, ContextService contextService, String appId) {
        this.storageFactory = storageFactory;
        this.contextService = contextService;
        this.appId = appId;
        this.executionService = Executors.newFixedThreadPool(20);
    }

    @Override
    public Sink<ByteString, CompletionStage<Tuple2<IOResult, String[]>>> getSink(String type, String ... token) {
        Long telnetID = (Long)this.contextService.get((ContextService.ContextKey)ContextKeys.LongKeys.TENANT_ID);
        Long userID = (Long)this.contextService.get((ContextService.ContextKey)ContextKeys.LongKeys.ACCOUNT_ID);
        return StreamConverters.asInputStream((Duration)Duration.ofSeconds(60000L)).mapMaterializedValue((Function & Serializable)x -> CompletableFuture.supplyAsync(() -> {
            Long fileId = this.upload(token[0], (InputStream)x, telnetID, userID);
            IOResult ioResult = new IOResult(0L, Try.apply(Done::getInstance));
            String[] newToken = Arrays.copyOf(token, token.length + 1);
            newToken[token.length] = fileId.toString();
            return Tuple.of((Object)ioResult, (Object)newToken);
        }, this.executionService));
    }

    @Override
    public String getDownloadUrl(String type, String ... token) {
        return String.format(this.contextPathWithFileName, token[token.length - 1], token[1], type);
    }

    @Override
    public InputStream getInputStream(String ... token) {
        Long tenantId = (Long)this.contextService.get((ContextService.ContextKey)ContextKeys.LongKeys.TENANT_ID);
        Long userId = (Long)this.contextService.get((ContextService.ContextKey)ContextKeys.LongKeys.ACCOUNT_ID);
        return this.storageFactory.downloadInputStream(userId, tenantId, Long.valueOf(Long.parseLong(token[0])), null);
    }

    private Long upload(String name, InputStream inputStream, Long telnetID, Long userID) {
        UploadFileRequest uploadFileRequest = new UploadFileRequest();
        uploadFileRequest.setAppId(this.appId);
        uploadFileRequest.setExpires(this.expireInDays);
        uploadFileRequest.setInputStream(inputStream);
        uploadFileRequest.setFileName(name);
        uploadFileRequest.setPolicy(Policy.PUBLIC_POLICY);
        uploadFileRequest.setTenantId(telnetID);
        uploadFileRequest.setUserId(userID);
        uploadFileRequest.setOverwrite(Boolean.valueOf(true));
        uploadFileRequest.setFilePath("/export/" + LocalDate.now().format(DateTimeFormatter.ofPattern("YYYY_MM_dd")));
        return this.storageFactory.uploadByInputStream(uploadFileRequest);
    }
}

