/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.service.export.impl;

import akka.NotUsed;
import akka.japi.function.Function;
import akka.japi.function.Predicate;
import akka.stream.javadsl.Source;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.oqsengine.pojo.constants.SystemField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.reader.record.GeneralRecord;
import com.xforceplus.ultraman.oqsengine.pojo.reader.record.Record;
import com.xforceplus.ultraman.oqsengine.sdk.facade.EntityFacade;
import com.xforceplus.ultraman.oqsengine.sdk.facade.result.ResultStatus;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpCondition;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpField;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpNode;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpOperator;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpQuery;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpRel;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpSort;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpValue;
import com.xforceplus.ultraman.oqsengine.sdk.service.core.ExecutionConfig;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ClassifiedRecord;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportSource;
import com.xforceplus.ultraman.oqsengine.sdk.vo.DataCollection;
import io.vavr.control.Either;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceExportSource
implements ExportSource {
    private Logger logger = LoggerFactory.getLogger(ExportSource.class);
    private final int step;
    private final int maxRetryTimes = 5;
    private final EntityFacade entityService;
    private final ContextService contextService;
    private final ExecutionConfig config;

    public SequenceExportSource(EntityFacade entityService, int step, ContextService contextService, ExecutionConfig config) {
        this.entityService = entityService;
        this.step = step;
        this.contextService = contextService;
        this.config = config;
    }

    private <T> T get(CompletionStage<T> future) {
        return future.toCompletableFuture().join();
    }

    @Override
    public boolean isAccept(IEntityClass entityClass, boolean multiSchema, Map<String, Object> context) {
        return !multiSchema;
    }

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Source<ClassifiedRecord, NotUsed> source(String classifier, IEntityClass entityClass, ExpRel expRel, Map<String, ExpRel> subQuery, Map<String, Object> context) {
        Object user = context.get("user");
        AtomicInteger cursor = new AtomicInteger(0);
        AtomicInteger error = new AtomicInteger(0);
        String tag = Optional.ofNullable(classifier).orElseGet(() -> ((IEntityClass)entityClass).code());
        AtomicLong lastId = new AtomicLong(0L);
        Map contextMap = null;
        if (this.contextService != null) {
            contextMap = this.contextService.getAll();
        }
        Map finalContextMap = contextMap;
        return Source.repeat((Object)1).flatMapConcat((Function & Serializable)i -> {
            if (user != null) {
                UserInfoHolder.put((IAuthorizedUser)((IAuthorizedUser)user));
            }
            try {
                if (this.contextService != null && finalContextMap != null) {
                    this.contextService.fromMap(finalContextMap);
                }
                this.logger.info("-----Export {}:{} ---- query {} times ----with last id {}", new Object[]{entityClass.code(), entityClass.id(), cursor.getAndIncrement(), lastId.get()});
                Either byCondition = ((Either)this.get(this.entityService.query(entityClass, this.toNewExpRel(expRel, this.step, lastId.get()), Optional.ofNullable(this.contextService).map(ContextService::getAll).orElseGet(Collections::emptyMap)))).mapLeft(ResultStatus::getMessage);
                if (this.contextService != null) {
                    this.contextService.clear();
                }
                if (byCondition.isRight()) {
                    error.set(0);
                    List ret = ((DataCollection)byCondition.get()).getRows();
                    this.logger.warn("-----Export {}:{} ---- clear error and found size is {} ----", new Object[]{entityClass.code(), entityClass.id(), ret.size()});
                    if (ret.size() < this.step) {
                        LinkedList<Record> list = new LinkedList<Record>(ret);
                        list.addLast(GeneralRecord.empty());
                        Source source = Source.from((Iterable)list.stream().map(r -> ClassifiedRecord.of(tag, r)).collect(Collectors.toList()));
                        return source;
                    }
                    Record lastRecord = (Record)ret.get(ret.size() - 1);
                    if (lastRecord != null) {
                        lastId.set(lastRecord.getId());
                    }
                    Source source = Source.from((Iterable)ret.stream().map(r -> ClassifiedRecord.of(tag, r)).collect(Collectors.toList()));
                    return source;
                }
                this.logger.warn("-----Export {}:{} ---- found error {} ----", new Object[]{entityClass.code(), entityClass.id(), byCondition.getLeft()});
                if (error.getAndIncrement() < 5) {
                    Source source = Source.empty();
                    return source;
                }
                Source source = Source.single((Object)ClassifiedRecord.of(tag, GeneralRecord.empty()));
                return source;
            }
            catch (Throwable throwable) {
                this.logger.error("{}", throwable);
                throw throwable;
            }
            finally {
                UserInfoHolder.clearContext();
            }
        }).takeWhile((Predicate & Serializable)t -> t != null && t.getRecord().nonEmpty() != false);
    }

    public ExpRel toNewExpRel(ExpRel rawQuery, int pageSize, Long lastId) {
        ExpQuery query = (ExpQuery)rawQuery;
        query.range(Integer.valueOf(1), Integer.valueOf(pageSize));
        this.logger.debug("[Export]Remove Sort");
        query.sort(ExpSort.init().withSort("id", "asc"));
        ExpCondition idCondition = ExpCondition.call((ExpOperator)ExpOperator.GREATER_THAN, (ExpNode)ExpField.field((String)SystemField.ID.getName()), (List)ExpValue.from((Object)lastId));
        List filters = query.getFilters();
        if (!filters.isEmpty()) {
            ExpCondition condition;
            ExpNode expNode = (ExpNode)filters.get(filters.size() - 1);
            if (expNode != null && (condition = (ExpCondition)expNode).isSimpleClauseWithFieldName(SystemField.ID.getName()) && condition.getOperator() == ExpOperator.GREATER_THAN) {
                filters.remove(condition);
            }
            filters.add(idCondition);
        } else {
            filters.add(idCondition);
        }
        return rawQuery;
    }
}

