/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.service.export.controller;

import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.tech.base.core.dispatcher.ServiceDispatcher;
import com.xforceplus.ultraman.oqsengine.sdk.command.ConditionExportCmd;
import com.xforceplus.ultraman.oqsengine.sdk.command.GetImportTemplateCmd;
import com.xforceplus.ultraman.oqsengine.sdk.command.ImportCmd;
import com.xforceplus.ultraman.oqsengine.sdk.context.SDKContextKey;
import com.xforceplus.ultraman.oqsengine.sdk.controller.BaseController;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpFactory;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpQuery;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpRel;
import com.xforceplus.ultraman.oqsengine.sdk.query.export.ExportCmdQuery;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.BulkService;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.controller.domain.ImportTemplateRequest;
import com.xforceplus.ultraman.oqsengine.sdk.util.ConditionQueryRequestHelper;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ConditionQueryRequest;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.Conditions;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.EntityItem;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.NameMapping;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.Response;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@RequestMapping
public class EntityBulkController
implements BaseController {
    @Autowired
    private ContextService contextService;
    @Autowired
    private ServiceDispatcher dispatcher;
    private int exportMaxSize;
    private Logger logger = LoggerFactory.getLogger(EntityBulkController.class);

    public EntityBulkController(int exportMaxSize) {
        this.exportMaxSize = exportMaxSize;
    }

    @PostMapping(value={"/bos/{boId}/entities/export"})
    @ResponseBody
    public CompletableFuture<Response<String>> conditionExport(@PathVariable String boId, @RequestParam(required=true, defaultValue="sync", value="exportType") String exportType, @RequestParam(required=false, value="v") String version, @RequestParam(required=false, value="appId") String appId, @RequestParam(required=false, value="skip", defaultValue="false") boolean skip, @RequestParam(required=false, value="pageCode") String pageCode, @RequestParam(required=false, value="type", defaultValue="xls") String exportFileType, @RequestBody ConditionQueryRequest condition) {
        String page = Optional.ofNullable(pageCode).orElse("PAGE");
        this.contextService.set((ContextService.ContextKey)SDKContextKey.PAGE, (Object)page);
        if (condition != null) {
            if (condition.getPageNo() == null) {
                condition.setPageNo(Integer.valueOf(1));
            }
            if (condition.getPageSize() == null || condition.getPageSize() > this.exportMaxSize) {
                condition.setPageSize(Integer.valueOf(this.exportMaxSize));
            }
            ConditionQueryRequestHelper.transformer((ConditionQueryRequest)condition);
        }
        HashMap<String, ExportCmdQuery> map = new HashMap<String, ExportCmdQuery>();
        map.put(boId, this.toExportCmdQuery(condition));
        CompletableFuture exportResult = (CompletableFuture)this.dispatcher.querySync((Object)new ConditionExportCmd(boId, version, exportType, exportFileType, appId, map, skip), BulkService.class, "conditionExport");
        return exportResult.thenApply(x -> {
            if (x.isRight()) {
                Response response = new Response();
                response.setResult(x.get());
                response.setMessage("OK");
                response.setCode("1");
                return response;
            }
            return Response.Error((String)((String)x.getLeft()));
        });
    }

    private ExportCmdQuery toExportCmdQuery(ConditionQueryRequest condition) {
        ExportCmdQuery exportQuery = new ExportCmdQuery();
        exportQuery.setMainQuery((ExpRel)ExpFactory.createFrom((ConditionQueryRequest)condition));
        exportQuery.setMainMapping(condition.getMapping());
        List toManyRelations = condition.getToManyRelations();
        HashMap subQuery = new HashMap();
        HashMap subNameMapping = new HashMap();
        Optional.ofNullable(toManyRelations).orElseGet(Collections::emptyList).stream().map(x -> {
            String code = x.getCode();
            String name = x.getName();
            NameMapping nm = new NameMapping();
            nm.setCode(code);
            nm.setText(name);
            ExpQuery expQuery = ExpFactory.createFrom((Conditions)x.getConditions(), (EntityItem)x.getEntity(), (List)x.getMapping(), (List)x.getSort(), null, null);
            List nameMapping = x.getMapping();
            ArrayList<NameMapping> newNameMapping = new ArrayList<NameMapping>(nameMapping);
            newNameMapping.add(nm);
            return Tuple.of((Object)code, (Object)expQuery, newNameMapping);
        }).forEach(x -> {
            subQuery.put(x._1, x._2);
            subNameMapping.put(x._1, x._3);
        });
        exportQuery.setSubMapping(subNameMapping);
        exportQuery.setSubQuery(subQuery);
        return exportQuery;
    }

    @PostMapping(value={"/bos/{boId}/entities/import/template"})
    @ResponseBody
    public CompletableFuture<Response<String>> importTemplateCustom(@PathVariable String boId, @RequestParam(required=false, value="v") String version, @RequestParam(required=false, value="pageCode") String pageCode, @RequestBody ImportTemplateRequest request) {
        List inputNameMapping = Optional.ofNullable(request.getFields()).orElseGet(Collections::emptyList);
        List relatedMappings = Optional.ofNullable(request.getToManyRelations()).orElseGet(Collections::emptyList);
        List nameMappings = inputNameMapping.stream().map(x -> {
            NameMapping mapping = new NameMapping();
            mapping.setCode(x.getCode());
            mapping.setText(x.getName());
            return mapping;
        }).collect(Collectors.toList());
        HashMap subMapping = new HashMap();
        relatedMappings.stream().forEach(x -> {
            List nameMapping = x.getFields().stream().map(y -> {
                NameMapping mapping = new NameMapping();
                mapping.setCode(y.getCode());
                mapping.setText(y.getName());
                return mapping;
            }).collect(Collectors.toList());
            List addOn = x.getRelationFields().stream().map(y -> {
                NameMapping mapping = new NameMapping();
                mapping.setCode(y.getCode());
                mapping.setText(y.getName());
                return mapping;
            }).collect(Collectors.toList());
            subMapping.put(x.getCode(), Tuple.of(nameMapping, addOn));
        });
        CompletableFuture importResult = (CompletableFuture)this.dispatcher.querySync((Object)new GetImportTemplateCmd(boId, version, nameMappings, subMapping), BulkService.class, "importTemplateCustom");
        return importResult.thenApply(x -> {
            if (x.isRight()) {
                Response response = new Response();
                response.setResult(x.get());
                response.setCode("1");
                return response;
            }
            return Response.Error((String)((String)x.getLeft()));
        });
    }

    @GetMapping(value={"/bos/{boId}/entities/import/template"})
    @ResponseBody
    public ResponseEntity<StreamingResponseBody> importTemplate(@PathVariable String boId, @RequestParam(required=false, value="v") String version, @RequestParam(required=false, value="pageCode") String pageCode) {
        String page = Optional.ofNullable(pageCode).orElse("PAGE");
        this.contextService.set((ContextService.ContextKey)SDKContextKey.PAGE, (Object)page);
        Either importTemplate = (Either)this.dispatcher.querySync((Object)new GetImportTemplateCmd(boId, version), BulkService.class, "importTemplate");
        if (importTemplate.isRight()) {
            InputStream finalInput = (InputStream)((Tuple2)importTemplate.get())._2();
            StreamingResponseBody responseBody = outputStream -> {
                StreamUtils.copy((InputStream)finalInput, (OutputStream)outputStream);
                outputStream.close();
            };
            String encodedName = (String)((Tuple2)importTemplate.get())._1();
            try {
                encodedName = URLEncoder.encode((String)((Tuple2)importTemplate.get())._1(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this.logger.error("{}", (Throwable)e);
            }
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=" + encodedName})).body((Object)responseBody);
        }
        this.logger.error("Download template failed {}", importTemplate.getLeft());
        return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
    }

    @PostMapping(value={"/bos/{boId}/entities/import"})
    @ResponseBody
    public ResponseEntity<Response<String>> importEntities(@PathVariable String boId, @RequestParam(required=false, value="v") String version, @RequestParam(required=false, value="pageCode") String pageCode, @RequestParam(required=false, value="useTrans", defaultValue="true") boolean useTrans, @RequestParam(required=false, value="useBatch", defaultValue="false") boolean useBatch, @RequestParam(required=false, value="timeout", defaultValue="300000") int timeout, @RequestParam(required=false, value="step", defaultValue="1000") int step, MultipartFile file) throws IOException {
        String page = Optional.ofNullable(pageCode).orElse("PAGE");
        this.contextService.set((ContextService.ContextKey)SDKContextKey.PAGE, (Object)page);
        String extension = FilenameUtils.getExtension((String)Optional.ofNullable(file.getOriginalFilename()).orElse(file.getName()));
        Either result = (Either)this.dispatcher.querySync((Object)new ImportCmd(boId, version, file.getInputStream(), extension, file.getOriginalFilename(), useTrans, timeout, step, useBatch), BulkService.class, "batchImport");
        return (ResponseEntity)Optional.ofNullable(result).orElseGet(() -> Either.left((Object)"\u6ca1\u6709\u8fd4\u56de\u503c")).map(x -> {
            Response rep = new Response();
            rep.setCode("1");
            rep.setResult((Object)String.valueOf(x));
            rep.setMessage("\u64cd\u4f5c\u6210\u529f");
            return ResponseEntity.ok((Object)rep);
        }).getOrElseGet(str -> {
            Response rep = new Response();
            rep.setCode("-1");
            rep.setMessage("\u64cd\u4f5c\u5931\u8d25:".concat((String)str));
            rep.setResult(str);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)rep);
        });
    }
}

