/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.service.export.impl;

import akka.NotUsed;
import akka.japi.function.Function;
import akka.stream.ActorMaterializer;
import akka.stream.IOResult;
import akka.stream.Materializer;
import akka.stream.javadsl.Sink;
import akka.stream.javadsl.Source;
import akka.util.ByteString;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.Relation;
import com.xforceplus.ultraman.oqsengine.sdk.event.EntityErrorExported;
import com.xforceplus.ultraman.oqsengine.sdk.event.EntityExported;
import com.xforceplus.ultraman.oqsengine.sdk.facade.ProfileFetcher;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpRel;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ClassifiedRecord;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.EntityExportService;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportCallBack;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportQuery;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportSchemaConfig;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportSink;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportSource;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportStringTransformer;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.FormattedString;
import com.xforceplus.ultraman.oqsengine.sdk.store.engine.IEntityClassEngine;
import com.xforceplus.ultraman.oqsengine.sdk.store.engine.IEntityClassGroup;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.NameMapping;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public abstract class AbstractEntityExportService
implements EntityExportService {
    private Logger logger = LoggerFactory.getLogger(EntityExportService.class);
    private final List<ExportSource> exportSourceList;
    private final ExportSink exportSink;
    private final ExportStringTransformer transformer;
    private final ActorMaterializer mat;
    private final ExportCallBack callback;
    @Autowired
    private IEntityClassEngine engine;
    @Autowired
    private ProfileFetcher profileFetcher;
    @Value(value="${xplat.oqsengine.sdk.export.auto-size:10000}")
    private int autoSize;
    private static final String SYNC = "sync";
    private static final String AUTO = "auto";

    public AbstractEntityExportService(List<ExportSource> exportSourceList, ExportSink exportSink, ExportStringTransformer transformer, ExportCallBack exportCallBack, ActorMaterializer mat) {
        this.exportSourceList = exportSourceList;
        this.exportSink = exportSink;
        this.callback = exportCallBack;
        this.transformer = transformer;
        this.mat = mat;
    }

    private boolean isMultiSchema(ExportQuery exportQuery) {
        Map<String, ExpRel> subQuery = exportQuery.getSubQuery();
        return subQuery != null && !subQuery.isEmpty();
    }

    private Source<ClassifiedRecord, NotUsed> genMultiSchema(List<ExportQuery> exportQueries, Map<String, Object> context) {
        Optional<Source> independentSourceOp = exportQueries.stream().map(exportQuery -> {
            Source<ClassifiedRecord, NotUsed> independentQuery = this.getIndependentSource((ExportQuery)exportQuery, context);
            return independentQuery;
        }).reduce(Source::concat);
        return independentSourceOp.orElseGet(Source::empty);
    }

    private Source<ClassifiedRecord, NotUsed> getIndependentSource(ExportQuery exportQuery, Map<String, Object> context) {
        IEntityClass entityClass = exportQuery.getEntityClass();
        boolean multiSchema = this.isMultiSchema(exportQuery);
        Optional<ExportSource> sourceOp = this.exportSourceList.stream().sorted().filter(x -> x.isAccept(entityClass, multiSchema, context)).findFirst();
        ExpRel mainQuery = exportQuery.getMainQuery();
        Map<String, ExpRel> subQuery = exportQuery.getSubQuery();
        return sourceOp.map(x -> x.source(null, entityClass, mainQuery, subQuery, context)).orElseGet(() -> {
            this.logger.warn("no suitable source found for {} when {}", (Object)entityClass.code(), (Object)context);
            return Source.empty();
        });
    }

    protected Source<ClassifiedRecord, NotUsed> prepareSource(List<ExportQuery> exportQueries, Map<String, Object> context) {
        Source<ClassifiedRecord, NotUsed> source;
        if (exportQueries.size() > 1) {
            if (this.isSupportMultiSchema()) {
                source = this.genMultiSchema(exportQueries, context);
            } else {
                ExportQuery exportQuery = exportQueries.get(0);
                source = this.getIndependentSource(exportQuery, context);
            }
        } else {
            ExportQuery exportQuery = exportQueries.get(0);
            source = this.getIndependentSource(exportQuery, context);
        }
        return source;
    }

    protected Sink<ByteString, CompletionStage<Tuple2<IOResult, String[]>>> prepareSink(String downloadName, String fileName) {
        return this.exportSink.getSink(this.generateFileType(), downloadName, fileName);
    }

    private List<IEntityClass> getMainEntityClassList(List<ExportQuery> exportQueries) {
        return exportQueries.stream().map(x -> x.getEntityClass()).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<Tuple2<String, IEntityClass>> getRelatedMainEntityClassList(List<ExportQuery> exportQueries, Map<String, Object> context) {
        return exportQueries.stream().flatMap(x -> {
            IEntityClass entityClass = x.getEntityClass();
            if (x.getSubQuery() != null) {
                Set<String> keys = x.getSubQuery().keySet();
                if (keys.isEmpty()) {
                    return Stream.of(Tuple.of((Object)entityClass.code(), (Object)entityClass));
                }
                IEntityClassGroup describe = this.engine.describe(entityClass, this.profileFetcher.getProfile(context));
                Stream<Tuple2> subStream = keys.stream().map(key -> {
                    Optional relatedEntityClass = describe.relatedEntityClass(key);
                    if (relatedEntityClass.isPresent()) {
                        return Tuple.of((Object)key, relatedEntityClass.get());
                    }
                    return null;
                }).filter(Objects::nonNull);
                return Stream.concat(Stream.of(Tuple.of((Object)entityClass.code(), (Object)entityClass)), subStream);
            }
            return Stream.of(Tuple.of((Object)entityClass.code(), (Object)entityClass));
        }).collect(Collectors.toList());
    }

    private Map<String, ExportSchemaConfig> getExportSchemaConfigMapping(List<ExportQuery> exportQueries) {
        HashMap<String, ExportSchemaConfig> mapping = new HashMap<String, ExportSchemaConfig>();
        exportQueries.forEach(x -> {
            String entityCode = x.getEntityClass().code();
            Map<String, List<NameMapping>> nameMapping = x.getNameMapping();
            List nameMappings = Optional.ofNullable(nameMapping.get(entityCode)).orElseGet(Collections::emptyList);
            Map<String, FormattedString> nMapping = nameMappings.stream().filter(nameItem -> nameItem.getText() != null && nameItem.getCode() != null).collect(Collectors.toMap(NameMapping::getCode, y -> new FormattedString(y.getText(), y.getFormat()), (a, b) -> a));
            HashMap<String, FormattedString> modifyMapping = new HashMap<String, FormattedString>(nMapping);
            modifyMapping.putIfAbsent(entityCode, new FormattedString(x.getEntityClass().name()));
            ExpRel mainQuery = x.getMainQuery();
            List<String> orderColumn = Optional.ofNullable(x.getNameMapping().get(entityCode)).orElseGet(Collections::emptyList).stream().map(NameMapping::getCode).collect(Collectors.toList());
            ExportSchemaConfig exportSchemaConfig = new ExportSchemaConfig();
            exportSchemaConfig.setNameMapping(modifyMapping);
            exportSchemaConfig.setOrderedColumn(orderColumn);
            mapping.put(entityCode, exportSchemaConfig);
            if (x.getSubQuery() != null) {
                x.getSubQuery().forEach((key, value) -> {
                    List subNameMappings = Optional.ofNullable(nameMapping.get(key)).orElseGet(Collections::emptyList);
                    Map<String, FormattedString> subMapping = subNameMappings.stream().filter(subItem -> subItem.getText() != null && subItem.getCode() != null).collect(Collectors.toMap(NameMapping::getCode, y -> new FormattedString(y.getText(), y.getFormat()), (a, b) -> a));
                    HashMap<String, FormattedString> subModifyMapping = new HashMap<String, FormattedString>(subMapping);
                    Optional<Relation> first = x.getEntityClass().relations().stream().filter(rel -> rel.getName().equalsIgnoreCase((String)key)).findFirst();
                    first.ifPresent(relation -> subModifyMapping.putIfAbsent((String)key, new FormattedString(relation.getName())));
                    ExportSchemaConfig sub = new ExportSchemaConfig();
                    sub.setNameMapping(subModifyMapping);
                    sub.setOrderedColumn(value.getOrderedProjectNames());
                    mapping.put((String)key, sub);
                });
            }
        });
        return mapping;
    }

    protected String getStringValue(IEntityClass entityClass, IEntityField field, Object value, Map<String, Object> context, Map<String, FormattedString> nameMapping) {
        FormattedString formattedString = nameMapping.get(field.name());
        return this.transformer.toString(entityClass, field, value, context, formattedString);
    }

    protected abstract Source<ByteString, ?> toByteStringSource(List<Tuple2<String, IEntityClass>> var1, Source<ClassifiedRecord, NotUsed> var2, Map<String, ExportSchemaConfig> var3, boolean var4, Map<String, Object> var5);

    @Override
    public CompletableFuture<Either<String, String>> export(List<ExportQuery> exportQueries, String token, String fileName, String exportType, boolean skipTransformer, Map<String, Object> context, Map<String, Object> notifyContext) {
        if (exportQueries == null || exportQueries.isEmpty()) {
            return CompletableFuture.completedFuture(Either.left((Object)"Empty Query for Export"));
        }
        List<Tuple2<String, IEntityClass>> entityClassWithSubList = this.getRelatedMainEntityClassList(exportQueries, context);
        List<IEntityClass> entityClassList = this.getMainEntityClassList(exportQueries);
        CompletableFuture<Either<String, String>> countFuture = new CompletableFuture<Either<String, String>>();
        try {
            Source source = this.prepareSource(exportQueries, context);
            Sink<ByteString, CompletionStage<Tuple2<IOResult, String[]>>> sink = this.prepareSink(token, fileName);
            AtomicInteger counter = new AtomicInteger(0);
            source = source.map((Function & Serializable)x -> {
                if (counter.get() <= this.autoSize) {
                    counter.incrementAndGet();
                } else {
                    countFuture.complete(Either.right((Object)"\u8bf7\u6c42\u8f6c\u4e3a\u5f02\u6b65"));
                }
                return x;
            });
            Source<ByteString, ?> byteStringSource = this.toByteStringSource(entityClassWithSubList, (Source<ClassifiedRecord, NotUsed>)source, this.getExportSchemaConfigMapping(exportQueries), skipTransformer, context);
            CompletionStage syncCompleteResult = ((CompletableFuture)((CompletionStage)byteStringSource.runWith(sink, (Materializer)this.mat)).toCompletableFuture().thenApply(x -> {
                String downloadUrl = this.exportSink.getDownloadUrl(this.generateFileType(), (String[])x._2());
                if (this.callback != null) {
                    boolean done = countFuture.isDone();
                    this.callback.onSuccess(() -> new EntityExported(entityClassList, downloadUrl, fileName, exportType, context, notifyContext, done));
                }
                return Either.right((Object)downloadUrl);
            })).exceptionally(th -> {
                if (this.callback != null) {
                    this.callback.onFailure(() -> new EntityErrorExported(token, th.getMessage(), context, notifyContext));
                }
                return Either.left((Object)th.getMessage());
            });
            ((CompletableFuture)syncCompleteResult).thenApply(countFuture::complete);
            if (SYNC.equalsIgnoreCase(exportType)) {
                return syncCompleteResult;
            }
            if (AUTO.equalsIgnoreCase(exportType)) {
                return countFuture;
            }
            return CompletableFuture.completedFuture(Either.right((Object)"\u8bf7\u6c42\u5b8c\u6210"));
        }
        catch (Exception ex) {
            this.logger.error("{}", (Throwable)ex);
            return CompletableFuture.completedFuture(Either.left((Object)ex.getMessage()));
        }
    }
}

