/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.service.export.impl;

import akka.japi.function.Creator;
import akka.stream.ActorMaterializer;
import akka.stream.Materializer;
import akka.stream.javadsl.Source;
import akka.stream.javadsl.StreamConverters;
import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.sdk.facade.EntityFacade;
import com.xforceplus.ultraman.oqsengine.sdk.facade.result.CreateOneResult;
import com.xforceplus.ultraman.oqsengine.sdk.facade.result.ResultStatus;
import com.xforceplus.ultraman.oqsengine.sdk.service.DictService;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportSink;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ImportService;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.PostImportAware;
import com.xforceplus.ultraman.oqsengine.sdk.store.engine.IEntityClassGroup;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.DictItem;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.NameMapping;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import io.vavr.control.Validation;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ExcelImportService
implements ImportService {
    private Logger logger = LoggerFactory.getLogger(ImportService.class);
    private EntityFacade entityFacade;
    private ContextService contextService;
    private ExecutorService importThreadPool;
    private ActorMaterializer mat;
    private int defaultStep = 1000;
    @Autowired
    List<PostImportAware> postImportAwareList;
    @Autowired
    private DictService dictService;
    private final String MULTI_ENUM = "\u8bf7\u9009\u62e9\u4e00\u9879\u6216\u8005\u591a\u9879, \u4ee5,\u53f7\u9694\u5f00:\n\n%s\n\n \u5b58\u5728\u591a\u4e2a, \u8bf7\u4ee5,\u53f7\u9694\u5f00";
    private final String ENUM = "\u8bf7\u9009\u62e9\u4e00\u9879:\n\n%s\n\n";
    private ExportSink sink;

    public ExcelImportService(EntityFacade entityFacade, ContextService contextService, ExportSink sink, ActorMaterializer mat, ExecutorService importThreadPool) {
        this.entityFacade = entityFacade;
        this.contextService = contextService;
        this.importThreadPool = importThreadPool;
        this.sink = sink;
        this.mat = mat;
    }

    @Override
    public String fileType() {
        return "xlsx";
    }

    @Override
    public String fileName(IEntityClass entityClass) {
        return entityClass.name() + "-template";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getTemplateInputStream(IEntityClassGroup reader, boolean skipSystem) {
        IEntityClass entityClass = reader.getEntityClass();
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet mainSheet = workbook.createSheet(entityClass.name());
        XSSFRow headerRow = mainSheet.createRow(0);
        XSSFCellStyle cellStyle = workbook.createCellStyle();
        AtomicInteger index = new AtomicInteger(0);
        cellStyle.setFillForegroundColor(IndexedColors.LIGHT_ORANGE.getIndex());
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        short dataFormatIndex = workbook.createDataFormat().getFormat("yyyy-m-dd h:mm:ss");
        XSSFCellStyle dateStyle = workbook.createCellStyle();
        dateStyle.setDataFormat(dataFormatIndex);
        reader.getAllFields().stream().filter(x -> !skipSystem || x.config() == null || !x.config().isSystem()).forEach(arg_0 -> this.lambda$getTemplateInputStream$1(index, headerRow, (CellStyle)cellStyle, mainSheet, (CellStyle)dateStyle, workbook, arg_0));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            workbook.write((OutputStream)byteArrayOutputStream);
        }
        catch (IOException iOException) {}
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    private List<IEntityField> getOrderedFieldsFromNameMapping(List<NameMapping> mappingList, List<IEntityField> fields) {
        if (mappingList == null || mappingList.isEmpty()) {
            return fields;
        }
        return mappingList.stream().map(x -> {
            Optional<IEntityField> first = fields.stream().filter(field -> field.name().equals(x.getCode())).findFirst();
            return first;
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCustomTemplate(IEntityClassGroup reader, List<NameMapping> mappingList, Map<String, Tuple2<List<NameMapping>, List<NameMapping>>> subMapping) {
        IEntityClass entityClass = reader.getEntityClass();
        XSSFWorkbook workbook = new XSSFWorkbook();
        Map<String, String> nameMapping = mappingList.stream().collect(Collectors.toMap(x -> x.getCode(), x -> x.getText(), (a, b) -> a));
        this.renderSheet(workbook, entityClass.name(), this.getOrderedFieldsFromNameMapping(mappingList, reader.getAllFields()), nameMapping, null);
        subMapping.forEach((code, subRelMapping) -> {
            List relationMapping = (List)subRelMapping._2();
            List mapping = (List)subRelMapping._1();
            Map<String, String> subNameMapping = mapping.stream().collect(Collectors.toMap(x -> x.getCode(), x -> x.getText(), (a, b) -> a));
            Optional relatedEntityClassOp = reader.relatedEntityClass(code);
            if (relatedEntityClassOp.isPresent()) {
                IEntityClass relatedEntityClass = (IEntityClass)relatedEntityClassOp.get();
                IEntityClassGroup relatedGroup = this.entityFacade.getReader(relatedEntityClass, this.contextService.getAll());
                this.renderSheet(workbook, (String)code, this.getOrderedFieldsFromNameMapping(mapping, relatedGroup.getAllFields()), subNameMapping, relationMapping);
            }
        });
        String fileName = this.fileName(reader.getEntityClass());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        String uuid = UUID.randomUUID().toString();
        try {
            workbook.write((OutputStream)byteArrayOutputStream);
        }
        catch (IOException e) {
            this.logger.error("{}", (Throwable)e);
        }
        Source source = StreamConverters.fromInputStream((Creator & Serializable)() -> new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        Tuple2 xlsx = (Tuple2)((CompletionStage)source.runWith(this.sink.getSink("xlsx", uuid), (Materializer)this.mat)).toCompletableFuture().join();
        return this.sink.getDownloadUrl("xlsx", (String[])xlsx._2);
    }

    private void renderSheet(XSSFWorkbook workbook, String name, List<IEntityField> fields, Map<String, String> nameMapping, List<NameMapping> additionalCell) {
        XSSFSheet mainSheet = workbook.createSheet(name);
        XSSFRow headerRow = mainSheet.createRow(0);
        XSSFCellStyle cellStyle = workbook.createCellStyle();
        AtomicInteger index = new AtomicInteger(0);
        cellStyle.setFillForegroundColor(IndexedColors.LIGHT_ORANGE.getIndex());
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        short dataFormatIndex = workbook.createDataFormat().getFormat("yyyy-m-dd h:mm:ss");
        XSSFCellStyle dateStyle = workbook.createCellStyle();
        dateStyle.setDataFormat(dataFormatIndex);
        short stringFormatIndex = workbook.createDataFormat().getFormat("@");
        XSSFCellStyle stringStyle = workbook.createCellStyle();
        stringStyle.setDataFormat(stringFormatIndex);
        if (additionalCell != null && !additionalCell.isEmpty()) {
            additionalCell.forEach(arg_0 -> this.lambda$renderSheet$11(index, headerRow, workbook, mainSheet, (CellStyle)cellStyle, arg_0));
        }
        fields.stream().filter(x -> nameMapping.containsKey(x.name())).forEach(arg_0 -> this.lambda$renderSheet$13(index, headerRow, nameMapping, (CellStyle)cellStyle, mainSheet, (CellStyle)dateStyle, workbook, (CellStyle)stringStyle, arg_0));
    }

    public void addComment(Workbook workbook, Sheet sheet, Cell cell, String commentText) {
        CreationHelper factory = workbook.getCreationHelper();
        ClientAnchor anchor = factory.createClientAnchor();
        anchor.setCol1(cell.getColumnIndex() + 1);
        anchor.setCol2(cell.getColumnIndex() + 3);
        anchor.setRow1(cell.getRowIndex() + 1);
        anchor.setRow2(cell.getRowIndex() + 5);
        Drawing drawing = sheet.createDrawingPatriarch();
        Comment comment = drawing.createCellComment(anchor);
        comment.setString(factory.createRichTextString(commentText));
        cell.setCellComment(comment);
    }

    @Override
    public InputStream getCustomTemplateInputStream(String uuid) {
        return this.sink.getInputStream(uuid, this.fileType());
    }

    private Map<String, Long> getIndexMapping(Map<String, Object> context, String code) {
        Object index = context.get("index");
        if (index != null) {
            Map indexMapping = (Map)index;
            return Optional.ofNullable(indexMapping.get(code)).orElseGet(Collections::emptyMap);
        }
        return Collections.emptyMap();
    }

    private void insertRelated(IEntityClass entityClass, XSSFSheet sheet, Map<String, Object> contextMap) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Row headerRow = null;
        boolean isFirstRow = true;
        int size = 0;
        Iterator rowIterator = sheet.rowIterator();
        String sheetName = sheet.getSheetName();
        while (rowIterator.hasNext()) {
            Row row = (Row)rowIterator.next();
            if (isFirstRow) {
                headerRow = row;
                isFirstRow = false;
                size = headerRow.getLastCellNum();
                continue;
            }
            map.clear();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < size; ++i) {
                Cell cell = row.getCell(i);
                if (cell == null) continue;
                Object rawValue = this.getRawValue(cell);
                Cell headerCell = headerRow.getCell(i);
                if (headerCell.getCellComment() != null) {
                    if (sb.length() > 0) {
                        sb.append("%^%");
                    }
                    sb.append(rawValue);
                }
                map.put(this.getKeyFromHeader(headerCell.getStringCellValue()), cell == null ? null : this.getRawValue(cell));
            }
            String s = sb.toString();
            Map<String, Long> indexMapping = this.getIndexMapping(contextMap, sheetName);
            Long related = indexMapping.get(s);
            if (related == null) {
                this.logger.warn("{} has no related value, body: {}", (Object)sheetName, map);
            } else {
                map.put(sheetName.concat(".id"), related);
            }
            Optional<Validation> first = this.postImportAwareList.stream().map(x -> x.doPostFilter(entityClass, map, contextMap)).filter(Validation::isInvalid).findFirst();
            if (!first.isPresent()) {
                Either either = (Either)((CompletableFuture)this.entityFacade.create(entityClass, map, contextMap).toCompletableFuture().thenApplyAsync(x -> x, (Executor)this.importThreadPool)).join();
                continue;
            }
            this.logger.error("{}, {}, {} is not execute", new Object[]{entityClass.code(), map, contextMap});
        }
    }

    private void insertMain(IEntityClass entityClass, XSSFSheet sheet, List<String> relatedCode, Map<String, Object> contextMap) {
        Iterator rowIterator = sheet.rowIterator();
        HashMap<String, Object> map = new HashMap<String, Object>();
        Row headerRow = null;
        boolean isFirstRow = true;
        int size = 0;
        while (rowIterator.hasNext()) {
            Either insertResult;
            Row row = (Row)rowIterator.next();
            if (isFirstRow) {
                headerRow = row;
                isFirstRow = false;
                size = headerRow.getLastCellNum();
                continue;
            }
            map.clear();
            for (int i = 0; i < size; ++i) {
                Cell cell = row.getCell(i);
                map.put(this.getKeyFromHeader(headerRow.getCell(i).getStringCellValue()), cell == null ? null : this.getRawValue(cell));
            }
            Optional<Validation> first = this.postImportAwareList.stream().map(x -> x.doPostFilter(entityClass, map, contextMap)).filter(Validation::isInvalid).findFirst();
            if (!first.isPresent()) {
                insertResult = (Either)((CompletableFuture)this.entityFacade.create(entityClass, map, contextMap).toCompletableFuture().thenApplyAsync(x -> x, (Executor)this.importThreadPool)).join();
            } else {
                Validation validation = first.get();
                insertResult = Either.left((Object)CreateOneResult.from((Throwable)new RuntimeException((String)validation.getError())));
            }
            List<String> finalRelatedCodeList = relatedCode;
            insertResult.peek(x -> {
                for (String related : finalRelatedCodeList) {
                    this.buildIndex(related, contextMap, (Map<String, Object>)map, (long)x);
                }
            }).peekLeft(cor -> {
                if (cor.getOriginCause() == ResultStatus.OriginStatus.HALF_SUCCESS) {
                    this.logger.warn("Half success detect {}", (Object)cor.getErrorMap());
                    for (String related : finalRelatedCodeList) {
                        this.buildIndex(related, contextMap, map, cor.getId());
                    }
                } else {
                    throw new RuntimeException(cor.getMessage());
                }
            });
        }
    }

    private void buildIndex(String code, Map<String, Object> contextMap, Map<String, Object> body, long id) {
        Object index = contextMap.get("index");
        Object codeMapping = contextMap.get(code);
        if (index != null && codeMapping != null) {
            Map indexMapping = (Map)index;
            List relatedCodeList = (List)codeMapping;
            HashMap<String, Long> indexCodeRelatedMapping = (HashMap<String, Long>)indexMapping.get(code);
            if (indexCodeRelatedMapping == null) {
                indexCodeRelatedMapping = new HashMap<String, Long>();
            }
            indexMapping.put(code, indexCodeRelatedMapping);
            String collect = relatedCodeList.stream().map(x -> body.get(x)).filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining("%^%"));
            Long prev = indexCodeRelatedMapping.put(collect, id);
            if (prev != null) {
                throw new RuntimeException("has same related value " + relatedCodeList + ":" + collect);
            }
        }
    }

    private boolean isValid(String code, IEntityClassGroup group) {
        Optional column = group.column(code);
        return column.isPresent();
    }

    private void prepareHeader(XSSFSheet sheet, Map<String, Object> contextMap, IEntityClassGroup entityClassGroup) {
        int firstRowNum = sheet.getFirstRowNum();
        String sheetName = sheet.getSheetName();
        if (firstRowNum >= 0) {
            XSSFRow row = sheet.getRow(firstRowNum);
            Short size = row.getLastCellNum();
            for (int i = 0; i < size; ++i) {
                XSSFCell cell = row.getCell(i);
                Comment cellComment = cell.getCellComment();
                if (cellComment == null) continue;
                Optional<String> codeOp = Optional.ofNullable(cellComment.getString()).map(RichTextString::getString);
                codeOp.filter(code -> this.isValid((String)code, entityClassGroup)).ifPresent(code -> contextMap.compute(sheetName, (k, v) -> {
                    if (v == null) {
                        v = new ArrayList();
                    }
                    ((List)v).add(code);
                    return v;
                }));
            }
        } else {
            throw new RuntimeException("do not has row");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consume(IEntityClassGroup entityClassGroup, InputStream inputStream) throws IOException {
        XSSFWorkbook xssfwb = new XSSFWorkbook(inputStream);
        IEntityClass entityClass = entityClassGroup.getEntityClass();
        int numberOfSheets = xssfwb.getNumberOfSheets();
        try {
            Map contextMap = Optional.ofNullable(this.contextService).map(ContextService::getAll).orElseGet(Collections::emptyMap);
            contextMap.put("index", new HashMap());
            if (numberOfSheets > 1) {
                XSSFSheet mainSheet = xssfwb.getSheetAt(0);
                if (mainSheet != null) {
                    XSSFSheet sheetAt;
                    int i;
                    ArrayList<String> relatedCode = new ArrayList<String>();
                    for (i = 1; i < numberOfSheets; ++i) {
                        sheetAt = xssfwb.getSheetAt(i);
                        this.prepareHeader(sheetAt, contextMap, entityClassGroup);
                        relatedCode.add(sheetAt.getSheetName());
                    }
                    this.insertMain(entityClass, mainSheet, relatedCode, contextMap);
                    for (i = 1; i < numberOfSheets; ++i) {
                        sheetAt = xssfwb.getSheetAt(i);
                        String name = sheetAt.getSheetName();
                        Optional iEntityClass = entityClassGroup.relatedEntityClass(name);
                        iEntityClass.ifPresent(relatedEntityClass -> this.insertRelated((IEntityClass)relatedEntityClass, sheetAt, contextMap));
                    }
                }
            } else {
                XSSFSheet sheetAt = xssfwb.getSheetAt(0);
                HashMap<String, Object> map = new HashMap<String, Object>();
                Row headerRow = null;
                boolean isFirstRow = true;
                Short size = 0;
                if (sheetAt != null) {
                    Iterator rowIterator = sheetAt.rowIterator();
                    while (rowIterator.hasNext()) {
                        Row row = (Row)rowIterator.next();
                        if (isFirstRow) {
                            headerRow = row;
                            isFirstRow = false;
                            size = headerRow.getLastCellNum();
                            continue;
                        }
                        map.clear();
                        for (int i = 0; i < size; ++i) {
                            Cell cell = row.getCell(i);
                            map.put(this.getKeyFromHeader(headerRow.getCell(i).getStringCellValue()), cell == null ? null : this.getRawValue(cell));
                        }
                        Optional<Validation> first = this.postImportAwareList.stream().map(x -> x.doPostFilter(entityClass, map, contextMap)).filter(Validation::isInvalid).findFirst();
                        if (!first.isPresent()) {
                            ((CompletableFuture)this.entityFacade.create(entityClass, map, contextMap).toCompletableFuture().thenApplyAsync(x -> x, (Executor)this.importThreadPool)).join();
                            continue;
                        }
                        this.logger.error("{}, {}, {} is not execute", new Object[]{entityClass.code(), map, contextMap});
                    }
                }
            }
        }
        finally {
            xssfwb.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consumeStep(IEntityClassGroup entityClassGroup, boolean useBatch, int timeout, int step, InputStream inputStream) throws IOException {
        if (step <= 0) {
            step = this.defaultStep;
        }
        XSSFWorkbook xssfwb = new XSSFWorkbook(inputStream);
        IEntityClass entityClass = entityClassGroup.getEntityClass();
        int numberOfSheets = xssfwb.getNumberOfSheets();
        try {
            Map contextMap = Optional.ofNullable(this.contextService).map(ContextService::getAll).orElseGet(Collections::emptyMap);
            contextMap.put("index", new HashMap());
            if (numberOfSheets > 1) {
                XSSFSheet mainSheet = xssfwb.getSheetAt(0);
                if (mainSheet != null) {
                    XSSFSheet sheetAt;
                    int i;
                    ArrayList<String> relatedCode = new ArrayList<String>();
                    for (i = 1; i < numberOfSheets; ++i) {
                        sheetAt = xssfwb.getSheetAt(i);
                        this.prepareHeader(sheetAt, contextMap, entityClassGroup);
                        relatedCode.add(sheetAt.getSheetName());
                    }
                    this.insertMain(entityClass, mainSheet, relatedCode, contextMap);
                    for (i = 1; i < numberOfSheets; ++i) {
                        sheetAt = xssfwb.getSheetAt(i);
                        String name = sheetAt.getSheetName();
                        Optional iEntityClass = entityClassGroup.relatedEntityClass(name);
                        iEntityClass.ifPresent(relatedEntityClass -> this.insertRelated((IEntityClass)relatedEntityClass, sheetAt, contextMap));
                    }
                }
            } else {
                XSSFSheet sheetAt = xssfwb.getSheetAt(0);
                HashMap<String, Object> map = new HashMap<String, Object>();
                Row headerRow = null;
                boolean isFirstRow = true;
                Short size = 0;
                int count = 0;
                if (sheetAt != null) {
                    Iterator rowIterator = sheetAt.rowIterator();
                    while (rowIterator.hasNext()) {
                        Optional<Validation> first;
                        Row row = (Row)rowIterator.next();
                        if (isFirstRow) {
                            headerRow = row;
                            isFirstRow = false;
                            size = headerRow.getLastCellNum();
                            continue;
                        }
                        map.clear();
                        for (int i = 0; i < size; ++i) {
                            Cell cell = row.getCell(i);
                            map.put(this.getKeyFromHeader(headerRow.getCell(i).getStringCellValue()), cell == null ? null : this.getRawValue(cell));
                        }
                        if (count % step == 0) {
                            String transKey = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TRANSACTION_KEY);
                            count = 0;
                        }
                        if (!(first = this.postImportAwareList.stream().map(x -> x.doPostFilter(entityClass, map, contextMap)).filter(Validation::isInvalid).findFirst()).isPresent()) {
                            ((CompletableFuture)this.entityFacade.create(entityClass, map, contextMap).toCompletableFuture().thenApplyAsync(x -> x, (Executor)this.importThreadPool)).join();
                            ++count;
                            continue;
                        }
                        this.logger.error("{}, {}, {} is not execute", new Object[]{entityClass.code(), map, contextMap});
                    }
                    String transKey = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TRANSACTION_KEY);
                    if (transKey != null) {
                        // empty if block
                    }
                }
            }
        }
        finally {
            xssfwb.close();
        }
    }

    private Object getRawValue(Cell cell) {
        Object rawValue = null;
        if (cell.getCellType() == CellType.FORMULA) {
            switch (cell.getCachedFormulaResultType()) {
                case BOOLEAN: {
                    rawValue = cell.getBooleanCellValue();
                    break;
                }
                case NUMERIC: {
                    rawValue = BigDecimal.valueOf(cell.getNumericCellValue());
                    break;
                }
                case STRING: {
                    rawValue = cell.getStringCellValue();
                    break;
                }
            }
        } else {
            rawValue = cell.getCellType() == CellType.BOOLEAN ? Boolean.valueOf(cell.getBooleanCellValue()) : (cell.getCellType() == CellType.NUMERIC ? (DateUtil.isCellDateFormatted((Cell)cell) ? cell.getLocalDateTimeCellValue() : BigDecimal.valueOf(cell.getNumericCellValue())) : (cell.getCellType() == CellType.STRING ? cell.getStringCellValue() : null));
        }
        return rawValue;
    }

    private String getKeyFromHeader(String headerPart) {
        int start = headerPart.indexOf("[");
        int end = headerPart.indexOf("]");
        if (start < 0 || end < 0) {
            return headerPart;
        }
        return headerPart.substring(start + 1, end);
    }

    private /* synthetic */ void lambda$renderSheet$13(AtomicInteger index, XSSFRow headerRow, Map nameMapping, CellStyle cellStyle, XSSFSheet mainSheet, CellStyle dateStyle, XSSFWorkbook workbook, CellStyle stringStyle, IEntityField field) {
        boolean isRequired = false;
        boolean isDatetime = false;
        boolean isEnum = false;
        boolean isMultiEnum = false;
        boolean isString = false;
        if (field.config() != null) {
            isRequired = field.config().isRequired();
        }
        if (field.type() == FieldType.DATETIME) {
            isDatetime = true;
        } else if (field.type() == FieldType.ENUM) {
            isEnum = true;
        } else if (field.type() == FieldType.STRINGS && StringUtils.isNotEmpty((String)field.dictId())) {
            isMultiEnum = true;
        } else if (field.type() == FieldType.STRING || field.type() == FieldType.STRINGS) {
            isString = true;
        }
        int currentIndex = index.getAndIncrement();
        XSSFCell cell = headerRow.createCell(currentIndex);
        String title = Optional.ofNullable(nameMapping.get(field.name())).orElse(field.cnName());
        cell.setCellValue(title + "[" + field.name() + "]");
        if (isRequired) {
            cell.setCellStyle(cellStyle);
        }
        if (isDatetime) {
            mainSheet.setDefaultColumnStyle(currentIndex, dateStyle);
        }
        if (isEnum || isMultiEnum) {
            String dictId = field.dictId();
            List dictItemsByCode = this.dictService.findDictItems(dictId, "");
            String values = dictItemsByCode.stream().map(DictItem::getText).collect(Collectors.joining("\n"));
            String comment = isMultiEnum ? String.format("\u8bf7\u9009\u62e9\u4e00\u9879\u6216\u8005\u591a\u9879, \u4ee5,\u53f7\u9694\u5f00:\n\n%s\n\n \u5b58\u5728\u591a\u4e2a, \u8bf7\u4ee5,\u53f7\u9694\u5f00", values) : String.format("\u8bf7\u9009\u62e9\u4e00\u9879:\n\n%s\n\n", values);
            this.addComment((Workbook)workbook, (Sheet)mainSheet, (Cell)cell, comment);
        }
        if (isString) {
            mainSheet.setDefaultColumnStyle(currentIndex, stringStyle);
        }
    }

    private /* synthetic */ void lambda$renderSheet$11(AtomicInteger index, XSSFRow headerRow, XSSFWorkbook workbook, XSSFSheet mainSheet, CellStyle cellStyle, NameMapping x) {
        int currentIndex = index.getAndIncrement();
        XSSFCell cell = headerRow.createCell(currentIndex);
        String cellName = x.getText();
        String cellCode = x.getCode();
        this.addComment((Workbook)workbook, (Sheet)mainSheet, (Cell)cell, cellCode);
        cell.setCellValue(cellName + "[" + cellCode + "]");
        cell.setCellStyle(cellStyle);
    }

    private /* synthetic */ void lambda$getTemplateInputStream$1(AtomicInteger index, XSSFRow headerRow, CellStyle cellStyle, XSSFSheet mainSheet, CellStyle dateStyle, XSSFWorkbook workbook, IEntityField field) {
        boolean isRequired = false;
        boolean isDatetime = false;
        boolean isEnum = false;
        boolean isMultiEnum = false;
        if (field.config() != null) {
            isRequired = field.config().isRequired();
        }
        if (field.type() == FieldType.DATETIME) {
            isDatetime = true;
        } else if (field.type() == FieldType.ENUM) {
            isEnum = true;
        } else if (field.type() == FieldType.STRINGS && StringUtils.isNotEmpty((String)field.dictId())) {
            isMultiEnum = true;
        }
        int currentIndex = index.getAndIncrement();
        XSSFCell cell = headerRow.createCell(currentIndex);
        cell.setCellValue(Optional.ofNullable(field.cnName()).orElse(field.name()) + "[" + field.name() + "]");
        if (isRequired) {
            cell.setCellStyle(cellStyle);
        }
        if (isDatetime) {
            mainSheet.setDefaultColumnStyle(currentIndex, dateStyle);
        }
        if (isEnum || isMultiEnum) {
            String dictId = field.dictId();
            List dictItemsByCode = this.dictService.findDictItems(dictId, "");
            String values = dictItemsByCode.stream().map(DictItem::getText).collect(Collectors.joining("\n"));
            String comment = isMultiEnum ? String.format("\u8bf7\u9009\u62e9\u4e00\u9879\u6216\u8005\u591a\u9879, \u4ee5,\u53f7\u9694\u5f00:\n\n%s\n\n \u5b58\u5728\u591a\u4e2a, \u8bf7\u4ee5,\u53f7\u9694\u5f00", values) : String.format("\u8bf7\u9009\u62e9\u4e00\u9879:\n\n%s\n\n", values);
            this.addComment((Workbook)workbook, (Sheet)mainSheet, (Cell)cell, comment);
        }
    }
}

