/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.service.export.impl;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportCustomFieldToString;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportStringTransformer;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.FormattedString;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportStringTransformerImpl
implements ExportStringTransformer {
    private List<ExportCustomFieldToString> customTransformers;
    private ExportCustomFieldToString exportCustomFieldToString;
    private Logger logger = LoggerFactory.getLogger(ExportStringTransformer.class);

    public ExportStringTransformerImpl(List<ExportCustomFieldToString> customTransformers, ExportCustomFieldToString defaultExportCustomFieldToString) {
        this.customTransformers = customTransformers;
        this.exportCustomFieldToString = defaultExportCustomFieldToString;
    }

    @Override
    public String toString(IEntityClass entityClass, IEntityField entityField, Object value, Map<String, Object> context, FormattedString formattedString) {
        String safeSourceValue = Optional.ofNullable(value).map(Object::toString).orElse("");
        String retStr = this.customTransformers.stream().filter(x -> !x.isDefault() && x.isSupport(entityClass, entityField)).findFirst().orElseGet(() -> {
            this.logger.debug("transform {}:{} with default", (Object)entityClass.code(), (Object)entityField.name());
            return this.exportCustomFieldToString;
        }).safeGetString(entityClass, entityField, safeSourceValue, context, formattedString).orElse("");
        return retStr;
    }
}

