/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.service.export.impl;

import akka.NotUsed;
import akka.japi.function.Function;
import akka.stream.Graph;
import akka.stream.javadsl.Source;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldLikeRelationType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.Relation;
import com.xforceplus.ultraman.oqsengine.pojo.reader.record.Record;
import com.xforceplus.ultraman.oqsengine.sdk.facade.EntityFacade;
import com.xforceplus.ultraman.oqsengine.sdk.facade.ProfileFetcher;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpCondition;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpField;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpNode;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpOperator;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpQuery;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpRel;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpValue;
import com.xforceplus.ultraman.oqsengine.sdk.service.core.ExecutionConfig;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ClassifiedRecord;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportSource;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.config.ExportConfig;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.impl.SequenceExportSource;
import com.xforceplus.ultraman.oqsengine.sdk.store.engine.IEntityClassGroup;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NestedExportSource
implements ExportSource {
    private Logger logger = LoggerFactory.getLogger(NestedExportSource.class);
    private final int concurrent;
    private final int step;
    private final int maxRetryTimes;
    private final EntityFacade entityService;
    private final ContextService contextService;
    private final ProfileFetcher profileFetcher;
    private final ExecutionConfig config;
    private final List<SequenceExportSource> exportSourceList;

    public NestedExportSource(List<SequenceExportSource> exportSourceList, EntityFacade entityService, ProfileFetcher profileFetcher, ExportConfig exportConfig, ContextService contextService, ExecutionConfig config) {
        this.concurrent = exportConfig.getSubStreamSize();
        this.step = exportConfig.getStepSize();
        this.maxRetryTimes = exportConfig.getMaxRetry();
        this.entityService = entityService;
        this.contextService = contextService;
        this.config = config;
        this.exportSourceList = exportSourceList;
        this.profileFetcher = profileFetcher;
    }

    protected String generateRelatedFieldName(String code, String fieldName) {
        StringBuffer sb = new StringBuffer();
        sb.append(code);
        sb.append(".");
        sb.append(fieldName);
        return sb.toString();
    }

    public int getConcurrent() {
        return this.concurrent;
    }

    public int getStep() {
        return this.step;
    }

    public int getMaxRetryTimes() {
        return this.maxRetryTimes;
    }

    public EntityFacade getEntityService() {
        return this.entityService;
    }

    public ContextService getContextService() {
        return this.contextService;
    }

    public ProfileFetcher getProfileFetcher() {
        return this.profileFetcher;
    }

    public ExecutionConfig getConfig() {
        return this.config;
    }

    public List<SequenceExportSource> getExportSourceList() {
        return this.exportSourceList;
    }

    protected ExpRel getRelatedRelQuery(String relationCode, Record record, ExpRel rel) {
        ExpQuery idQuery = new ExpQuery().project(rel.getProjects()).filters((ExpNode)ExpCondition.call((ExpOperator)ExpOperator.EQUALS, (ExpNode)ExpField.field((String)this.generateRelatedFieldName(relationCode, "id")), (List)ExpValue.from((Object)record.getId())));
        return rel.mergeAnd((ExpRel)idQuery);
    }

    @Override
    public boolean isAccept(IEntityClass entityClass, boolean isMultiSchema, Map<String, Object> context) {
        return isMultiSchema;
    }

    protected Source<ClassifiedRecord, NotUsed> getDependentSource(String classifier, IEntityClass entityClass, ExpRel query, Map<String, Object> context) {
        Optional<SequenceExportSource> sourceOp = this.exportSourceList.stream().sorted().filter(x -> x.isAccept(entityClass, false, context)).findFirst();
        return sourceOp.map(x -> x.source(classifier, entityClass, query, null, context)).orElseGet(() -> {
            this.logger.warn("no suitable source found for {} when {}", (Object)entityClass.code(), (Object)context);
            return Source.empty();
        });
    }

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Source<ClassifiedRecord, NotUsed> source(String classifier, IEntityClass entityClass, ExpRel query, Map<String, ExpRel> subQuery, Map<String, Object> context) {
        Source<ClassifiedRecord, NotUsed> mainSource = this.getDependentSource(classifier, entityClass, query, context);
        Set one2ManyCodes = entityClass.relations().stream().filter(x -> FieldLikeRelationType.ONE2MANY.getName().equalsIgnoreCase(x.getRelationType())).map(Relation::getName).collect(Collectors.toSet());
        IEntityClassGroup reader = this.entityService.getReader(entityClass, context);
        return mainSource.flatMapMerge(this.concurrent, (Function & Serializable)i -> {
            Optional<Source> reduce = subQuery.entrySet().stream().map(codeQuery -> {
                IEntityClass relatedEntityClass;
                String relationCode = (String)codeQuery.getKey();
                ExpRel rel = (ExpRel)codeQuery.getValue();
                if (one2ManyCodes.contains(relationCode) && (relatedEntityClass = (IEntityClass)reader.relatedEntityClass(relationCode).orElse(null)) != null) {
                    return this.getDependentSource(relationCode, relatedEntityClass, this.getRelatedRelQuery(relationCode, i.getRecord(), rel), context);
                }
                return null;
            }).filter(Objects::nonNull).reduce(Source::concat);
            if (reduce.isPresent()) {
                return Source.single((Object)i).concat((Graph)reduce.get());
            }
            return Source.single((Object)i);
        });
    }
}

