/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.service.export.impl;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.Relation;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.DateTimeValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import com.xforceplus.ultraman.oqsengine.pojo.reader.record.Record;
import com.xforceplus.ultraman.oqsengine.sdk.facade.EntityFacade;
import com.xforceplus.ultraman.oqsengine.sdk.facade.ProfileFetcher;
import com.xforceplus.ultraman.oqsengine.sdk.facade.result.ResultStatus;
import com.xforceplus.ultraman.oqsengine.sdk.service.DictService;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportCustomFieldToString;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.DictItem;
import io.vavr.control.Either;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExportCustomFieldToString
implements ExportCustomFieldToString {
    private DictService dictService;
    private EntityFacade entityFacade;
    private ProfileFetcher profileFetcher;
    private Logger logger = LoggerFactory.getLogger(DefaultExportCustomFieldToString.class);

    public DefaultExportCustomFieldToString(DictService dictService, EntityFacade entityFacade, ProfileFetcher fetcher) {
        this.dictService = dictService;
        this.entityFacade = entityFacade;
        this.profileFetcher = fetcher;
    }

    @Override
    public boolean isSupport(IEntityClass entityClass, IEntityField field) {
        return true;
    }

    @Override
    public boolean isDefault() {
        return true;
    }

    @Override
    public Optional<String> getString(IEntityClass entityClass, IEntityField entityField, String safeSourceValue, Map<String, Object> context) {
        String retStr = null;
        FieldType type = entityField.type();
        Map mapping = context.getOrDefault("dictCache", new HashMap());
        context.putIfAbsent("dictCache", mapping);
        Map searchTable = context.getOrDefault("search", new HashMap());
        context.putIfAbsent("search", searchTable);
        switch (type) {
            case ENUM: {
                String dictId = entityField.dictId();
                List items = (List)mapping.get(dictId);
                if (items == null) {
                    List dictItems = this.dictService.findDictItems(dictId, null, context);
                    mapping.put(dictId, dictItems);
                    items = dictItems;
                }
                retStr = items.stream().filter(x -> x.getValue().equals(safeSourceValue)).map(DictItem::getText).findAny().orElse(safeSourceValue);
                break;
            }
            case DATETIME: {
                retStr = entityField.type().toTypedValue(entityField, safeSourceValue).map(x -> (DateTimeValue)x).map(x -> ((LocalDateTime)x.getValue()).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"))).orElse("");
                break;
            }
            case STRINGS: {
                if (safeSourceValue.trim().isEmpty()) {
                    retStr = "";
                    break;
                }
                String[] ids = safeSourceValue.split(",");
                Long fieldId = entityField.id();
                Optional<Long> relatedId = entityClass.relations().stream().filter(x -> x.getEntityField() != null).filter(x -> x.getEntityField().id() == fieldId.longValue()).map(Relation::getEntityClassId).findAny();
                if (relatedId.isPresent()) {
                    Optional relatedEntityOp = this.entityFacade.load(relatedId.get().toString(), this.profileFetcher.getProfile(context));
                    if (relatedEntityOp.isPresent()) {
                        IEntityClass relatedEntity = (IEntityClass)relatedEntityOp.get();
                        HashMap cachedList = (HashMap)searchTable.get(relatedId.get().toString());
                        if (cachedList == null) {
                            HashMap cached = new HashMap();
                            searchTable.put(relatedId.get().toString(), cached);
                            cachedList = cached;
                        }
                        HashMap finalCachedList = cachedList;
                        Optional<IEntityField> displayField = relatedEntity.fields().stream().filter(x -> Optional.ofNullable(x.config()).filter(field -> "1".equals(field.getDisplayType())).isPresent()).findFirst();
                        retStr = Stream.of(ids).map(x -> {
                            String name = (String)finalCachedList.get(x);
                            String innerRetStr = x;
                            if (name == null) {
                                if (displayField.isPresent()) {
                                    try {
                                        Either one = ((Either)this.entityFacade.findOneById(relatedEntity, Long.valueOf(Long.parseLong(x)), context).toCompletableFuture().join()).mapLeft(ResultStatus::getMessage);
                                        if (one.isRight()) {
                                            String key = ((IEntityField)displayField.get()).name();
                                            Optional relatedDisplayName = ((Record)one.get()).get(key);
                                            innerRetStr = relatedDisplayName.map(Object::toString).orElse((String)x);
                                        }
                                    }
                                    catch (Exception ex) {
                                        this.logger.error("{}", (Throwable)ex);
                                    }
                                }
                                finalCachedList.put(x, innerRetStr);
                            } else {
                                innerRetStr = name;
                            }
                            return innerRetStr;
                        }).collect(Collectors.joining(","));
                        break;
                    }
                    retStr = safeSourceValue.trim();
                    break;
                }
                if (!StringUtils.isEmpty((CharSequence)entityField.dictId())) {
                    String dictId = entityField.dictId();
                    List items = (List)mapping.get(dictId);
                    if (items == null) {
                        List dictItems = this.dictService.findDictItems(dictId, null, context);
                        mapping.put(dictId, dictItems);
                        items = dictItems;
                    }
                    List finalItems = items;
                    retStr = Stream.of(ids).map(id -> Optional.ofNullable(finalItems).orElseGet(Collections::emptyList).stream().filter(x -> x.getValue().equals(id)).map(DictItem::getText).findAny().orElse((String)id)).collect(Collectors.joining(","));
                    break;
                }
                retStr = safeSourceValue.trim();
                break;
            }
            default: {
                retStr = entityField.type().toTypedValue(entityField, safeSourceValue).map(IValue::getValue).map(Object::toString).orElse("");
            }
        }
        return Optional.ofNullable(retStr);
    }
}

