/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.service.export.impl;

import akka.NotUsed;
import akka.japi.function.Creator;
import akka.japi.function.Function;
import akka.japi.function.Procedure;
import akka.stream.ActorMaterializer;
import akka.stream.Materializer;
import akka.stream.javadsl.Sink;
import akka.stream.javadsl.Source;
import akka.stream.javadsl.StreamConverters;
import akka.util.ByteString;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.ColumnField;
import com.xforceplus.ultraman.oqsengine.pojo.reader.record.Record;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ClassifiedRecord;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportCallBack;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportSchemaConfig;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportSink;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportSource;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportStringTransformer;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.config.ExportExcelConfig;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.impl.AbstractEntityExportService;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.FormulaError;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelEntityExportServiceImpl
extends AbstractEntityExportService {
    private ExportExcelConfig excelConfig;
    private final ActorMaterializer mat;
    private ExecutorService executorService;
    private Logger logger = LoggerFactory.getLogger(ExcelEntityExportServiceImpl.class);

    public ExcelEntityExportServiceImpl(List<ExportSource> exportSourceList, ExportSink exportSink, ExportCallBack callBack, ExportStringTransformer transformer, ExportExcelConfig excelConfig, ActorMaterializer mat, ExecutorService executorService) {
        super(exportSourceList, exportSink, transformer, callBack, mat);
        this.mat = mat;
        this.excelConfig = excelConfig;
        this.executorService = executorService;
    }

    @Override
    public boolean isAccept(String extension) {
        return "xlsx".equals(extension) || "xls".equals(extension);
    }

    @Override
    public boolean isSupportMultiSchema() {
        return true;
    }

    @Override
    public String generateFileType() {
        return "xlsx";
    }

    private void insertCell(Record record, Row row, List<String> orderedColumn, Map<String, Object> context, boolean isSkipTransformer) {
        AtomicInteger ai = new AtomicInteger(0);
        orderedColumn = orderedColumn.stream().map(x -> {
            if (x.startsWith("_")) {
                return x.substring(1);
            }
            return x;
        }).collect(Collectors.toList());
        record.stream(orderedColumn).forEach(x -> {
            ColumnField field = (ColumnField)x._1();
            IEntityClass entityClass = field.originEntityClass();
            Cell cell = row.createCell(ai.getAndIncrement());
            if (x._2() != null) {
                try {
                    String value = x._2.toString();
                    if (!isSkipTransformer) {
                        value = this.getStringValue(entityClass, (IEntityField)field, x._2.toString(), context);
                    }
                    cell.setCellValue(value);
                }
                catch (Exception ex) {
                    this.logger.error("{}", (Throwable)ex);
                    cell.setBlank();
                    cell.setCellErrorValue(FormulaError.VALUE.getCode());
                }
            }
        });
    }

    private void prepareSheet(SXSSFWorkbook wb, List<Tuple2<String, IEntityClass>> entityClasses, Map<String, ExportSchemaConfig> schemaMapping, Map<String, Tuple2<Sheet, AtomicInteger>> sheetMapping) {
        entityClasses.forEach(entityClassTuple -> {
            String sheetCode = (String)entityClassTuple._1();
            Tuple2 sheetTuple = (Tuple2)sheetMapping.get(sheetCode);
            ExportSchemaConfig schemaConfig = (ExportSchemaConfig)schemaMapping.get(sheetCode);
            Map mapping = Optional.ofNullable(schemaConfig).map(ExportSchemaConfig::getNameMapping).orElseGet(Collections::emptyMap);
            String sheetName = Optional.ofNullable(mapping.get(sheetCode)).orElse(sheetCode);
            if (sheetTuple == null) {
                SXSSFSheet sheet = wb.createSheet(sheetName);
                AtomicInteger linesInSheet = new AtomicInteger(1);
                sheetTuple = Tuple.of((Object)sheet, (Object)linesInSheet);
                sheetMapping.put(sheetCode, sheetTuple);
                this.insertHeader((Sheet)sheet, schemaConfig);
            }
        });
    }

    private void insertHeader(Sheet sheet, ExportSchemaConfig schemaConfig) {
        Row row = sheet.createRow(0);
        List<String> orderedColumn = Optional.ofNullable(schemaConfig).map(x -> x.getOrderedColumn()).orElseGet(Collections::emptyList);
        Map nameMappings = Optional.ofNullable(schemaConfig).map(x -> x.getNameMapping()).orElseGet(Collections::emptyMap);
        orderedColumn = orderedColumn.stream().map(x -> x.startsWith("_") ? x.substring(1) : x).collect(Collectors.toList());
        AtomicInteger cellIndex = new AtomicInteger(0);
        orderedColumn.forEach(x -> {
            Cell cell = row.createCell(cellIndex.getAndIncrement());
            String key = x;
            String columnName = Optional.ofNullable(nameMappings).flatMap(np -> Optional.ofNullable(np.get(key))).orElse(x);
            cell.setCellValue(Optional.ofNullable(columnName).orElse(key));
        });
    }

    public Sink<ClassifiedRecord, InputStream> excelSink(List<Tuple2<String, IEntityClass>> entityClasses, Map<String, ExportSchemaConfig> schemaMapping, boolean isSkipTransformer, Map<String, Object> context) {
        SXSSFWorkbook wb = new SXSSFWorkbook(this.excelConfig.getInMemRow().intValue());
        ConcurrentHashMap<String, Tuple2<Sheet, AtomicInteger>> sheetMapping = new ConcurrentHashMap<String, Tuple2<Sheet, AtomicInteger>>(36);
        this.prepareSheet(wb, entityClasses, schemaMapping, sheetMapping);
        PipedOutputStream out = new PipedOutputStream();
        PipedInputStream in = new PipedInputStream();
        try {
            in.connect(out);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        Sink excelSink = Sink.foreach((Procedure & Serializable)tuple -> {
            try {
                String sheetCode = tuple.getClassifyStr();
                Tuple2 sheetTuple = (Tuple2)sheetMapping.get(sheetCode);
                Record record = tuple.getRecord();
                ExportSchemaConfig schemaConfig = (ExportSchemaConfig)schemaMapping.get(sheetCode);
                Map mapping = Optional.ofNullable(schemaConfig).map(ExportSchemaConfig::getNameMapping).orElseGet(Collections::emptyMap);
                List orderedColumn = Optional.ofNullable(schemaConfig).map(x -> x.getOrderedColumn()).orElseGet(Collections::emptyList);
                String sheetName = Optional.ofNullable(mapping.get(sheetCode)).orElse(sheetCode);
                if (sheetTuple == null) {
                    SXSSFSheet sheet = wb.createSheet(sheetName);
                    AtomicInteger linesInSheet = new AtomicInteger(0);
                    sheetTuple = Tuple.of((Object)sheet, (Object)linesInSheet);
                    sheetMapping.put(sheetCode, sheetTuple);
                }
                Row row = ((Sheet)sheetTuple._1).createRow(((AtomicInteger)sheetTuple._2).getAndIncrement());
                this.insertCell(record, row, orderedColumn, context, isSkipTransformer);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }).mapMaterializedValue((Function & Serializable)x -> {
            x.thenRunAsync(() -> {
                try {
                    wb.write((OutputStream)out);
                    wb.close();
                    wb.dispose();
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
                finally {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }, this.executorService);
            return in;
        });
        return excelSink;
    }

    @Override
    public Source<ByteString, ?> toByteStringSource(List<Tuple2<String, IEntityClass>> entityClasses, Source<ClassifiedRecord, NotUsed> rawSource, Map<String, ExportSchemaConfig> schemaMapping, boolean isSkipTransformer, Map<String, Object> context) {
        InputStream inputStreamCompletionStage = (InputStream)rawSource.runWith(this.excelSink(entityClasses, schemaMapping, isSkipTransformer, context), (Materializer)this.mat);
        Source source = StreamConverters.fromInputStream((Creator & Serializable)() -> inputStreamCompletionStage);
        return source;
    }
}

