package com.xforceplus.ultraman.oqsengine.sdk.service.export;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpRel;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ConditionQueryRequest;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.NameMapping;
import io.vavr.control.Either;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

/**
 * Entity export service
 */
public interface EntityExportService {

    boolean isAccept(String extension);

    boolean isSupportMultiSchema();

    String generateFileType();

    CompletableFuture<Either<String, String>> export(
              List<ExportQuery> exportQueries
            , String token
            , String fileName
            , String exportType
            , boolean skipTransformer
            , Map<String, Object> context
            , Map<String, Object> notifyContext);
}
